/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.logs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ml.llm.daemon.insight.logs.InsightsFUSCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "trackingByInsightId", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$TrackingState;", "startTracking", "", "insightId", "stopTracking", "flush", "onGoto", "withinInsightRange", "", "onCaretMove", "logBatchedEvents", "stats", "Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Stats;", "Stats", "TrackingState", "Companion", "intellij.ml.llm.daemon"})
public final class InsightInteractionBatchedEventsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Cache<Long, TrackingState> trackingByInsightId;
    private static final int FLUSH_INTERVAL = 5;

    public InsightInteractionBatchedEventsService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        Cache cache = Caffeine.newBuilder().maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.trackingByInsightId = cache;
    }

    public final void startTracking(long insightId) {
        if (this.trackingByInsightId.getIfPresent((Object)insightId) != null) {
            return;
        }
        Stats stats = new Stats(null, null, null, 7, null);
        Job job2 = BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, insightId, null){
            int label;
            final /* synthetic */ InsightInteractionBatchedEventsService this$0;
            final /* synthetic */ long $insightId;
            {
                this.this$0 = $receiver;
                this.$insightId = $insightId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.this$0.stopTracking(this.$insightId);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.trackingByInsightId.put((Object)insightId, (Object)new TrackingState(stats, job2));
    }

    public final void stopTracking(long insightId) {
        this.flush(insightId);
        TrackingState trackingState = (TrackingState)this.trackingByInsightId.getIfPresent((Object)insightId);
        if (trackingState != null && (trackingState = trackingState.getJob()) != null) {
            Job.DefaultImpls.cancel$default((Job)trackingState, null, (int)1, null);
        }
        this.trackingByInsightId.invalidate((Object)insightId);
    }

    private final void flush(long insightId) {
        Object object = (TrackingState)this.trackingByInsightId.getIfPresent((Object)insightId);
        if (object == null || (object = ((TrackingState)object).getStats()) == null) {
            return;
        }
        Object stats = object;
        this.logBatchedEvents(insightId, (Stats)stats);
    }

    public final void onGoto(long insightId, boolean withinInsightRange) {
        Object stats;
        Object object;
        Object object2 = (TrackingState)this.trackingByInsightId.getIfPresent((Object)insightId);
        if (object2 == null || (object2 = ((TrackingState)object2).getStats()) == null) {
            return;
        }
        Object $this$onGoto_u24lambda_u240 = object = (stats = object2);
        boolean bl = false;
        ((Stats)$this$onGoto_u24lambda_u240).getGotoTotal().incrementAndGet();
        if (withinInsightRange) {
            ((Stats)$this$onGoto_u24lambda_u240).getGotoWithinInsightRange().incrementAndGet();
        }
    }

    public final void onCaretMove(long insightId) {
        Object stats;
        Object object;
        Object object2 = (TrackingState)this.trackingByInsightId.getIfPresent((Object)insightId);
        if (object2 == null || (object2 = ((TrackingState)object2).getStats()) == null) {
            return;
        }
        Object $this$onCaretMove_u24lambda_u240 = object = (stats = object2);
        boolean bl = false;
        ((Stats)$this$onCaretMove_u24lambda_u240).getCaretMoves().incrementAndGet();
    }

    private final void logBatchedEvents(long insightId, Stats stats) {
        if (stats.isEmpty()) {
            return;
        }
        InsightsFUSCollector.INSTANCE.logInteractionBatched(insightId, stats.getGotoTotal().get(), stats.getGotoWithinInsightRange().get(), stats.getCaretMoves().get());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Companion;", "", "<init>", "()V", "FLUSH_INTERVAL", "", "getInstance", "Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService;", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightInteractionBatchedEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightInteractionBatchedEventsService.kt\ncom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,82:1\n42#2,3:83\n*S KotlinDebug\n*F\n+ 1 InsightInteractionBatchedEventsService.kt\ncom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Companion\n*L\n79#1:83,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsightInteractionBatchedEventsService getInstance() {
            boolean $i$f$service = false;
            Class<InsightInteractionBatchedEventsService> serviceClass$iv = InsightInteractionBatchedEventsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (InsightInteractionBatchedEventsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Stats;", "", "gotoTotal", "Ljava/util/concurrent/atomic/AtomicInteger;", "gotoWithinInsightRange", "caretMoves", "<init>", "(Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicInteger;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getGotoTotal", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getGotoWithinInsightRange", "getCaretMoves", "isEmpty", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class Stats {
        @NotNull
        private final AtomicInteger gotoTotal;
        @NotNull
        private final AtomicInteger gotoWithinInsightRange;
        @NotNull
        private final AtomicInteger caretMoves;

        public Stats(@NotNull AtomicInteger gotoTotal, @NotNull AtomicInteger gotoWithinInsightRange, @NotNull AtomicInteger caretMoves) {
            Intrinsics.checkNotNullParameter((Object)gotoTotal, (String)"gotoTotal");
            Intrinsics.checkNotNullParameter((Object)gotoWithinInsightRange, (String)"gotoWithinInsightRange");
            Intrinsics.checkNotNullParameter((Object)caretMoves, (String)"caretMoves");
            this.gotoTotal = gotoTotal;
            this.gotoWithinInsightRange = gotoWithinInsightRange;
            this.caretMoves = caretMoves;
        }

        public /* synthetic */ Stats(AtomicInteger atomicInteger, AtomicInteger atomicInteger2, AtomicInteger atomicInteger3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                atomicInteger = new AtomicInteger(0);
            }
            if ((n & 2) != 0) {
                atomicInteger2 = new AtomicInteger(0);
            }
            if ((n & 4) != 0) {
                atomicInteger3 = new AtomicInteger(0);
            }
            this(atomicInteger, atomicInteger2, atomicInteger3);
        }

        @NotNull
        public final AtomicInteger getGotoTotal() {
            return this.gotoTotal;
        }

        @NotNull
        public final AtomicInteger getGotoWithinInsightRange() {
            return this.gotoWithinInsightRange;
        }

        @NotNull
        public final AtomicInteger getCaretMoves() {
            return this.caretMoves;
        }

        public final boolean isEmpty() {
            return this.gotoTotal.get() == 0 && this.caretMoves.get() == 0;
        }

        @NotNull
        public final AtomicInteger component1() {
            return this.gotoTotal;
        }

        @NotNull
        public final AtomicInteger component2() {
            return this.gotoWithinInsightRange;
        }

        @NotNull
        public final AtomicInteger component3() {
            return this.caretMoves;
        }

        @NotNull
        public final Stats copy(@NotNull AtomicInteger gotoTotal, @NotNull AtomicInteger gotoWithinInsightRange, @NotNull AtomicInteger caretMoves) {
            Intrinsics.checkNotNullParameter((Object)gotoTotal, (String)"gotoTotal");
            Intrinsics.checkNotNullParameter((Object)gotoWithinInsightRange, (String)"gotoWithinInsightRange");
            Intrinsics.checkNotNullParameter((Object)caretMoves, (String)"caretMoves");
            return new Stats(gotoTotal, gotoWithinInsightRange, caretMoves);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, AtomicInteger atomicInteger, AtomicInteger atomicInteger2, AtomicInteger atomicInteger3, int n, Object object) {
            if ((n & 1) != 0) {
                atomicInteger = stats.gotoTotal;
            }
            if ((n & 2) != 0) {
                atomicInteger2 = stats.gotoWithinInsightRange;
            }
            if ((n & 4) != 0) {
                atomicInteger3 = stats.caretMoves;
            }
            return stats.copy(atomicInteger, atomicInteger2, atomicInteger3);
        }

        @NotNull
        public String toString() {
            return "Stats(gotoTotal=" + this.gotoTotal + ", gotoWithinInsightRange=" + this.gotoWithinInsightRange + ", caretMoves=" + this.caretMoves + ")";
        }

        public int hashCode() {
            int result2 = this.gotoTotal.hashCode();
            result2 = result2 * 31 + this.gotoWithinInsightRange.hashCode();
            result2 = result2 * 31 + this.caretMoves.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (!Intrinsics.areEqual((Object)this.gotoTotal, (Object)stats.gotoTotal)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gotoWithinInsightRange, (Object)stats.gotoWithinInsightRange)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.caretMoves, (Object)stats.caretMoves);
        }

        public Stats() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$TrackingState;", "", "stats", "Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Stats;", "job", "Lkotlinx/coroutines/Job;", "<init>", "(Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Stats;Lkotlinx/coroutines/Job;)V", "getStats", "()Lcom/intellij/ml/llm/daemon/insight/logs/InsightInteractionBatchedEventsService$Stats;", "getJob", "()Lkotlinx/coroutines/Job;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class TrackingState {
        @NotNull
        private final Stats stats;
        @NotNull
        private final Job job;

        public TrackingState(@NotNull Stats stats, @NotNull Job job2) {
            Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
            Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
            this.stats = stats;
            this.job = job2;
        }

        @NotNull
        public final Stats getStats() {
            return this.stats;
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        @NotNull
        public final Stats component1() {
            return this.stats;
        }

        @NotNull
        public final Job component2() {
            return this.job;
        }

        @NotNull
        public final TrackingState copy(@NotNull Stats stats, @NotNull Job job2) {
            Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
            Intrinsics.checkNotNullParameter((Object)job2, (String)"job");
            return new TrackingState(stats, job2);
        }

        public static /* synthetic */ TrackingState copy$default(TrackingState trackingState, Stats stats, Job job2, int n, Object object) {
            if ((n & 1) != 0) {
                stats = trackingState.stats;
            }
            if ((n & 2) != 0) {
                job2 = trackingState.job;
            }
            return trackingState.copy(stats, job2);
        }

        @NotNull
        public String toString() {
            return "TrackingState(stats=" + this.stats + ", job=" + this.job + ")";
        }

        public int hashCode() {
            int result2 = this.stats.hashCode();
            result2 = result2 * 31 + this.job.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackingState)) {
                return false;
            }
            TrackingState trackingState = (TrackingState)other;
            if (!Intrinsics.areEqual((Object)this.stats, (Object)trackingState.stats)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.job, (Object)trackingState.job);
        }
    }
}

