/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.ui.BackgroundHighlighterKt;
import com.intellij.ml.llm.daemon.insight.ui.InsightColors;
import com.intellij.ml.llm.daemon.insight.ui.SlidingAppearanceScopeProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.markup.CustomHighlighterOrder;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.util.Disposer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J4\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J,\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;Lcom/intellij/openapi/Disposable;)V", "colorStart", "Ljava/awt/Color;", "getColorStart", "()Ljava/awt/Color;", "transparentColor", "getTransparentColor", "highlighterLayer", "", "getHighlighterLayer", "()I", "disposable", "show", "", "insightInlay", "Lcom/intellij/openapi/editor/Inlay;", "hide", "highlightLinesWithInlay", "startOffset", "endOffset", "scope", "Lkotlinx/coroutines/CoroutineScope;", "doHighlightLinesWithInlay", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "appearanceRatio", "", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nBackgroundHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackgroundHighlighter.kt\ncom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter\n+ 2 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n29#2:189\n13#3:190\n*S KotlinDebug\n*F\n+ 1 BackgroundHighlighter.kt\ncom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter\n*L\n152#1:189\n152#1:190\n*E\n"})
public final class BackgroundHighlighter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final InsightModel insight;
    @NotNull
    private final Disposable parentDisposable;
    @Nullable
    private Disposable disposable;
    private static final int ROUND_ARC = 8;
    private static final long APPEARANCE_DURATION_MS = 250L;
    @NotNull
    private static final InsightEventReporter LOG;

    public BackgroundHighlighter(@NotNull Editor editor2, @NotNull InsightModel insight, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor2;
        this.insight = insight;
        this.parentDisposable = parentDisposable;
    }

    private final Color getColorStart() {
        return InsightColors.INSTANCE.getBACKGROUND_HIGHLIGHT_COLOR();
    }

    private final Color getTransparentColor() {
        return InsightColors.INSTANCE.getTRANSPARENT_BACKGROUND();
    }

    private final int getHighlighterLayer() {
        return 30000;
    }

    public final void show(@NotNull Inlay<?> insightInlay) {
        Intrinsics.checkNotNullParameter(insightInlay, (String)"insightInlay");
        if (this.disposable != null) {
            return;
        }
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        int n = document3.getLineCount();
        int n2 = this.insight.getRange().getStartLine();
        if (!(0 <= n2 ? n2 < n : false) || this.insight.getRange().getEndLine() >= document3.getLineCount()) {
            return;
        }
        Disposable disposable = Disposer.newDisposable((String)("Highlighter for " + this.insight));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)this.parentDisposable, (Disposable)disposable2);
        CoroutineScope scope = SlidingAppearanceScopeProvider.Companion.getInstance().getScope(disposable2);
        this.disposable = disposable2;
        int start2 = this.editor.getDocument().getLineStartOffset(this.insight.getRange().getStartLine());
        int end = this.editor.getDocument().getLineEndOffset(this.insight.getRange().getEndLine());
        this.highlightLinesWithInlay(start2, end, insightInlay, scope, disposable2);
    }

    public final void hide() {
        if (this.disposable == null) {
            return;
        }
        Disposable disposable = this.disposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.dispose((Disposable)disposable);
        this.disposable = null;
    }

    private final void highlightLinesWithInlay(int startOffset, int endOffset, Inlay<?> insightInlay, CoroutineScope scope, Disposable disposable) {
        long initialTime = System.currentTimeMillis();
        Ref.ObjectRef highlighter = new Ref.ObjectRef();
        highlighter.element = this.doHighlightLinesWithInlay(startOffset, endOffset, insightInlay, 0.0f);
        BackgroundHighlighterKt.access$startAlarm-8Mi8wO0(scope, DurationKt.toDuration((int)33, (DurationUnit)DurationUnit.MILLISECONDS), (Function1)new Function1<Continuation<? super Boolean>, Object>((Ref.ObjectRef<RangeHighlighter>)highlighter, initialTime, this, startOffset, endOffset, insightInlay, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<RangeHighlighter> $highlighter;
            final /* synthetic */ long $initialTime;
            final /* synthetic */ BackgroundHighlighter this$0;
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ Inlay<?> $insightInlay;
            {
                this.$highlighter = $highlighter;
                this.$initialTime = $initialTime;
                this.this$0 = $receiver;
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
                this.$insightInlay = $insightInlay;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.$highlighter, this.$initialTime, this.this$0, this.$startOffset, this.$endOffset, this.$insightInlay, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<RangeHighlighter> $highlighter;
                            final /* synthetic */ long $initialTime;
                            final /* synthetic */ BackgroundHighlighter this$0;
                            final /* synthetic */ int $startOffset;
                            final /* synthetic */ int $endOffset;
                            final /* synthetic */ Inlay<?> $insightInlay;
                            {
                                this.$highlighter = $highlighter;
                                this.$initialTime = $initialTime;
                                this.this$0 = $receiver;
                                this.$startOffset = $startOffset;
                                this.$endOffset = $endOffset;
                                this.$insightInlay = $insightInlay;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = com.intellij.openapi.progress.CoroutinesKt.checkCanceled((Continuation)((Continuation)this));
                                        if (v0 == var3_2) {
                                            return var3_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        if (!((RangeHighlighter)this.$highlighter.element).isValid()) {
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        ratio = Math.min(1.0f, (float)(System.currentTimeMillis() - this.$initialTime) / (float)250L);
                                        BackgroundHighlighter.access$getEditor$p(this.this$0).getMarkupModel().removeHighlighter((RangeHighlighter)this.$highlighter.element);
                                        this.$highlighter.element = BackgroundHighlighter.access$doHighlightLinesWithInlay(this.this$0, this.$startOffset, this.$endOffset, this.$insightInlay, ratio);
                                        return Boxing.boxBoolean((boolean)(ratio < 1.0f));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Boolean> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> BackgroundHighlighter.highlightLinesWithInlay$lambda$0(this, highlighter));
    }

    private final RangeHighlighter doHighlightLinesWithInlay(int startOffset, int endOffset, Inlay<?> insightInlay, float appearanceRatio) {
        RangeHighlighter rangeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, this.getHighlighterLayer(), null, HighlighterTargetArea.LINES_IN_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        highlighter.setCustomRenderer(new CustomHighlighterRenderer(insightInlay, appearanceRatio, this){
            final /* synthetic */ Inlay<?> $insightInlay;
            final /* synthetic */ float $appearanceRatio;
            final /* synthetic */ BackgroundHighlighter this$0;
            {
                this.$insightInlay = $insightInlay;
                this.$appearanceRatio = $appearanceRatio;
                this.this$0 = $receiver;
            }

            public CustomHighlighterOrder getOrder() {
                return CustomHighlighterOrder.AFTER_BACKGROUND;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Editor editor2, RangeHighlighter highlighter, Graphics g) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(Math.min(highlighter.getStartOffset(), editor2.getDocument().getTextLength()));
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
                LogicalPosition startLinePosition = logicalPosition;
                LogicalPosition logicalPosition2 = editor2.offsetToLogicalPosition(Math.min(highlighter.getEndOffset(), editor2.getDocument().getTextLength()));
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"offsetToLogicalPosition(...)");
                LogicalPosition endLinePosition = logicalPosition2;
                Object[] objectArray = new Integer[2];
                objectArray[0] = editor2.logicalPositionToXY((LogicalPosition)startLinePosition).y;
                Rectangle rectangle = this.$insightInlay.getBounds();
                objectArray[1] = rectangle != null ? Integer.valueOf(rectangle.y) : null;
                int startY = ((Number)((Object)CollectionsKt.minOrThrow((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)))).intValue();
                int endY = editor2.logicalPositionToXY((LogicalPosition)endLinePosition).y + editor2.getLineHeight();
                if (startY >= endY) {
                    return;
                }
                Object object = g.create();
                Graphics2D graphics2D = object instanceof Graphics2D ? (Graphics2D)object : null;
                if (graphics2D == null) {
                    return;
                }
                Graphics2D g2 = graphics2D;
                try {
                    object = new float[3];
                    object[0] = 0.0f;
                    object[1] = RangesKt.coerceIn((float)this.$appearanceRatio, (float)0.01f, (float)0.99f);
                    object[2] = 1.0f;
                    Color[] colorArray = object;
                    object = new Color[]{BackgroundHighlighter.access$getColorStart(this.this$0), BackgroundHighlighter.access$getTransparentColor(this.this$0), BackgroundHighlighter.access$getTransparentColor(this.this$0)};
                    LinearGradientPaint paint2 = new LinearGradientPaint(0.0f, startY, editor2.getContentComponent().getWidth(), endY, (float[])colorArray, (Color[])object);
                    g2.setPaint(paint2);
                    g2.fillRoundRect(0, startY, editor2.getContentComponent().getWidth(), endY - startY, 8, 8);
                }
                catch (Exception e) {
                    BackgroundHighlighter.access$getLOG$cp().error("Failed to draw background highlight", e);
                }
                finally {
                    g2.dispose();
                }
            }
        });
        return highlighter;
    }

    private static final Unit highlightLinesWithInlay$lambda$0(BackgroundHighlighter this$0, Ref.ObjectRef $highlighter) {
        this$0.editor.getMarkupModel().removeHighlighter((RangeHighlighter)$highlighter.element);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Editor access$getEditor$p(BackgroundHighlighter $this) {
        return $this.editor;
    }

    public static final /* synthetic */ RangeHighlighter access$doHighlightLinesWithInlay(BackgroundHighlighter $this, int startOffset, int endOffset, Inlay insightInlay, float appearanceRatio) {
        return $this.doHighlightLinesWithInlay(startOffset, endOffset, insightInlay, appearanceRatio);
    }

    public static final /* synthetic */ Color access$getColorStart(BackgroundHighlighter $this) {
        return $this.getColorStart();
    }

    public static final /* synthetic */ Color access$getTransparentColor(BackgroundHighlighter $this) {
        return $this.getTransparentColor();
    }

    public static final /* synthetic */ InsightEventReporter access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$thisInsightLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new InsightEventReporter(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter$Companion;", "", "<init>", "()V", "ROUND_ARC", "", "APPEARANCE_DURATION_MS", "", "LOG", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

