/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.daemon.MLLlmDaemonIcons;
import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.rating.InsightRating;
import com.intellij.ml.llm.daemon.insight.ui.AnimationScopeService;
import com.intellij.ml.llm.daemon.insight.ui.BackgroundHighlighter;
import com.intellij.ml.llm.daemon.insight.ui.InsightMenu;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderTextBlock;
import com.intellij.ml.llm.daemon.insight.ui.InsightRendererUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u00102\u001a\u00020\n2\u0006\u00103\u001a\u0002042\n\u00105\u001a\u0006\u0012\u0002\b\u000306J\u0006\u00107\u001a\u000208J\u0012\u00109\u001a\u0002082\b\u0010:\u001a\u0004\u0018\u00010%H\u0002J\u000e\u0010;\u001a\u0002082\u0006\u00103\u001a\u000204J\f\u0010<\u001a\u00020\n*\u000204H\u0002J\u000e\u0010=\u001a\u0004\u0018\u00010%*\u000204H\u0002J\u0014\u0010>\u001a\u00020\u00172\n\u0010?\u001a\u0006\u0012\u0002\b\u000306H\u0016J,\u0010@\u001a\u0002082\n\u0010?\u001a\u0006\u0012\u0002\b\u0003062\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u000208H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001e\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "fadeAnimation", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;Z)V", "getInsight", "()Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "rating", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "getRating", "()Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "insightBlock", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock;", "hovered", "insightIconX", "", "iconY", "insightIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "insightIconHovered", "separatorIconX", "separatorIcon", "optionsTextX", "moreOptionsBlock", "optionsIconX", "optionsIcon", "optionsHovered", "highlightedRatingButton", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "likeX", "dislikeX", "backgroundHighlighter", "Lcom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter;", "insightFadeDurationMs", "", "insightFadeStartMs", "insightAlpha", "", "insightLastRenderedAlpha", "editorPopupHandler", "Lcom/intellij/openapi/editor/ex/EditorPopupHandler;", "processHover", "point", "Ljava/awt/Point;", "insightInlay", "Lcom/intellij/openapi/editor/Inlay;", "processOutOfHover", "", "setRatingHighlightedButton", "button", "processClick", "isOpenSettingsArea", "findRatingButtonUnder", "calcWidthInPixels", "inlay", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "dispose", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightElementRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,241:1\n648#2,5:242\n648#2,5:247\n29#3:252\n13#4:253\n*S KotlinDebug\n*F\n+ 1 InsightElementRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer\n*L\n141#1:242,5\n188#1:247,5\n231#1:252\n231#1:253\n*E\n"})
public final class InsightElementRenderer
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final InsightModel insight;
    private final boolean fadeAnimation;
    @NotNull
    private final InsightRenderTextBlock insightBlock;
    private boolean hovered;
    private int insightIconX;
    private int iconY;
    @NotNull
    private final Icon insightIcon;
    @NotNull
    private final Icon insightIconHovered;
    private int separatorIconX;
    @NotNull
    private final Icon separatorIcon;
    private int optionsTextX;
    @NotNull
    private final InsightRenderTextBlock moreOptionsBlock;
    private int optionsIconX;
    @NotNull
    private final Icon optionsIcon;
    private boolean optionsHovered;
    @Nullable
    private InsightRating.Rating highlightedRatingButton;
    private int likeX;
    private int dislikeX;
    @NotNull
    private final BackgroundHighlighter backgroundHighlighter;
    private final long insightFadeDurationMs;
    private long insightFadeStartMs;
    private float insightAlpha;
    private float insightLastRenderedAlpha;
    @NotNull
    private final EditorPopupHandler editorPopupHandler;
    @NotNull
    private static final InsightEventReporter LOG;

    public InsightElementRenderer(@NotNull Editor editor2, @NotNull Project project2, @NotNull InsightModel insight, boolean fadeAnimation) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
            this.editor = editor2;
            this.project = project2;
            this.insight = insight;
            this.fadeAnimation = fadeAnimation;
            this.insightBlock = new InsightRenderTextBlock(this.editor, InsightRendererUtil.INSTANCE.formatTabs(this.insight.getText(), this.editor), null, 4, null);
            this.insightIconX = -1;
            this.iconY = -1;
            Icon icon2 = MLLlmDaemonIcons.InsightIcon;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InsightIcon");
            this.insightIcon = icon2;
            Icon icon3 = MLLlmDaemonIcons.InsightIconHovered;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InsightIconHovered");
            this.insightIconHovered = icon3;
            this.separatorIconX = -1;
            Icon icon4 = MLLlmDaemonIcons.Separator;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Separator");
            this.separatorIcon = icon4;
            this.optionsTextX = -1;
            this.moreOptionsBlock = new InsightRenderTextBlock(this.editor, InsightRendererUtil.INSTANCE.formatTabs(InsightsBundle.message("insight.menu.more.options", new Object[0]), this.editor), new JBColor(3235773, 7052282));
            this.optionsIconX = -1;
            Icon icon5 = MLLlmDaemonIcons.ChevronDown;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"ChevronDown");
            this.optionsIcon = icon5;
            this.highlightedRatingButton = this.getRating().getRating(this.insight);
            this.likeX = -1;
            this.dislikeX = -1;
            this.backgroundHighlighter = new BackgroundHighlighter(this.editor, this.insight, this);
            this.insightFadeDurationMs = 250L;
            this.insightFadeStartMs = -1L;
            this.insightAlpha = -1.0f;
            this.insightLastRenderedAlpha = -1.0f;
            this.editorPopupHandler = arg_0 -> InsightElementRenderer.editorPopupHandler$lambda$0(this, arg_0);
            if (!(this.insightIcon.getIconWidth() == this.insightIconHovered.getIconWidth())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.insightIcon.getIconHeight() == this.insightIconHovered.getIconHeight())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Editor editor3 = this.editor;
            EditorEx editorEx = editor3 instanceof EditorEx ? (EditorEx)editor3 : null;
            if (editorEx == null) break block2;
            editorEx.installPopupHandler(this.editorPopupHandler);
        }
    }

    @NotNull
    public final InsightModel getInsight() {
        return this.insight;
    }

    private final InsightRating getRating() {
        return InsightRating.Companion.getInstance(this.project);
    }

    public final boolean processHover(@NotNull Point point, @NotNull Inlay<?> insightInlay) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(insightInlay, (String)"insightInlay");
        this.hovered = true;
        this.backgroundHighlighter.show(insightInlay);
        boolean isOptionsHovered = this.isOpenSettingsArea(point);
        if (this.optionsHovered != isOptionsHovered) {
            this.optionsHovered = isOptionsHovered;
            this.editor.getContentComponent().repaint(insightInlay.getBounds());
        }
        return this.optionsHovered;
    }

    public final void processOutOfHover() {
        if (this.hovered) {
            LOG.fire(new InsightEventListener.HoverFinished(this.insight));
        }
        this.hovered = false;
        this.optionsHovered = false;
        this.setRatingHighlightedButton(this.getRating().getRating(this.insight));
        this.backgroundHighlighter.hide();
    }

    private final void setRatingHighlightedButton(InsightRating.Rating button2) {
        if (button2 != this.highlightedRatingButton) {
            this.highlightedRatingButton = button2;
            this.editor.getContentComponent().repaint();
        }
    }

    public final void processClick(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.isOpenSettingsArea(point)) {
            new InsightMenu(point, this.editor, this.project, this.insight, this).show();
        }
    }

    private final boolean isOpenSettingsArea(Point $this$isOpenSettingsArea) {
        int n = this.optionsTextX;
        int n2 = this.optionsIconX + InsightRendererUtil.INSTANCE.getActualIconWidth(this.optionsIcon, InsightRendererUtil.INSTANCE.getTargetIconHeight(this.insightBlock.getFontType()));
        int n3 = $this$isOpenSettingsArea.x;
        return n <= n3 ? n3 <= n2 : false;
    }

    private final InsightRating.Rating findRatingButtonUnder(Point $this$findRatingButtonUnder) {
        Icon icon2 = MLLlmIcons.Like;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Like");
        int iconWidth = InsightRendererUtil.INSTANCE.getActualIconWidth(icon2, InsightRendererUtil.INSTANCE.getTargetIconHeight(this.insightBlock.getFontType()));
        int n = this.likeX;
        int n2 = this.likeX + iconWidth;
        int n3 = $this$findRatingButtonUnder.x;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            return InsightRating.Rating.LIKE;
        }
        n = this.dislikeX;
        n2 = this.dislikeX + iconWidth;
        n3 = $this$findRatingButtonUnder.x;
        boolean bl2 = n <= n3 ? n3 <= n2 : false;
        if (bl2) {
            return InsightRating.Rating.DISLIKE;
        }
        return null;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            String $this$takeWhile$iv = this.insightBlock.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        Font font = this.insightBlock.getFontType();
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(font);
        float iconTargetHeight = InsightRendererUtil.INSTANCE.getTargetIconHeight(font);
        int n = EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length() + InsightRendererUtil.INSTANCE.getActualIconWidth(this.insightIcon, iconTargetHeight) + InsightRendererUtil.INSTANCE.getIconGap() + fontMetrics.stringWidth(StringsKt.drop((String)this.insightBlock.getText(), (int)blankPrefix.length())) + InsightRendererUtil.INSTANCE.getIconGap() + InsightRendererUtil.INSTANCE.getActualIconWidth(this.optionsIcon, iconTargetHeight) + InsightRendererUtil.INSTANCE.getIconGap();
        Icon icon2 = MLLlmIcons.Like;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Like");
        int n3 = n + InsightRendererUtil.INSTANCE.getActualIconHeight(icon2, iconTargetHeight) + InsightRendererUtil.INSTANCE.getIconGap();
        Icon icon3 = MLLlmIcons.Dislike;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Dislike");
        return n3 + InsightRendererUtil.INSTANCE.getActualIconHeight(icon3, iconTargetHeight);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        String string;
        float targetIconHeight;
        block11: {
            Color color;
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (((CharSequence)this.insightBlock.getText()).length() == 0) {
                return;
            }
            if (g instanceof Graphics2D && this.fadeAnimation) {
                float stop2 = 0.999f;
                if (this.insightFadeStartMs < 0L) {
                    BuildersKt.launch$default((CoroutineScope)AnimationScopeService.Companion.getInstance(this.project).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, stop2, inlay, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ InsightElementRenderer this$0;
                        final /* synthetic */ float $stop;
                        final /* synthetic */ Inlay<?> $inlay;
                        {
                            this.this$0 = $receiver;
                            this.$stop = $stop;
                            this.$inlay = $inlay;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = (CoroutineScope)this.L$0;
                            var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
lbl6:
                                    // 3 sources

                                    while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch) && InsightElementRenderer.access$getInsightLastRenderedAlpha$p(this.this$0) < this.$stop) {
                                        InsightElementRenderer.access$setInsightLastRenderedAlpha$p(this.this$0, InsightElementRenderer.access$getInsightAlpha$p(this.this$0));
                                        this.L$0 = $this$launch;
                                        this.label = 1;
                                        v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$inlay, this.this$0, null){
                                            int label;
                                            final /* synthetic */ Inlay<?> $inlay;
                                            final /* synthetic */ InsightElementRenderer this$0;
                                            {
                                                this.$inlay = $inlay;
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        Unit unit;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Rectangle rectangle = this.$inlay.getBounds();
                                                        if (rectangle != null) {
                                                            Rectangle rectangle2 = rectangle;
                                                            InsightElementRenderer insightElementRenderer = this.this$0;
                                                            Rectangle it = rectangle2;
                                                            boolean bl = false;
                                                            InsightElementRenderer.access$getEditor$p(insightElementRenderer).getContentComponent().repaint(it);
                                                            unit = Unit.INSTANCE;
                                                        } else {
                                                            unit = null;
                                                        }
                                                        return unit;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var3_3) {
                                            return var3_3;
                                        }
                                        ** GOTO lbl18
                                    }
                                    break;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl18:
                                    // 2 sources

                                    this.L$0 = $this$launch;
                                    this.label = 2;
                                    v1 = DelayKt.delay((long)33L, (Continuation)((Continuation)this));
                                    if (v1 != var3_3) ** GOTO lbl6
                                    return var3_3;
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
                                    ** GOTO lbl6
                                }
                            }
                            return Unit.INSTANCE;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value2;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
                if (this.insightAlpha < stop2) {
                    if (this.insightFadeStartMs < 0L) {
                        this.insightFadeStartMs = System.currentTimeMillis();
                    }
                    long elapsed2 = System.currentTimeMillis() - this.insightFadeStartMs;
                    this.insightAlpha = RangesKt.coerceIn((float)((float)elapsed2 / (float)this.insightFadeDurationMs), (float)0.0f, (float)1.0f);
                    ((Graphics2D)g).setComposite(AlphaComposite.SrcOver.derive(this.insightAlpha));
                }
            }
            g.setFont(this.insightBlock.getFontType());
            if (!this.hovered) {
                color = this.editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
                if (color == null || (color = color.getForegroundColor()) == null) {
                    color = (Color)this.insightBlock.getForegroundColor();
                }
            } else {
                color = JBUI.CurrentTheme.EditorTabs.underlinedTabForeground();
            }
            g.setColor(color);
            this.iconY = targetRegion.y + g.getFontMetrics().getDescent();
            Font font = g.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            targetIconHeight = InsightRendererUtil.INSTANCE.getTargetIconHeight(font);
            String $this$takeWhile$iv = this.insightBlock.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                int n2 = 0;
                if (CharsKt.isWhitespace((char)it22)) continue;
                String it22 = $this$takeWhile$iv;
                n2 = 0;
                String string2 = it22.substring(n2, index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block11;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        this.insightIconX = targetRegion.x + EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length();
        Icon insightIconToPaint = this.hovered ? this.insightIconHovered : this.insightIcon;
        InsightRendererUtil.INSTANCE.doPaintIcon(insightIconToPaint, this.editor, g, this.insightIconX, this.iconY + 1, targetIconHeight);
        int textX = this.insightIconX + InsightRendererUtil.INSTANCE.getActualIconWidth(insightIconToPaint, targetIconHeight) + InsightRendererUtil.INSTANCE.getIconGap();
        String renderText = StringsKt.removePrefix((String)this.insightBlock.getText(), (CharSequence)blankPrefix);
        g.drawString(renderText, textX, targetRegion.y + this.editor.getAscent());
        if (this.hovered) {
            this.separatorIconX = textX + g.getFontMetrics().stringWidth(renderText) + InsightRendererUtil.INSTANCE.getSeparatorGap();
            InsightRendererUtil.INSTANCE.doPaintIcon(this.separatorIcon, this.editor, g, this.separatorIconX, this.iconY + 1, targetIconHeight);
            Color previousColor = g.getColor();
            g.setColor((Color)this.moreOptionsBlock.getForegroundColor());
            this.optionsTextX = this.separatorIconX + InsightRendererUtil.INSTANCE.getActualIconWidth(this.separatorIcon, targetIconHeight) + InsightRendererUtil.INSTANCE.getSeparatorGap();
            String renderSettingsText = this.moreOptionsBlock.getText();
            g.drawString(renderSettingsText, this.optionsTextX, targetRegion.y + this.editor.getAscent());
            if (this.optionsHovered) {
                int lineY = targetRegion.y + this.editor.getAscent() + 3;
                g.drawLine(this.optionsTextX, lineY, this.optionsTextX + g.getFontMetrics().stringWidth(renderSettingsText), lineY);
            }
            g.setColor(previousColor);
            this.optionsIconX = this.optionsTextX + g.getFontMetrics().stringWidth(renderSettingsText);
            InsightRendererUtil.INSTANCE.doPaintIcon(this.optionsIcon, this.editor, g, this.optionsIconX, this.iconY, targetIconHeight);
        }
    }

    public void dispose() {
        block0: {
            Editor editor2 = this.editor;
            EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
            if (editorEx == null) break block0;
            editorEx.uninstallPopupHandler(this.editorPopupHandler);
        }
    }

    private static final boolean editorPopupHandler$lambda$0(InsightElementRenderer this$0, EditorMouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.hovered;
    }

    public static final /* synthetic */ float access$getInsightLastRenderedAlpha$p(InsightElementRenderer $this) {
        return $this.insightLastRenderedAlpha;
    }

    public static final /* synthetic */ void access$setInsightLastRenderedAlpha$p(InsightElementRenderer $this, float f) {
        $this.insightLastRenderedAlpha = f;
    }

    public static final /* synthetic */ float access$getInsightAlpha$p(InsightElementRenderer $this) {
        return $this.insightAlpha;
    }

    public static final /* synthetic */ Editor access$getEditor$p(InsightElementRenderer $this) {
        return $this.editor;
    }

    static {
        Companion $this$thisInsightLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new InsightEventReporter(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

