/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.daemon.insight.InsightEventListener;
import com.intellij.ml.llm.daemon.insight.InsightEventReporter;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.InsightRange;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightEvent;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightRequest;
import com.intellij.ml.llm.daemon.insight.logs.InsightInteractionBatchedEventsService;
import com.intellij.ml.llm.daemon.insight.ui.InsightElementRenderer;
import com.intellij.ml.llm.daemon.insight.ui.InsightPlaceholderRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u000212B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\bH\u0007J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0002J$\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J \u0010 \u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020%2\u0006\u0010+\u001a\u00020(H\u0002J\b\u0010,\u001a\u00020\u000fH\u0007J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140'2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "current", "", "", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "placeholders", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightPlaceholderRenderer;", "update", "", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightEvent;", "insights", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "processHover", "point", "Ljava/awt/Point;", "processClick", "hideInsight", "insightId", "findInlayUnder", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "removeInvalidated", "removeNoRelevantFromWorkingRange", "event", "addInsight", "insight", "fadeAnimation", "", "updatePlaceholders", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightRequest;", "ranges", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightRange;", "createPlaceholderText", "", "range", "hideAllInsightsAndPlaceholders", "findInsightsAround", "targetLine", "", "linesAround", "Rendering", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 7 InsightEventDispatcher.kt\ncom/intellij/ml/llm/daemon/insight/InsightEventDispatcherKt\n+ 8 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,282:1\n19#2:283\n126#3:284\n153#3,3:285\n126#3:312\n153#3,3:313\n216#3,2:323\n630#3,3:327\n774#4:288\n865#4,2:289\n1869#4,2:291\n1563#4:305\n1634#4,3:306\n774#4:309\n865#4,2:310\n774#4:325\n865#4:326\n866#4:330\n774#4:331\n865#4:332\n2746#4,3:333\n866#4:336\n1869#4,2:337\n1563#4:339\n1634#4,3:340\n504#5,7:293\n488#5,7:316\n648#6,5:300\n29#7:343\n13#8:344\n*S KotlinDebug\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n*L\n103#1:283\n104#1:284\n104#1:285,3\n57#1:312\n57#1:313,3\n69#1:323,2\n192#1:327,3\n104#1:288\n104#1:289,2\n104#1:291,2\n254#1:305\n254#1:306,3\n255#1:309\n255#1:310,2\n191#1:325\n191#1:326\n191#1:330\n193#1:331\n193#1:332\n194#1:333,3\n193#1:336\n195#1:337,2\n212#1:339\n212#1:340,3\n119#1:293,7\n69#1:316,7\n225#1:300,5\n265#1:343\n265#1:344\n*E\n"})
public final class InsightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Map<Long, Rendering> current;
    @NotNull
    private final List<Inlay<InsightPlaceholderRenderer>> placeholders;
    private static final int INLAY_PRIORITY = 1000;
    @NotNull
    private static final Key<InsightRenderer> key;
    @NotNull
    private static final InsightEventReporter LOG;

    public InsightRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.current = new LinkedHashMap();
        this.placeholders = new ArrayList();
    }

    @RequiresEdt
    public final void update(@NotNull InsightEvent request2, @NotNull Map<Long, InsightModel> insights) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        if (this.editor.isDisposed()) {
            return;
        }
        EditorScrollingPositionKeeper.perform((Editor)this.editor, (boolean)true, () -> InsightRenderer.update$lambda$0(this, request2, insights));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void processHover(@NotNull Point point) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        InsightElementRenderer it;
        void $this$mapTo$iv$iv;
        InsightElementRenderer renderer2;
        Inlay<InsightElementRenderer> insightInlay;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Inlay<InsightElementRenderer> inlay = insightInlay = this.findInlayUnder(point);
        InsightElementRenderer insightElementRenderer = renderer2 = inlay != null ? (InsightElementRenderer)inlay.getRenderer() : null;
        boolean isButtonUnder = insightElementRenderer != null ? insightElementRenderer.processHover(point, insightInlay) : false;
        Cursor cursor = isButtonUnder ? Cursor.getPredefinedCursor(12) : (renderer2 != null ? Cursor.getPredefinedCursor(0) : null);
        Editor $this$asSafely$iv = this.editor;
        boolean $i$f$asSafely22 = false;
        Editor editor2 = $this$asSafely$iv;
        if (!(editor2 instanceof EditorEx)) {
            editor2 = null;
        }
        EditorEx editorEx = (EditorEx)editor2;
        if (editorEx != null) {
            editorEx.setCustomCursor(InsightRenderer.class, cursor);
        }
        Object $this$map$iv = this.current;
        boolean $i$f$map = false;
        Map<Long, Rendering> $i$f$asSafely22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((InsightElementRenderer)((Rendering)it.getValue()).getInlay().getRenderer());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (InsightElementRenderer)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it != renderer2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InsightElementRenderer it2 = (InsightElementRenderer)element$iv;
            boolean bl = false;
            it2.processOutOfHover();
        }
    }

    @RequiresEdt
    public final void processClick(@NotNull Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Object object = this.findInlayUnder(point);
            if (object == null || (object = (InsightElementRenderer)object.getRenderer()) == null) break block0;
            ((InsightElementRenderer)object).processClick(point);
        }
    }

    @RequiresEdt
    public final void hideInsight(long insightId) {
        Rendering rendering = this.current.remove(insightId);
        if (rendering == null) {
            return;
        }
        Rendering rendering2 = rendering;
        rendering2.disposeInlay();
    }

    private final Inlay<InsightElementRenderer> findInlayUnder(Point point) {
        Map<Long, Rendering> $this$filterValues$iv = this.current;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Long, Rendering> result$iv = new LinkedHashMap<Long, Rendering>();
        for (Map.Entry<Long, Rendering> entry$iv : $this$filterValues$iv.entrySet()) {
            Rendering it = entry$iv.getValue();
            boolean bl = false;
            Rectangle rectangle = it.getInlay().getBounds();
            boolean bl2 = rectangle != null ? rectangle.contains(point) : false;
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Rendering rendering = (Rendering)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        return rendering != null ? rendering.getInlay() : null;
    }

    private final void removeInvalidated() {
        InsightRenderer $this$removeInvalidated_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<Map.Entry<Long, Rendering>> iter = $this$removeInvalidated_u24lambda_u240.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            if (current.getValue().getInlay().isValid()) continue;
            iter.remove();
            current.getValue().disposeInlay();
        }
        InsightRenderer $this$removeInvalidated_u24lambda_u241 = this;
        boolean bl2 = false;
        iter = $this$removeInvalidated_u24lambda_u241.placeholders.iterator();
        while (iter.hasNext()) {
            Inlay placeholder = (Inlay)iter.next();
            if (placeholder.isValid()) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)placeholder));
            Disposer.dispose((Disposable)((Disposable)placeholder.getRenderer()));
        }
    }

    private final void removeNoRelevantFromWorkingRange(InsightEvent event2, Map<Long, InsightModel> insights) {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            int lineNumber = event2.getDocument().getLineNumber(current.getValue().getInlay().getOffset());
            if (!event2.getWorkingRange().containsLine(lineNumber) || insights.containsKey(current.getKey())) continue;
            iter.remove();
            current.getValue().disposeInlay();
        }
    }

    private final void addInsight(InsightEvent event2, InsightModel insight, boolean fadeAnimation) {
        if (this.editor.isDisposed()) {
            return;
        }
        InsightElementRenderer renderer2 = new InsightElementRenderer(event2.getEditor(), event2.getProject(), insight, fadeAnimation);
        Inlay inlay = event2.getEditor().getInlayModel().addBlockElement(event2.getDocument().getLineEndOffset(insight.getRange().getStartLine()), false, true, 1000, (EditorCustomElementRenderer)renderer2);
        if (inlay == null) {
            InsightRenderer $this$addInsight_u24lambda_u240 = this;
            boolean bl = false;
            Disposer.dispose((Disposable)renderer2);
            return;
        }
        Inlay inlay2 = inlay;
        if (event2.getEditor() instanceof EditorImpl) {
            Disposer.register((Disposable)((EditorImpl)event2.getEditor()).getDisposable(), (Disposable)renderer2);
        }
        LOG.fire(new InsightEventListener.InsightRendered(insight));
        this.current.put(insight.getId(), new Rendering((Inlay<InsightElementRenderer>)inlay2));
    }

    @RequiresEdt
    public final void updatePlaceholders(@NotNull InsightRequest request2, @NotNull List<InsightRange> ranges2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(ranges2, (String)"ranges");
        if (this.editor.isDisposed()) {
            return;
        }
        EditorScrollingPositionKeeper.perform((Editor)this.editor, (boolean)true, () -> InsightRenderer.updatePlaceholders$lambda$0(this, request2, ranges2));
    }

    private final String createPlaceholderText(InsightRequest request2, InsightRange range) {
        String string;
        block1: {
            int startOffset = request2.getDocument().getLineStartOffset(range.getStartLine());
            int endOffset = request2.getDocument().getLineEndOffset(range.getStartLine());
            String string2 = request2.getDocument().getText(new TextRange(startOffset, endOffset));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String $this$takeWhile$iv = string2;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string3 = $this$takeWhile$iv;
                int n2 = 0;
                String string4 = string3.substring(n2, index$iv);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        String indent = string;
        return indent + InsightsBundle.message("insight.placeholder.generating.message", new Object[0]);
    }

    @RequiresEdt
    public final void hideAllInsightsAndPlaceholders() {
        InsightRenderer $this$hideAllInsightsAndPlaceholders_u24lambda_u240 = this;
        boolean bl = false;
        Iterator<Map.Entry<Long, Rendering>> iter = $this$hideAllInsightsAndPlaceholders_u24lambda_u240.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            iter.remove();
            current.getValue().disposeInlay();
        }
        InsightRenderer $this$hideAllInsightsAndPlaceholders_u24lambda_u241 = this;
        boolean bl2 = false;
        iter = $this$hideAllInsightsAndPlaceholders_u24lambda_u241.placeholders.iterator();
        while (iter.hasNext()) {
            Inlay placeholder = (Inlay)iter.next();
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)placeholder));
            Disposer.dispose((Disposable)((Disposable)placeholder.getRenderer()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final List<InsightModel> findInsightsAround(int targetLine, int linesAround) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.current.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Rendering rendering = (Rendering)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((InsightElementRenderer)it.getInlay().getRenderer()).getInsight());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            InsightModel insight = (InsightModel)element$iv$iv;
            boolean bl = false;
            int windowStartLine = RangesKt.coerceAtLeast((int)(insight.getRange().getStartLine() - linesAround), (int)0);
            int windowEndLine = RangesKt.coerceAtMost((int)(insight.getRange().getEndLine() + linesAround), (int)(this.editor.getDocument().getLineCount() - 1));
            boolean bl2 = windowStartLine <= targetLine ? targetLine <= windowEndLine : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void update$lambda$0(InsightRenderer this$0, InsightEvent $request, Map $insights) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = this$0.editor == $request.getEditor();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int previousInsightsCount = this$0.current.size();
        int previousPlaceholdersCount = this$0.placeholders.size();
        long startTime = System.currentTimeMillis();
        this$0.removeInvalidated();
        this$0.removeNoRelevantFromWorkingRange($request, $insights);
        Set removedPlaceholderLines = new LinkedHashSet();
        InsightRenderer $this$update_u24lambda_u240_u240 = this$0;
        boolean bl3 = false;
        Iterator<Object> iter = $this$update_u24lambda_u240_u240.placeholders.iterator();
        Map map2 = $insights;
        boolean $i$f$map = false;
        Map map3 = map2;
        Collection destination$iv$iv = new ArrayList(map2.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(((InsightModel)it.getValue()).getRange().getStartLine());
        }
        Set insightsStartRanges = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        while (iter.hasNext()) {
            Inlay<InsightPlaceholderRenderer> inlay = iter.next();
            int lineNumber = $request.getDocument().getLineNumber(inlay.getOffset());
            if (!insightsStartRanges.contains(lineNumber)) continue;
            removedPlaceholderLines.add(lineNumber);
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)inlay));
            Disposer.dispose((Disposable)((Disposable)inlay.getRenderer()));
        }
        Map $this$filterKeys$iv = $insights;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            long it = ((Number)entry.getKey()).longValue();
            boolean bl5 = false;
            if (!(!this$0.current.containsKey(it))) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl6 = false;
            this$0.addInsight($request, (InsightModel)entry.getValue(), removedPlaceholderLines.contains(((InsightModel)entry.getValue()).getRange().getStartLine()));
            InsightInteractionBatchedEventsService.Companion.getInstance().startTracking(((InsightModel)entry.getValue()).getId());
        }
        int insightsChanged = this$0.current.size() - previousInsightsCount;
        int placeholdersChanged = this$0.placeholders.size() - previousPlaceholdersCount;
        if (insightsChanged != 0 || placeholdersChanged != 0) {
            LOG.fire(new InsightEventListener.VisibleInlaysUpdated(this$0.current.size(), this$0.placeholders.size(), insightsChanged, placeholdersChanged, DurationKt.toDuration((long)(System.currentTimeMillis() - startTime), (DurationUnit)DurationUnit.MILLISECONDS), null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void updatePlaceholders$lambda$0(InsightRenderer this$0, InsightRequest $request, List $ranges) {
        Iterable inlay;
        Iterator<Map.Entry<Long, Rendering>> iterator2;
        boolean $i$f$none;
        Object $this$none$iv;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        boolean bl;
        this$0.removeInvalidated();
        boolean bl2 = bl = this$0.editor == $request.getEditor();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$filter$iv = $ranges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            block12: {
                element$iv$iv = iterator.next();
                InsightRange range = (InsightRange)element$iv$iv;
                boolean bl4 = false;
                $this$none$iv = this$0.current;
                $i$f$none = false;
                if ($this$none$iv.isEmpty()) {
                    bl3 = true;
                } else {
                    iterator2 = $this$none$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Long, Rendering> entry;
                        Map.Entry<Long, Rendering> it = entry = iterator2.next();
                        boolean bl5 = false;
                        if (!($request.getDocument().getLineNumber(it.getValue().getInlay().getOffset()) == range.getStartLine())) continue;
                        bl3 = false;
                        break block12;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl4;
            block13: {
                element$iv$iv = iterator.next();
                InsightRange it = (InsightRange)element$iv$iv;
                boolean bl7 = false;
                $this$none$iv = this$0.placeholders;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    iterator2 = $this$none$iv.iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<Long, Rendering> entry = iterator2.next();
                        Inlay inlay2 = (Inlay)entry;
                        boolean bl8 = false;
                        if (!($request.getDocument().getLineNumber(inlay2.getOffset()) == it.getStartLine())) continue;
                        bl4 = false;
                        break block13;
                    }
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            InsightRange it = (InsightRange)element$iv3;
            boolean bl9 = false;
            InsightPlaceholderRenderer renderer2 = new InsightPlaceholderRenderer($request.getEditor(), this$0.createPlaceholderText($request, it));
            if ($request.getEditor().getInlayModel().addBlockElement($request.getDocument().getLineEndOffset(it.getStartLine()), false, true, 1000, (EditorCustomElementRenderer)renderer2) == null) continue;
            this$0.placeholders.add((Inlay<InsightPlaceholderRenderer>)inlay);
        }
        InsightRenderer $this$updatePlaceholders_u24lambda_u240_u243 = this$0;
        boolean bl10 = false;
        Iterator<Inlay<InsightPlaceholderRenderer>> iter = $this$updatePlaceholders_u24lambda_u240_u243.placeholders.iterator();
        while (iter.hasNext()) {
            void $this$mapTo$iv$iv;
            Inlay<InsightPlaceholderRenderer> placeholder = iter.next();
            Iterable $this$map$iv = $ranges;
            boolean $i$f$map = false;
            inlay = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                InsightRange insightRange = (InsightRange)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl11 = false;
                collection.add(insightRange.getStartLine());
            }
            if (((List)destination$iv$iv2).contains($request.getDocument().getLineNumber(placeholder.getOffset()))) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)placeholder));
            Disposer.dispose((Disposable)((Disposable)placeholder.getRenderer()));
        }
    }

    static {
        Key key = Key.create((String)"InsightRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        InsightRenderer.key = key;
        Companion $this$thisInsightLogger$iv = Companion;
        boolean $i$f$thisInsightLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new InsightEventReporter(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion;", "", "<init>", "()V", "INLAY_PRIORITY", "", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/ml/llm/daemon/insight/InsightEventReporter;", "getOrCreate", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOrNull", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final InsightRenderer getOrCreate(@NotNull Editor editor2) {
            InsightRenderer insightRenderer;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            InsightRenderer insightRenderer2 = (InsightRenderer)editor2.getUserData(key);
            if (insightRenderer2 != null) {
                InsightRenderer it = insightRenderer2;
                boolean bl = false;
                return it;
            }
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.getOrCreate$lambda$1(editor2));
            InsightRenderer it = insightRenderer = new InsightRenderer(editor2);
            boolean bl = false;
            editor2.putUserData(key, (Object)it);
            return insightRenderer;
        }

        @RequiresEdt
        @Nullable
        public final InsightRenderer getOrNull(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (InsightRenderer)editor2.getUserData(key);
        }

        private static final void getOrCreate$lambda$1(Editor $editor) {
            $editor.putUserData(key, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "<init>", "(Lcom/intellij/openapi/editor/Inlay;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "disposeInlay", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class Rendering {
        @NotNull
        private final Inlay<InsightElementRenderer> inlay;

        public Rendering(@NotNull Inlay<InsightElementRenderer> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            this.inlay = inlay;
        }

        @NotNull
        public final Inlay<InsightElementRenderer> getInlay() {
            return this.inlay;
        }

        public final void disposeInlay() {
            InsightInteractionBatchedEventsService.Companion.getInstance().stopTracking(((InsightElementRenderer)this.inlay.getRenderer()).getInsight().getId());
            Disposer.dispose((Disposable)((Disposable)this.inlay));
            Disposer.dispose((Disposable)((Disposable)this.inlay.getRenderer()));
        }

        @NotNull
        public final Inlay<InsightElementRenderer> component1() {
            return this.inlay;
        }

        @NotNull
        public final Rendering copy(@NotNull Inlay<InsightElementRenderer> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return new Rendering(inlay);
        }

        public static /* synthetic */ Rendering copy$default(Rendering rendering, Inlay inlay, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = rendering.inlay;
            }
            return rendering.copy(inlay);
        }

        @NotNull
        public String toString() {
            return "Rendering(inlay=" + this.inlay + ")";
        }

        public int hashCode() {
            return this.inlay.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rendering)) {
                return false;
            }
            Rendering rendering = (Rendering)other;
            return Intrinsics.areEqual(this.inlay, rendering.inlay);
        }
    }
}

