/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J6\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRendererUtil;", "", "<init>", "()V", "ICON_SCALE_FACTOR", "", "iconGap", "", "getIconGap", "()I", "separatorGap", "getSeparatorGap", "getIconScale", "icon", "Ljavax/swing/Icon;", "targetHeight", "getActualIconWidth", "getActualIconHeight", "getTargetIconHeight", "font", "Ljava/awt/Font;", "doPaintIcon", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "x", "y", "formatTabs", "", "text", "ceilToInt", "value", "intellij.ml.llm.daemon"})
public final class InsightRendererUtil {
    @NotNull
    public static final InsightRendererUtil INSTANCE = new InsightRendererUtil();
    private static final float ICON_SCALE_FACTOR = 1.1f;

    private InsightRendererUtil() {
    }

    public final int getIconGap() {
        return JBUI.scale((int)4);
    }

    public final int getSeparatorGap() {
        return JBUI.scale((int)8);
    }

    public final float getIconScale(@NotNull Icon icon2, float targetHeight) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        return targetHeight / (float)icon2.getIconHeight() * 1.1f;
    }

    public final int getActualIconWidth(@NotNull Icon icon2, float targetHeight) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        return this.ceilToInt((float)icon2.getIconWidth() * this.getIconScale(icon2, targetHeight));
    }

    public final int getActualIconHeight(@NotNull Icon icon2, float targetHeight) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        return this.ceilToInt((float)icon2.getIconHeight() * this.getIconScale(icon2, targetHeight));
    }

    public final float getTargetIconHeight(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return font.getSize2D();
    }

    public final void doPaintIcon(@NotNull Icon icon2, @NotNull Editor editor2, @NotNull Graphics g, int x, int y, float targetHeight) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Icon scaledIcon = IconUtil.scale((Icon)icon2, (Component)editor2.getContentComponent(), (float)this.getIconScale(icon2, targetHeight));
        scaledIcon.paintIcon(editor2.getContentComponent(), g, x, y);
    }

    @NotNull
    public final String formatTabs(@NotNull String text2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int tabSize = editor2.getSettings().getTabSize(editor2.getProject());
        String tab = StringsKt.repeat((CharSequence)" ", (int)tabSize);
        return StringsKt.replace$default((String)text2, (String)"\t", (String)tab, (boolean)false, (int)4, null);
    }

    private final int ceilToInt(float value2) {
        return (int)Math.ceil((double)value2 + 0.01);
    }
}

