/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.data.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import com.intellij.dataspell.llm.DataSpellWorkspaceContextLlmFacade;
import com.intellij.ml.llm.ds.agents.DataSpellAgentContext;
import com.intellij.ml.llm.ds.agents.base.tools.DataSpellTool;
import com.intellij.ml.llm.ds.agents.data.DataAgentContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/ds/agents/data/tools/ListAttachedFilesTool;", "Lcom/intellij/ml/llm/ds/agents/base/tools/DataSpellTool;", "Lcom/intellij/ml/llm/ds/agents/data/DataAgentContext;", "Lai/koog/agents/core/tools/ToolArgs$Empty;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/agents/data/DataAgentContext;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "description", "", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lai/koog/agents/core/tools/ToolArgs$Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nListAttachedFilesTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListAttachedFilesTool.kt\ncom/intellij/ml/llm/ds/agents/data/tools/ListAttachedFilesTool\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,61:1\n30#2,2:62\n*S KotlinDebug\n*F\n+ 1 ListAttachedFilesTool.kt\ncom/intellij/ml/llm/ds/agents/data/tools/ListAttachedFilesTool\n*L\n40#1:62,2\n*E\n"})
public final class ListAttachedFilesTool
extends DataSpellTool<DataAgentContext, ToolArgs.Empty> {
    @NotNull
    private final KSerializer<ToolArgs.Empty> argsSerializer;
    @NotNull
    private final String description;

    public ListAttachedFilesTool(@NotNull DataAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellAgentContext)context2);
        this.argsSerializer = ToolArgs.Empty.Companion.serializer();
        this.description = "List all files currently attached to the Data Toolwindow.\nThis tool returns a list of all files that are currently attached to the Data Toolwindow.\nIt can be used to determine which files are available when the user wants to perform operations on them,\nsuch as removing a file from the Data Toolwindow. This also can be used to determine the file that was mentioned\nby user if they did it in a free form.";
    }

    @NotNull
    public KSerializer<ToolArgs.Empty> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return new ToolDescriptor("list_files_attached", this.getDescription(), null, null, 12, null);
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull ToolArgs.Empty args, @NotNull Continuation<? super String> $completion) {
        ComponentManager $this$service$iv = (ComponentManager)((DataAgentContext)this.getContext()).getProject();
        boolean $i$f$service = false;
        Class<DataSpellWorkspaceContextLlmFacade> serviceClass$iv = DataSpellWorkspaceContextLlmFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DataSpellWorkspaceContextLlmFacade facade = (DataSpellWorkspaceContextLlmFacade)object;
        List files = facade.getConnectedData().getFiles();
        if (files.isEmpty()) {
            return "No files are currently attached to the Data Toolwindow.";
        }
        String filesList = CollectionsKt.joinToString$default((Iterable)files, (CharSequence)"\n", null, null, (int)0, null, ListAttachedFilesTool::doExecuteImpl$lambda$0, (int)30, null);
        return StringsKt.trimMargin$default((String)("\n        |The following files are currently attached to the Data Toolwindow:\n        |\n        |" + filesList + "\n        |\n        |You can use this information to help the user manage their attached files.\n        "), null, (int)1, null);
    }

    private static final CharSequence doExecuteImpl$lambda$0(VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return "- " + file2.getPath();
    }
}

