/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.export;

import com.intellij.dataWrangler.llm.DataWranglerFacade;
import com.intellij.dataspell.llm.DataSpellApiLlmFacade;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.ds.agents.DataSpellAgentType;
import com.intellij.ml.llm.ds.agents.base.DataSpellAgentBase;
import com.intellij.ml.llm.ds.agents.export.ExportAgentContext;
import com.intellij.ml.llm.ds.agents.export.ExportAgentSupport;
import com.intellij.ml.llm.ds.agents.export.model.ExportModel;
import com.intellij.ml.llm.ds.agents.export.model.SelectedExistingFileModel;
import com.intellij.ml.llm.ds.agents.export.model.SelectedFileModel;
import com.intellij.ml.llm.ds.agents.export.model.SelectedSimpleFileModel;
import com.intellij.ml.llm.ds.chat.message.DataSpellChatMessage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/ds/agents/export/ExportAgent;", "Lcom/intellij/ml/llm/ds/agents/base/DataSpellAgentBase;", "Lcom/intellij/ml/llm/ds/agents/export/ExportAgentContext;", "<init>", "()V", "type", "Lcom/intellij/ml/llm/ds/agents/DataSpellAgentType;", "getType", "()Lcom/intellij/ml/llm/ds/agents/DataSpellAgentType;", "createContext", "project", "Lcom/intellij/openapi/project/Project;", "answerMessage", "Lcom/intellij/ml/llm/ds/chat/message/DataSpellChatMessage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/ds/chat/message/DataSpellChatMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createModel", "Lcom/intellij/ml/llm/ds/agents/export/model/ExportModel;", "findSelectedFile", "Lcom/intellij/ml/llm/ds/agents/export/model/SelectedFileModel;", "createSupport", "Lcom/intellij/ml/llm/ds/agents/export/ExportAgentSupport;", "context", "history", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "getGridId", "", "grid", "Ljava/lang/Object;", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nExportAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportAgent.kt\ncom/intellij/ml/llm/ds/agents/export/ExportAgent\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n30#2,2:59\n30#2,2:61\n1#3:63\n*S KotlinDebug\n*F\n+ 1 ExportAgent.kt\ncom/intellij/ml/llm/ds/agents/export/ExportAgent\n*L\n29#1:59,2\n43#1:61,2\n*E\n"})
public final class ExportAgent
extends DataSpellAgentBase<ExportAgentContext> {
    @NotNull
    public static final ExportAgent INSTANCE = new ExportAgent();

    private ExportAgent() {
    }

    @Override
    @NotNull
    public DataSpellAgentType getType() {
        return DataSpellAgentType.EXPORT;
    }

    @Override
    @Nullable
    protected Object createContext(@NotNull Project project2, @NotNull DataSpellChatMessage answerMessage, @NotNull Continuation<? super ExportAgentContext> $completion) {
        ExportModel exportModel = this.createModel(project2);
        return new ExportAgentContext(project2, this.getType(), answerMessage, exportModel);
    }

    private final ExportModel createModel(Project project2) {
        SelectedFileModel selectedFile = this.findSelectedFile(project2);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<DataSpellApiLlmFacade> serviceClass$iv = DataSpellApiLlmFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DataSpellApiLlmFacade facade = (DataSpellApiLlmFacade)object;
        List jupyterExportFormats = facade.getJupyterExportFormats();
        List dataExportFormats = facade.getDataExportFormats();
        return new ExportModel(selectedFile, jupyterExportFormats, dataExportFormats);
    }

    private final SelectedFileModel findSelectedFile(Project project2) {
        Path directoryPath;
        Path filePath;
        Object object;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor();
        if (fileEditor == null) {
            return null;
        }
        FileEditor fileEditor2 = fileEditor;
        VirtualFile virtualFile2 = fileEditor2.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service22 = false;
        Class<DataWranglerFacade> serviceClass$iv = DataWranglerFacade.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        boolean containsGrid = ((DataWranglerFacade)object2).findDataGrid() != null;
        Object $i$f$service22 = this;
        try {
            ExportAgent $this$findSelectedFile_u24lambda_u240 = $i$f$service22;
            boolean bl = false;
            object = Result.constructor-impl((Object)file2.toNioPath());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        $i$f$service22 = object;
        Path path = filePath = (Path)(Result.isFailure-impl((Object)$i$f$service22) ? null : $i$f$service22);
        Path path2 = directoryPath = path != null ? path.getParent() : null;
        if (directoryPath != null) {
            return new SelectedExistingFileModel(directoryPath, filePath, containsGrid);
        }
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new SelectedSimpleFileModel(string, containsGrid);
    }

    @NotNull
    protected ExportAgentSupport createSupport(@NotNull ExportAgentContext context2, @NotNull List<? extends ChatMessage> history) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        return new ExportAgentSupport(context2, history);
    }

    public final int getGridId(@NotNull Object grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return System.identityHashCode(grid);
    }
}

