/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.jupyter.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.ml.llm.ds.agents.DataSpellAgentContext;
import com.intellij.ml.llm.ds.agents.base.tools.DataSpellTool;
import com.intellij.ml.llm.ds.agents.jupyter.JupyterAgentContext;
import com.intellij.ml.llm.ds.agents.jupyter.operations.JupyterOperation;
import com.intellij.ml.llm.ds.agents.jupyter.tools.CreateDataImportCellFromDatabaseTool;
import com.intellij.ml.llm.ds.agents.jupyter.tools.CreateSqlCellTool$Args$;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool;", "Lcom/intellij/ml/llm/ds/agents/base/tools/DataSpellTool;", "Lcom/intellij/ml/llm/ds/agents/jupyter/JupyterAgentContext;", "Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool$Args;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/agents/jupyter/JupyterAgentContext;)V", "description", "", "getDescription", "()Ljava/lang/String;", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "intellij.ml.llm.ds"})
public final class CreateSqlCellTool
extends DataSpellTool<JupyterAgentContext, Args> {
    public CreateSqlCellTool(@NotNull JupyterAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellAgentContext)context2);
    }

    @NotNull
    public String getDescription() {
        return StringsKt.trimIndent((String)("\n        Creates an SQL cell in a Jupyter notebook with the given content.\n\n        If no SQL query is specified, empty SQL cell will be created.\n\n        Available database sources are provided below:\n        " + CreateDataImportCellFromDatabaseTool.Companion.getDataSourcesInformation((JupyterAgentContext)this.getContext()) + "\n\n        User can refer to its schemaName or tableName. Use their data source name to create this cell.\n      "));
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return Args.Companion.serializer();
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        Object[] objectArray = new ToolParameterDescriptor[]{new ToolParameterDescriptor("source", "the SQL query content of the cell", (ToolParameterType)ToolParameterType.String.INSTANCE), new ToolParameterDescriptor("data_source_name", "the name of the data source to use for the SQL query", (ToolParameterType)ToolParameterType.String.INSTANCE), new ToolParameterDescriptor("output_dataframe_name", "the variable name to store the SQL query result", (ToolParameterType)ToolParameterType.String.INSTANCE), new ToolParameterDescriptor("at_the_end", "A parameter indicating that the user requested to create a cell at the end of the notebook. If you don't have this information, omit this value.", (ToolParameterType)ToolParameterType.Boolean.INSTANCE)};
        return new ToolDescriptor("create_sql_cell", this.getDescription(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        boolean isPrimary = ((JupyterAgentContext)this.getContext()).hasNotCreateCellOperations();
        JupyterAgentContext jupyterAgentContext = (JupyterAgentContext)this.getContext();
        String string = args.getSource();
        if (string == null) {
            string = "";
        }
        jupyterAgentContext.addOperation(new JupyterOperation.CreateSqlCell(string, args.getDataSourceName(), args.getOutputDataframeName(), isPrimary, args.getAtTheEnd()));
        return "Success: SQL cell prepared";
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002\"#B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tBA\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0001\u00a2\u0006\u0002\b!R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "source", "", "outputDataframeName", "dataSourceName", "atTheEnd", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSource$annotations", "()V", "getSource", "()Ljava/lang/String;", "getOutputDataframeName$annotations", "getOutputDataframeName", "getDataSourceName$annotations", "getDataSourceName", "getAtTheEnd$annotations", "getAtTheEnd", "()Z", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds", "$serializer", "Companion", "intellij.ml.llm.ds"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String source;
        @Nullable
        private final String outputDataframeName;
        @Nullable
        private final String dataSourceName;
        private final boolean atTheEnd;

        public Args(@Nullable String source, @Nullable String outputDataframeName, @Nullable String dataSourceName, boolean atTheEnd) {
            this.source = source;
            this.outputDataframeName = outputDataframeName;
            this.dataSourceName = dataSourceName;
            this.atTheEnd = atTheEnd;
        }

        public /* synthetic */ Args(String string, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            this(string, string2, string3, bl);
        }

        @Nullable
        public final String getSource() {
            return this.source;
        }

        @SerialName(value="source")
        public static /* synthetic */ void getSource$annotations() {
        }

        @Nullable
        public final String getOutputDataframeName() {
            return this.outputDataframeName;
        }

        @SerialName(value="output_dataframe_name")
        public static /* synthetic */ void getOutputDataframeName$annotations() {
        }

        @Nullable
        public final String getDataSourceName() {
            return this.dataSourceName;
        }

        @SerialName(value="data_source_name")
        public static /* synthetic */ void getDataSourceName$annotations() {
        }

        public final boolean getAtTheEnd() {
            return this.atTheEnd;
        }

        @SerialName(value="at_the_end")
        public static /* synthetic */ void getAtTheEnd$annotations() {
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.source);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.outputDataframeName != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.outputDataframeName);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.dataSourceName != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.dataSourceName);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.atTheEnd) {
                output.encodeBooleanElement(serialDesc, 3, self.atTheEnd);
            }
        }

        public /* synthetic */ Args(int seen0, String source, String outputDataframeName, String dataSourceName, boolean atTheEnd, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.source = source;
            this.outputDataframeName = (seen0 & 2) == 0 ? null : outputDataframeName;
            this.dataSourceName = (seen0 & 4) == 0 ? null : dataSourceName;
            this.atTheEnd = (seen0 & 8) == 0 ? false : atTheEnd;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/agents/jupyter/tools/CreateSqlCellTool$Args;", "intellij.ml.llm.ds"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

