/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.chat.ui;

import com.intellij.ml.llm.ds.DataSpellLLMBundle;
import com.intellij.ml.llm.ds.chat.message.DataSpellChatMessage;
import com.intellij.ml.llm.ds.chat.ui.DataSpellChatMessageButton;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u001d\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/ds/chat/ui/DataSpellChatUIUtils;", "", "<init>", "()V", "showSolutionStatusBalloonIfPossible", "", "Lcom/intellij/ml/llm/ds/chat/ui/DataSpellChatMessageButton;", "status", "Lcom/intellij/ml/llm/ds/chat/message/DataSpellChatMessage$PerformingStatus;", "message", "", "Lorg/jetbrains/annotations/Nls;", "getMessage", "(Lcom/intellij/ml/llm/ds/chat/message/DataSpellChatMessage$PerformingStatus;)Ljava/lang/String;", "messageType", "Lcom/intellij/openapi/ui/MessageType;", "getMessageType", "(Lcom/intellij/ml/llm/ds/chat/message/DataSpellChatMessage$PerformingStatus;)Lcom/intellij/openapi/ui/MessageType;", "intellij.ml.llm.ds"})
public final class DataSpellChatUIUtils {
    @NotNull
    public static final DataSpellChatUIUtils INSTANCE = new DataSpellChatUIUtils();

    private DataSpellChatUIUtils() {
    }

    public final void showSolutionStatusBalloonIfPossible(@NotNull DataSpellChatMessageButton $this$showSolutionStatusBalloonIfPossible, @NotNull DataSpellChatMessage.PerformingStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$showSolutionStatusBalloonIfPossible), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (!$this$showSolutionStatusBalloonIfPossible.isShowing()) {
            return;
        }
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.getMessage(status), this.getMessageType(status), null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        balloon2.show((PositionTracker)new PositionTracker<Balloon>($this$showSolutionStatusBalloonIfPossible){

            public RelativePoint recalculateLocation(Balloon object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                Component component2 = this.getComponent();
                Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JButton");
                JButton button2 = (JButton)component2;
                JRootPane jRootPane = button2.getRootPane();
                if (jRootPane == null) {
                    return null;
                }
                JRootPane rootPane = jRootPane;
                Rectangle buttonBounds = button2.getBounds();
                int x = buttonBounds.x + buttonBounds.width;
                int y = buttonBounds.height * 1 / 2;
                Point location = SwingUtilities.convertPoint(button2, x, y, rootPane);
                return new RelativePoint((Component)rootPane, location);
            }
        }, Balloon.Position.atRight);
    }

    private final String getMessage(DataSpellChatMessage.PerformingStatus $this$message) {
        String string;
        DataSpellChatMessage.PerformingStatus performingStatus = $this$message;
        if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Success || Intrinsics.areEqual((Object)performingStatus, (Object)DataSpellChatMessage.PerformingStatus.UnconfirmedSuccess.INSTANCE)) {
            string = DataSpellLLMBundle.message("dataspell.agent.performing.status.success", new Object[0]);
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Failure) {
            string = DataSpellLLMBundle.message("dataspell.agent.performing.status.failure", new Object[0]);
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Canceled) {
            string = DataSpellLLMBundle.message("dataspell.agent.performing.status.canceled", new Object[0]);
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Rejected) {
            Object[] objectArray = new Object[]{((DataSpellChatMessage.PerformingStatus.Rejected)$this$message).getReason()};
            string = DataSpellLLMBundle.message("dataspell.agent.performing.status.rejected.with.reason", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final MessageType getMessageType(DataSpellChatMessage.PerformingStatus $this$messageType) {
        MessageType messageType;
        DataSpellChatMessage.PerformingStatus performingStatus = $this$messageType;
        if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Success || Intrinsics.areEqual((Object)performingStatus, (Object)DataSpellChatMessage.PerformingStatus.UnconfirmedSuccess.INSTANCE)) {
            MessageType messageType2 = MessageType.INFO;
            messageType = messageType2;
            Intrinsics.checkNotNullExpressionValue((Object)messageType2, (String)"INFO");
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Failure) {
            MessageType messageType3 = MessageType.ERROR;
            messageType = messageType3;
            Intrinsics.checkNotNullExpressionValue((Object)messageType3, (String)"ERROR");
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Canceled) {
            MessageType messageType4 = MessageType.WARNING;
            messageType = messageType4;
            Intrinsics.checkNotNullExpressionValue((Object)messageType4, (String)"WARNING");
        } else if (performingStatus instanceof DataSpellChatMessage.PerformingStatus.Rejected) {
            MessageType messageType5 = MessageType.WARNING;
            messageType = messageType5;
            Intrinsics.checkNotNullExpressionValue((Object)messageType5, (String)"WARNING");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return messageType;
    }
}

