/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools;

import com.intellij.database.dataSource.connection.Either;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.ExistingFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.SelectedFileModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J.\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\u0005J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/FileUtils;", "", "<init>", "()V", "findAvailableFileName", "", "directory", "Ljava/nio/file/Path;", "baseName", "extension", "generateTargetFileName", "sourceFile", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/model/ExistingFileModel;", "targetExtension", "findExistingFile", "Lcom/intellij/database/dataSource/connection/Either;", "filePathStr", "selectedFile", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/model/SelectedFileModel;", "checkExtension", "actualExtension", "expectedExtension", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    @NotNull
    public final String findAvailableFileName(@NotNull Path directory, @NotNull String baseName, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        int counter = 0;
        String fileName = baseName + "." + extension;
        Path filePath = directory.resolve(fileName);
        while (true) {
            Path path = filePath;
            Intrinsics.checkNotNull((Object)path);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break;
            fileName = baseName + ++counter + "." + extension;
            filePath = directory.resolve(fileName);
        }
        return fileName;
    }

    @NotNull
    public final String generateTargetFileName(@NotNull ExistingFileModel sourceFile, @NotNull String targetExtension) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        Intrinsics.checkNotNullParameter((Object)targetExtension, (String)"targetExtension");
        return this.findAvailableFileName(sourceFile.getDirectoryPath(), sourceFile.getNameWithoutExtension(), targetExtension);
    }

    @NotNull
    public final Either<String, ExistingFileModel> findExistingFile(@Nullable String filePathStr, @Nullable SelectedFileModel selectedFile, @NotNull String extension) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        if (filePathStr != null) {
            Path directoryPath;
            Path filePath;
            Object $this$findExistingFile_u24lambda_u240;
            Object object = this;
            try {
                $this$findExistingFile_u24lambda_u240 = object;
                boolean bl = false;
                $this$findExistingFile_u24lambda_u240 = Result.constructor-impl((Object)Paths.get(filePathStr, new String[0]));
            }
            catch (Throwable bl) {
                $this$findExistingFile_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$findExistingFile_u24lambda_u240;
            Path path = filePath = (Path)(Result.isFailure-impl((Object)object) ? null : object);
            Path path2 = directoryPath = path != null ? path.getParent() : null;
            if (directoryPath == null) {
                return Either.Companion.left((Object)("Failure: Invalid file path: " + filePathStr));
            }
            $this$findExistingFile_u24lambda_u240 = this.checkExtension(PathsKt.getExtension((Path)filePath), extension);
            if ($this$findExistingFile_u24lambda_u240 != null) {
                Object it = $this$findExistingFile_u24lambda_u240;
                boolean bl = false;
                return Either.Companion.left(it);
            }
            VirtualFile file2 = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(filePath);
            if (file2 == null) {
                return Either.Companion.left((Object)("Failure: File not found in the local file system: " + filePathStr));
            }
            either = Either.Companion.right((Object)new ExistingFileModel(directoryPath, filePath));
        } else {
            if (selectedFile == null) {
                return Either.Companion.left((Object)"Failure: No file is currently opened.");
            }
            if (!(selectedFile instanceof ExistingFileModel)) {
                return Either.Companion.left((Object)"Failure: The currently open file was not found in the local file system.");
            }
            String string = this.checkExtension(((ExistingFileModel)((Object)selectedFile)).getExtension(), extension);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return Either.Companion.left((Object)it);
            }
            either = Either.Companion.right((Object)selectedFile);
        }
        return either;
    }

    private final String checkExtension(String actualExtension, String expectedExtension) {
        if (Intrinsics.areEqual((Object)actualExtension, (Object)expectedExtension)) {
            return null;
        }
        return "Failure: Invalid file extension \u2014 expected '" + expectedExtension + "', but found '" + actualExtension + "'";
    }
}

