/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.go.context;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarSpec;
import com.goide.util.GoUtil;
import com.intellij.ml.llm.core.chat.context.UtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.TokenizerAccessPointService;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0013\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0019\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u001a\u0015\u0010\u000e\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0015\u0010\u0011\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0015\u0010\u0014\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"TYPE_SPEC_PRESENTATION_LIMIT", "", "TYPE_DECL_PRESENTATION_LIMIT", "TYPE_METHOD_EMBEDDED_PRESENTATION_LIMIT", "VAR_OR_CONST_PRESENTATION_LIMIT", "ATTACHMENT_TEXT_LIMIT", "llmPresentation", "Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/openapi/util/NlsSafe;", "element", "Lcom/intellij/psi/PsiElement;", "goDoc", "varOrConstDeclPresentation", "Lcom/goide/psi/GoVarOrConstDeclaration;", "embeddedTypeMethodPresentation", "signatureOwner", "Lcom/goide/psi/GoSignatureOwner;", "typeDeclPresentation", "typeDeclaration", "Lcom/goide/psi/GoTypeDeclaration;", "typeSpecPresentation", "typeSpec", "Lcom/goide/psi/GoTypeSpec;", "appendCompactMethods", "", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "tokenSize", "", "intellij.ml.llm.go"})
@SourceDebugExtension(value={"SMAP\nGoChatPresentationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoChatPresentationUtils.kt\ncom/intellij/ml/llm/go/context/GoChatPresentationUtilsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1321#2,2:102\n1869#3,2:104\n*S KotlinDebug\n*F\n+ 1 GoChatPresentationUtils.kt\ncom/intellij/ml/llm/go/context/GoChatPresentationUtilsKt\n*L\n93#1:102,2\n75#1:104,2\n*E\n"})
public final class GoChatPresentationUtilsKt {
    public static final int TYPE_SPEC_PRESENTATION_LIMIT = 300;
    public static final int TYPE_DECL_PRESENTATION_LIMIT = 300;
    public static final int TYPE_METHOD_EMBEDDED_PRESENTATION_LIMIT = 300;
    public static final int VAR_OR_CONST_PRESENTATION_LIMIT = 300;
    public static final int ATTACHMENT_TEXT_LIMIT = 3000;

    @NotNull
    public static final PSString llmPresentation(@NotNull PsiElement element2) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = element2;
        if (psiElement instanceof GoImportList || psiElement instanceof GoPackageClause || psiElement instanceof GoFunctionOrMethodDeclaration) {
            pSString = ExtensionsKtKt.getPrivacySafe(element2).getText();
        } else if (psiElement instanceof GoImportSpec) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe((PsiNamedElement)element2).getText()};
            pSString = ConstantsKt.getPrivacyConst((String)"import %s").format(pSStringConvertibleArray);
        } else if (psiElement instanceof GoConstSpec) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe(element2).getText()};
            pSString = ConstantsKt.getPrivacyConst((String)"const %s").format(pSStringConvertibleArray);
        } else if (psiElement instanceof GoVarSpec) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe(element2).getText()};
            pSString = ConstantsKt.getPrivacyConst((String)"var %s").format(pSStringConvertibleArray);
        } else if (psiElement instanceof GoVarOrConstDeclaration) {
            pSString = GoChatPresentationUtilsKt.varOrConstDeclPresentation((GoVarOrConstDeclaration)element2);
        } else if (psiElement instanceof GoTypeDeclaration) {
            pSString = GoChatPresentationUtilsKt.typeDeclPresentation((GoTypeDeclaration)element2);
        } else if (psiElement instanceof GoTypeSpec) {
            pSString = GoChatPresentationUtilsKt.typeSpecPresentation((GoTypeSpec)element2);
        } else {
            throw new IllegalStateException((element2.getClass() + " does not have an llm presentation").toString());
        }
        return pSString;
    }

    @NotNull
    public static final PSString goDoc(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        List list = GoDocumentationProvider.getUpperCommentsForElement((PsiElement)element2, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUpperCommentsForElement(...)");
        List docComments = list;
        if (docComments.isEmpty()) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        return PSStringKt.joinToString$default((Iterable)docComments, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), null, (PrivacySafe)((PrivacySafe)ConstantsKt.getNL()), (int)0, null, GoChatPresentationUtilsKt::goDoc$lambda$0, (int)26, null);
    }

    private static final PSString varOrConstDeclPresentation(GoVarOrConstDeclaration<?> element2) {
        PSString text2 = ExtensionsKtKt.getPrivacySafe((PsiElement)element2).getText();
        if (GoChatPresentationUtilsKt.tokenSize((String)text2.unwrap()) <= 300) {
            return text2;
        }
        return UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)element2));
    }

    private static final PSString embeddedTypeMethodPresentation(GoSignatureOwner signatureOwner) {
        PSString text2 = ExtensionsKtKt.getPrivacySafe((PsiElement)signatureOwner).getText();
        if (GoChatPresentationUtilsKt.tokenSize((String)text2.unwrap()) <= 300) {
            return text2;
        }
        GoSignature goSignature = signatureOwner.getSignature();
        if (goSignature == null) {
            return text2;
        }
        GoSignature signature = goSignature;
        return ExtensionsKtKt.getPrivacySafe((PsiElement)signatureOwner).getText().substring(0, signature.getTextRangeInParent().getEndOffset()).plus(ConstantsKt.getPrivacyConst((String)" {\n//implementation\n}"));
    }

    private static final PSString typeDeclPresentation(GoTypeDeclaration typeDeclaration) {
        return PSStringKt.buildStringPrivacySafe(arg_0 -> GoChatPresentationUtilsKt.typeDeclPresentation$lambda$0(typeDeclaration, arg_0));
    }

    private static final PSString typeSpecPresentation(GoTypeSpec typeSpec) {
        return PSStringKt.buildStringPrivacySafe(arg_0 -> GoChatPresentationUtilsKt.typeSpecPresentation$lambda$0(typeSpec, arg_0));
    }

    private static final void appendCompactMethods(ConcatenateBuilder $this$appendCompactMethods, GoTypeSpec typeSpec) {
        GoFile goFile = typeSpec.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)goFile, (String)"getContainingFile(...)");
        GoFile typeSpecFile = goFile;
        List list = typeSpec.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMethods(...)");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> GoChatPresentationUtilsKt.appendCompactMethods$lambda$0(typeSpecFile, arg_0)), GoChatPresentationUtilsKt::appendCompactMethods$lambda$1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PSString it = (PSString)element$iv;
            boolean bl = false;
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{it};
            $this$appendCompactMethods.append(ConstantsKt.getPrivacyConst((String)"\n%s").format(pSStringConvertibleArray));
        }
    }

    public static final int tokenSize(@NotNull String $this$tokenSize) {
        Intrinsics.checkNotNullParameter((Object)$this$tokenSize, (String)"<this>");
        return ((Number)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>($this$tokenSize, null){
            int label;
            final /* synthetic */ String $this_tokenSize;
            {
                this.$this_tokenSize = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TokenizerAccessPointService.Companion.getInstance().getTokenizer((Continuation<? super Tokenizer>)((Continuation)this));
                        if (object2 != object) return Boxing.boxInt((int)((Tokenizer)object2).count(this.$this_tokenSize));
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Boxing.boxInt((int)((Tokenizer)object2).count(this.$this_tokenSize));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }))).intValue();
    }

    private static final PrivacySafe goDoc$lambda$0(PsiComment it) {
        Intrinsics.checkNotNull((Object)it);
        return (PrivacySafe)ExtensionsKtKt.getPrivacySafe((PsiElement)it).getText();
    }

    private static final Unit typeDeclPresentation$lambda$0(GoTypeDeclaration $typeDeclaration, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSString text2 = ExtensionsKtKt.getPrivacySafe((PsiElement)$typeDeclaration).getText();
        ConcatenateBuilder concatenateBuilder = GoChatPresentationUtilsKt.tokenSize((String)text2.unwrap()) <= 300 ? $this$buildStringPrivacySafe.append(text2) : $this$buildStringPrivacySafe.append(UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)$typeDeclaration)));
        List list = $typeDeclaration.getTypeSpecList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeSpecList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoTypeSpec it = (GoTypeSpec)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            GoChatPresentationUtilsKt.appendCompactMethods($this$buildStringPrivacySafe, it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit typeSpecPresentation$lambda$0(GoTypeSpec $typeSpec, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"type "));
        PSString text2 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$typeSpec).getText();
        ConcatenateBuilder concatenateBuilder = GoChatPresentationUtilsKt.tokenSize((String)text2.unwrap()) <= 300 ? $this$buildStringPrivacySafe.append(text2) : $this$buildStringPrivacySafe.append(UtilsKt.getTextWithoutCommentsAndBlankLines((PsiElement)((PsiElement)$typeSpec)));
        GoChatPresentationUtilsKt.appendCompactMethods($this$buildStringPrivacySafe, $typeSpec);
        return Unit.INSTANCE;
    }

    private static final boolean appendCompactMethods$lambda$0(GoFile $typeSpecFile, GoMethodDeclaration it) {
        return GoUtil.isDirectlyAccessible((PsiFile)it.getContainingFile(), (PsiFile)((PsiFile)$typeSpecFile));
    }

    private static final PSString appendCompactMethods$lambda$1(GoMethodDeclaration it) {
        Intrinsics.checkNotNull((Object)it);
        return GoChatPresentationUtilsKt.goDoc((PsiElement)it).plus(GoChatPresentationUtilsKt.embeddedTypeMethodPresentation((GoSignatureOwner)it));
    }
}

