/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javascript.chat.context;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u001a\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\t"}, d2={"isWebChatCreationContextSupported", "", "project", "Lcom/intellij/openapi/project/Project;", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "isWebLLMContext", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.ml.llm.javascript"})
public final class JSChatContextUtilsKt {
    @RequiresReadLock
    public static final boolean isWebChatCreationContextSupported(@NotNull Project project2, @NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        return PlatformUtils.isWebStorm() ? true : JSChatContextUtilsKt.isWebLLMContext(chatSession.getCreationContext().getSourceFile(), project2);
    }

    public static final boolean isWebLLMContext(@Nullable PsiFile psiFile, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (psiFile instanceof HtmlCompatibleFile) {
            return true;
        }
        if (PackageJsonCommonUtil.isPackageJsonFile((PsiFile)psiFile)) {
            return true;
        }
        if (psiFile != null) {
            Language language = psiFile.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language language2 = language;
            if (language2.isKindOf((Language)JavascriptLanguage.INSTANCE) || language2.isKindOf((Language)HTMLLanguage.INSTANCE)) {
                return true;
            }
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project2));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        return !collection.isEmpty();
    }
}

