/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.javascript.generate.test;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.javascript.generate.test.JSTestGenerationUtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.psi.PsiElementPrivacyWrapper;
import com.intellij.ml.llm.privacy.extensions.psi.PsiNamedElementPrivacyWrapper;
import com.intellij.ml.llm.privacy.extensions.vfs.VirtualFilePrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0007H\u0017J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0007*\u00020\u0003H\u0002J\u001a\u0010\u001d\u001a\u00020\u001e*\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/ml/llm/javascript/generate/test/JSTestPromptGenerator;", "", "elementForTests", "Lcom/intellij/psi/PsiElement;", "testFilePath", "Ljava/nio/file/Path;", "testFrameworkName", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/nio/file/Path;Lcom/intellij/ml/llm/privacy/PSString;)V", "getElementForTests", "()Lcom/intellij/psi/PsiElement;", "getTestFilePath", "()Ljava/nio/file/Path;", "getTestFrameworkName", "()Lcom/intellij/ml/llm/privacy/PSString;", "requireExplicitFileExt", "", "", "[Ljava/lang/String;", "guideline", "getGuideline", "createPrompt", "collectContextElements", "", "psiElement", "result", "", "elementName", "collectExportedContext", "", "collectTo", "intellij.ml.llm.javascript"})
@SourceDebugExtension(value={"SMAP\nJSTestPromptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTestPromptGenerator.kt\ncom/intellij/ml/llm/javascript/generate/test/JSTestPromptGenerator\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n66#2,2:144\n13805#3,2:146\n3919#3:148\n4434#3,2:149\n13805#3,2:153\n11879#3,9:157\n13805#3:166\n13806#3:168\n11888#3:169\n1869#4,2:151\n1321#5,2:155\n1#6:167\n*S KotlinDebug\n*F\n+ 1 JSTestPromptGenerator.kt\ncom/intellij/ml/llm/javascript/generate/test/JSTestPromptGenerator\n*L\n41#1:144,2\n106#1:146,2\n114#1:148\n114#1:149,2\n116#1:153,2\n132#1:157,9\n132#1:166\n132#1:168\n132#1:169\n115#1:151,2\n141#1:155,2\n132#1:167\n*E\n"})
public class JSTestPromptGenerator {
    @NotNull
    private final PsiElement elementForTests;
    @NotNull
    private final Path testFilePath;
    @Nullable
    private final PSString testFrameworkName;
    @NotNull
    private final String[] requireExplicitFileExt;
    @NotNull
    private final PSString guideline;

    public JSTestPromptGenerator(@NotNull PsiElement elementForTests, @NotNull Path testFilePath2, @Nullable PSString testFrameworkName) {
        Intrinsics.checkNotNullParameter((Object)elementForTests, (String)"elementForTests");
        Intrinsics.checkNotNullParameter((Object)testFilePath2, (String)"testFilePath");
        this.elementForTests = elementForTests;
        this.testFilePath = testFilePath2;
        this.testFrameworkName = testFrameworkName;
        String[] stringArray = new String[]{"Astro", "Svelte"};
        this.requireExplicitFileExt = stringArray;
        this.guideline = ConstantsKt.getPrivacyConst((String)"- Write a description of the function or the method being tested.\n- Test file should be complete and compilable, without need for further actions.\n- Ensure that each test focuses on a single use case to maintain clarity and readability.\n- Try to make the test file as small as possible. Don't add unnecessary code.").trim();
    }

    @NotNull
    protected final PsiElement getElementForTests() {
        return this.elementForTests;
    }

    @NotNull
    protected final Path getTestFilePath() {
        return this.testFilePath;
    }

    @Nullable
    protected final PSString getTestFrameworkName() {
        return this.testFrameworkName;
    }

    @NotNull
    protected final PSString getGuideline() {
        return this.guideline;
    }

    @RequiresReadLock
    @NotNull
    public PSString createPrompt() {
        PSString pSString;
        PSString pSString2;
        PSString command;
        Object object;
        Object object2;
        PSString elementName = this.elementName(this.elementForTests);
        PsiElement $this$parentOfType_u24default$iv = this.elementForTests;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        JSClass contextClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, JSClass.class, (boolean)true);
        Object object3 = contextClass;
        if (object3 == null || (object3 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)object3)) == null || (object3 = ((PsiElementPrivacyWrapper)((Object)object3)).getText()) == null) {
            object3 = ExtensionsKtKt.getPrivacySafe(this.elementForTests).getText();
        }
        Object mainContext = object3;
        List relatedContext = CollectionsKt.distinct((Iterable)JSTestPromptGenerator.collectContextElements$default(this, this.elementForTests, null, 2, null));
        JSClass jSClass = contextClass;
        PSString exportType = ES6ImportHandler.isExportedWithDefault((PsiElement)(jSClass != null ? (PsiElement)jSClass : this.elementForTests)) ? ConstantsKt.getPrivacyConst((String)"default") : ConstantsKt.getPrivacyConst((String)"named");
        PsiFile containingFile = this.elementForTests.getContainingFile();
        FileType fileType2 = containingFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileType(...)");
        FileType fileType3 = fileType2;
        Pair pair = ArraysKt.contains((Object[])this.requireExplicitFileExt, (Object)fileType3.getName()) ? TuplesKt.to((Object)ConstantsKt.getPrivacyConst((String)"It is a popular Javascript framework"), (object2 = containingFile) != null && (object2 = object2.getVirtualFile()) != null && (object2 = ExtensionsKtKt.getPrivacySafe((VirtualFile)object2)) != null ? ((VirtualFilePrivacyWrapper)((Object)object2)).getName() : null) : TuplesKt.to((Object)ConstantsKt.getPrivacyConst((String)""), (object = containingFile) != null && (object = object.getVirtualFile()) != null && (object = ExtensionsKtKt.getPrivacySafe((VirtualFile)object)) != null ? ((VirtualFilePrivacyWrapper)((Object)object)).getNameWithoutExtension() : null);
        PSString frameworkClarification = (PSString)pair.component1();
        PSString containingFileName = (PSString)pair.component2();
        if (this.elementForTests instanceof JSClass) {
            var12_13 = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)this.testFilePath).getNameWithoutExtension(), elementName};
            v5 = ConstantsKt.getPrivacyConst((String)"Write `%s` tests for the `%s` class").format(var12_13);
        } else if (contextClass != null) {
            var12_13 = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)this.testFilePath).getNameWithoutExtension(), elementName, ExtensionsKtKt.getPrivacySafe((PsiNamedElement)contextClass).getName()};
            v5 = ConstantsKt.getPrivacyConst((String)"Write `%s` tests for the `%s` method in the `%s` class").format(var12_13);
        } else {
            var12_13 = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((Path)this.testFilePath).getNameWithoutExtension(), elementName};
            v5 = command = ConstantsKt.getPrivacyConst((String)"Write `%s` tests for the `%s` function").format(var12_13);
        }
        if (this.testFrameworkName != null) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{this.testFrameworkName};
            pSString2 = ConstantsKt.getPrivacyConst((String)"Use `%s` javascript test framework").format(pSStringConvertibleArray);
        } else {
            pSString2 = ConstantsKt.getPrivacyConst((String)"");
        }
        PSString testFrameWorkDescription = pSString2;
        Project project2 = this.elementForTests.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project2).findPrompt("llm.testGeneration.js");
        PSString customPrompt = aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null ? pSString : ConstantsKt.getEMPTY();
        return PSStringKt.buildStringPrivacySafe(arg_0 -> JSTestPromptGenerator.createPrompt$lambda$0(fileType3, frameworkClarification, command, exportType, containingFileName, this, customPrompt, testFrameWorkDescription, (PSString)mainContext, relatedContext, arg_0)).trim();
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> collectContextElements(PsiElement psiElement, List<PsiElement> result2) {
        block8: {
            PsiElement psiElement2;
            block9: {
                JSVariable jSVariable;
                block7: {
                    if (PrivacyPathCheckerKt.isAiIgnoreBlocked(psiElement)) {
                        return result2;
                    }
                    psiElement2 = psiElement;
                    if (!(psiElement2 instanceof JSFunction)) break block7;
                    PsiElement psiElement3 = ((JSFunction)psiElement).getReturnTypeElement();
                    if (psiElement3 != null) {
                        this.collectExportedContext(psiElement3, result2);
                    }
                    JSParameterListElement[] jSParameterListElementArray = ((JSFunction)psiElement).getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)jSParameterListElementArray, (String)"getParameters(...)");
                    Object[] $this$forEach$iv = jSParameterListElementArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        JSParameterListElement it = (JSParameterListElement)element$iv;
                        boolean bl = false;
                        PsiElement psiElement4 = it.getTypeElement();
                        if (psiElement4 == null) continue;
                        this.collectExportedContext(psiElement4, result2);
                    }
                    break block8;
                }
                if (!(psiElement2 instanceof JSVarStatement)) break block9;
                JSVariable[] jSVariableArray = ((JSVarStatement)psiElement).getVariables();
                Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
                JSVariable jSVariable2 = (JSVariable)ArraysKt.singleOrNull((Object[])jSVariableArray);
                if (jSVariable2 == null || (jSVariable2 = jSVariable2.getInitializerOrStub()) == null) break block8;
                JSVariable jSVariable3 = jSVariable = jSVariable2;
                boolean bl = false;
                this.collectContextElements((PsiElement)jSVariable3, result2);
                break block8;
            }
            if (psiElement2 instanceof JSClass) {
                Object[] $this$forEach$iv;
                void $this$filterTo$iv$iv;
                JSField[] jSFieldArray = ((JSClass)psiElement).getFields();
                Intrinsics.checkNotNullExpressionValue((Object)jSFieldArray, (String)"getFields(...)");
                Object $this$filter$iv = jSFieldArray;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    JSField it = (JSField)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!(!JSTestGenerationUtilsKt.isPrivateMember((PsiElement)it))) continue;
                    collection.add(element$iv$iv);
                }
                $this$filter$iv = (List)collection;
                boolean $i$f$forEach = false;
                for (Object e : $this$forEach$iv) {
                    JSField it = (JSField)e;
                    boolean bl = false;
                    PsiElement psiElement5 = it.getTypeElement();
                    if (psiElement5 == null) continue;
                    this.collectExportedContext(psiElement5, result2);
                }
                JSFunction[] jSFunctionArray = ((JSClass)psiElement).getFunctions();
                Intrinsics.checkNotNullExpressionValue((Object)jSFunctionArray, (String)"getFunctions(...)");
                $this$forEach$iv = jSFunctionArray;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JSFunction it = (JSFunction)element$iv;
                    int bl = 0;
                    Intrinsics.checkNotNull((Object)it);
                    this.collectContextElements((PsiElement)it, result2);
                }
            }
        }
        return result2;
    }

    static /* synthetic */ List collectContextElements$default(JSTestPromptGenerator jSTestPromptGenerator, PsiElement psiElement, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: collectContextElements");
        }
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        return jSTestPromptGenerator.collectContextElements(psiElement, list);
    }

    private final PSString elementName(PsiElement $this$elementName) {
        Object object;
        PsiElement psiElement = $this$elementName;
        if (psiElement instanceof JSVarStatement) {
            JSVariable[] jSVariableArray = ((JSVarStatement)$this$elementName).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)jSVariableArray, (String)"getVariables(...)");
            Object object2 = (JSVariable)ArraysKt.firstOrNull((Object[])jSVariableArray);
            object = object2 != null && (object2 = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)object2)) != null ? ((PsiNamedElementPrivacyWrapper)((Object)object2)).getName() : null;
        } else {
            object = psiElement instanceof JSNamedElement ? ExtensionsKtKt.getPrivacySafe((PsiNamedElement)$this$elementName).getName() : null;
        }
        return object;
    }

    private final void collectExportedContext(PsiElement $this$collectExportedContext, List<PsiElement> collectTo) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)PsiTreeUtilKt.descendants$default((PsiElement)$this$collectExportedContext, (boolean)false, JSTestPromptGenerator::collectExportedContext$lambda$0, (int)1, null), JSTestPromptGenerator::collectExportedContext$lambda$1), JSTestPromptGenerator::collectExportedContext$lambda$2), arg_0 -> JSTestPromptGenerator.collectExportedContext$lambda$3(this, collectTo, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            collectTo.add(it);
        }
    }

    private static final Unit createPrompt$lambda$0(FileType $fileType, PSString $frameworkClarification, PSString $command, PSString $exportType, PSString $containingFileName, JSTestPromptGenerator this$0, PSString $customPrompt, PSString $testFrameWorkDescription, PSString $mainContext, List $relatedContext, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{ExtensionsKtKt.getPrivacySafe($fileType).getName(), $frameworkClarification};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"You are a rock-star %s developer.%s").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.appendLine($command);
        pSStringConvertibleArray = new PSStringConvertible[]{$exportType, $containingFileName};
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"which is `%s` exported from the `%s` file.").format(pSStringConvertibleArray));
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"Guideline:"));
        $this$buildStringPrivacySafe.appendLine(this$0.guideline);
        if (((CharSequence)$customPrompt).length() > 0) {
            $this$buildStringPrivacySafe.appendLine($customPrompt);
            ConcatenateBuilder.appendLine$default((ConcatenateBuilder)$this$buildStringPrivacySafe, null, (int)1, null);
        }
        $this$buildStringPrivacySafe.appendLine($testFrameWorkDescription);
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"Here is the original code:"));
        $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"```"));
        $this$buildStringPrivacySafe.appendLine($mainContext);
        $this$buildStringPrivacySafe.appendLine(PSStringKt.joinToString$default((Iterable)$relatedContext, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"\n")), null, null, (int)0, null, JSTestPromptGenerator::createPrompt$lambda$0$0, (int)30, null).plus(ConstantsKt.getPrivacyConst((String)"```")));
        return Unit.INSTANCE;
    }

    private static final PrivacySafe createPrompt$lambda$0$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (PrivacySafe)ExtensionsKtKt.getPrivacySafe(it).getText();
    }

    private static final boolean collectExportedContext$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable collectExportedContext$lambda$1(PsiElement desc) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        PsiReference[] psiReferenceArray = desc.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] $this$mapNotNull$iv = psiReferenceArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            PsiElement it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiReference it = (PsiReference)element$iv$iv;
            boolean bl2 = false;
            if (it.resolve() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final boolean collectExportedContext$lambda$2(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !PrivacyPathCheckerKt.isAiIgnoreBlocked(it);
    }

    private static final boolean collectExportedContext$lambda$3(JSTestPromptGenerator this$0, List $collectTo, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof ES6ImportSpecifier) {
            ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportSpecifier)it).getDeclaration();
            if (eS6ImportDeclaration != null) {
                this$0.collectExportedContext((PsiElement)eS6ImportDeclaration, $collectTo);
            }
            return false;
        }
        return it instanceof JSElementBase && (((JSElementBase)it).isExported() || ((JSElementBase)it).isExportedWithDefault());
    }
}

