/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.kotlin.prompts;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/jupyter/kotlin/prompts/NotebookPromptsFormatStorage;", "", "<init>", "()V", "SUGGEST_EDIT_REQUEST_FORMAT", "Lcom/intellij/ml/llm/privacy/PSString;", "getSUGGEST_EDIT_REQUEST_FORMAT", "()Lcom/intellij/ml/llm/privacy/PSString;", "AUTOPILOT_NEW_CELL_SUGGESTION_FORMAT", "getAUTOPILOT_NEW_CELL_SUGGESTION_FORMAT", "CgExamplesStorage", "intellij.ml.llm.jupyter.kotlin"})
public final class NotebookPromptsFormatStorage {
    @NotNull
    public static final NotebookPromptsFormatStorage INSTANCE = new NotebookPromptsFormatStorage();
    @NotNull
    private static final PSString SUGGEST_EDIT_REQUEST_FORMAT = ConstantsKt.getPrivacyConst((String)"\n    Given a Jupyter Notebook using Kotlin, with cells in the format:\n      #%% - separator of cells\n      #%% md - markdown cell\n      \n      {0}\n      \n      The cell code is:\n      \n      {1}\n      \n      Propose how to edit this code cell.\n      It should contain a bullet list of 1-3 short actionable suggestions, 1 is totally fine if it's obvious.\n      Each suggestion should be actionable in a single notebook cell without assuming any prior steps have been completed. \n      If the action requires other work to be done before, don't suggest it, only suggest the immediate actions. \n      For example, don't suggest data manipulations if the data is not loaded yet.\n      It could be fixing errors in the cell or code refactoring etc.\n      Be short and informative, don't add code to suggestions.\n      DO NOT SUGGEST run code! \n      DO NOT SUGGEST \"Run ...\" because it is impossible to run. It is only possible to write code.\n      Suggest only action on how to modify the current cell.\n      \n      {2}\n      \n      Examples:\n      Q:\n      ```kotlin\n      fun List<*>.isUnique(): Boolean {\n        for (i in indices) {\n            for (j in i + 1 until size) {\n                if (get(i) == get(j)) {\n                    return false\n                }\n            }\n        }\n        return true        \n      ```\n      \n      A:\n      - Make this function more optimal with by toSet()\n      - Make this function more optimal with by size\n      \n      Q:\n      ```kotlin\n      fun calculateTriangleSquare(side: Int, height: Int): Int {\n        return side * height\n      }\n      ```\n      \n      A:\n      - Modify the function to use the correct formula for the area of a triangle which is (1/2) * side * height; check for inputs\n      ").trimIndent();
    @NotNull
    private static final PSString AUTOPILOT_NEW_CELL_SUGGESTION_FORMAT = ConstantsKt.getPrivacyConst((String)"\n    Given Jupyter Notebook with Kotlin Language, cells in format:\n    #%% - separator of cells\n    #%% md - markdown cell\n\n    {0}\n\n    Briefly formulate the final goal of this notebook as you understand it.\n    Then propose the next immediate steps.\n    It should contain a bullet list of 1-3 short actionable suggestions, 1 is totally fine if it's obvious.\n    Each suggestion should be actionable in a single notebook cell without assuming any prior steps have been completed. \n    If the action requires other work to be done before, don't suggest it, only suggest the immediate actions. \n    For example, don't suggest data manipulations if the data is not loaded yet.\n    Be short and informative, don't add code to suggestions.\n    DO NOT SUGGEST run code! \n    DO NOT SUGGEST \"Run ...\" because it is impossible to run it is possible only to write code.\n    Suggest only actions that generate code in the next cell.\n\n    Examples:\n    Goal: Find out the reason of high customer churn rate.\n    - Check for correlations between features\n    - Check if the data has to be cleaned up\n\n    Goal: Find the differences between key customer groups.\n    - Load data from 'groups_2.csv'\n    - Generate a histogram representing an age distribution\n    - Call `describe()` on the DataFrame to see information about columns.\n\n    Goal: Concurrent int counter implementation\n     - Check linearizability for case of 1 Thread \n     - Check linearizability for case of several writers, 1 reader \n     - Check linearizability for case of several writers, several readers\n     - Refer to 'lincheck' \n  ").trimIndent();

    private NotebookPromptsFormatStorage() {
    }

    @NotNull
    public final PSString getSUGGEST_EDIT_REQUEST_FORMAT() {
        return SUGGEST_EDIT_REQUEST_FORMAT;
    }

    @NotNull
    public final PSString getAUTOPILOT_NEW_CELL_SUGGESTION_FORMAT() {
        return AUTOPILOT_NEW_CELL_SUGGESTION_FORMAT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/jupyter/kotlin/prompts/NotebookPromptsFormatStorage$CgExamplesStorage;", "", "<init>", "()V", "EXPLAIN_WITH_MARKDOWN_EXAMPLE_CG", "Lcom/intellij/ml/llm/privacy/PSString;", "getEXPLAIN_WITH_MARKDOWN_EXAMPLE_CG", "()Lcom/intellij/ml/llm/privacy/PSString;", "EDIT_CELL_EXAMPLE_CG", "getEDIT_CELL_EXAMPLE_CG", "FIX_ERROR_EXAMPLE_CG", "getFIX_ERROR_EXAMPLE_CG", "intellij.ml.llm.jupyter.kotlin"})
    public static final class CgExamplesStorage {
        @NotNull
        public static final CgExamplesStorage INSTANCE = new CgExamplesStorage();
        @NotNull
        private static final PSString EXPLAIN_WITH_MARKDOWN_EXAMPLE_CG = ConstantsKt.getPrivacyConst((String)"\n      Q:\n      ```\n      %use dataframe\n      ```\n      A:\n      ```markdown\n      **This code resolves and installs the latest available version of Kotlin DataFrame to be used in the current Notebook**      \n      ```\n\n      Q:\n      ```\n      println(42)\n      ```\n      A:\n      ```markdown\n      **This code prints 42**\n      ```\n    ").trimIndent();
        @NotNull
        private static final PSString EDIT_CELL_EXAMPLE_CG = ConstantsKt.getPrivacyConst((String)"\n      Q:\n      ```kotlin\n      val data = mapOf(\"Name\" to listOf(\"Alice\", \"Bob\", \"Ivan\"), \"Age\" to listOf(22, 30, 18))\n      ```\n      User request: convert this to dataFrame \n  \n      A:\n      ```kotlin\n      %use dataframe \n      val df = data.toDataFrame()\n      ```\n  ").trimIndent();
        @NotNull
        private static final PSString FIX_ERROR_EXAMPLE_CG = ConstantsKt.getPrivacyConst((String)"\n      Q:\n      ```kotlin\n      dataFrameOf(x)\n      ```\n      Output contains: \n      Unresolved reference: dataFrameOf \n\n      A:\n      ```kotlin\n      %use dataframe\n      dataFrameOf(x)\n      ```\n      \n      Q:\n      ```kotlin\n      listOf(l)\n      ```\n      Output contains: \n      Unresolved reference: l \n\n      A:\n      ```kotlin\n      val l = \"42\"\n      listOf(l)\n      ```\n    ").trimIndent();

        private CgExamplesStorage() {
        }

        @NotNull
        public final PSString getEXPLAIN_WITH_MARKDOWN_EXAMPLE_CG() {
            return EXPLAIN_WITH_MARKDOWN_EXAMPLE_CG;
        }

        @NotNull
        public final PSString getEDIT_CELL_EXAMPLE_CG() {
            return EDIT_CELL_EXAMPLE_CG;
        }

        @NotNull
        public final PSString getFIX_ERROR_EXAMPLE_CG() {
            return FIX_ERROR_EXAMPLE_CG;
        }
    }
}

