/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.python.runtimeErrorExplanation.filters;

import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/jupyter/python/runtimeErrorExplanation/filters/JupyterPythonTracebackLLMExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "exceptionType", "", "exceptionValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "tracebackPosition", "", "isErrorBegin", "", "line", "entireLength", "calcExceptionStartOffset", "entireOffset", "calcInlayPosition", "intellij.ml.llm.jupyter.python"})
public final class JupyterPythonTracebackLLMExplainFilter
extends ErrorExplainFilter {
    @NotNull
    private final String exceptionType;
    @NotNull
    private final String exceptionValue;
    private int tracebackPosition;

    public JupyterPythonTracebackLLMExplainFilter(@NotNull String exceptionType, @NotNull String exceptionValue) {
        Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
        Intrinsics.checkNotNullParameter((Object)exceptionValue, (String)"exceptionValue");
        this.exceptionType = exceptionType;
        this.exceptionValue = exceptionValue;
    }

    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Traceback (most recent call last)", (boolean)false, (int)2, null)) {
            this.tracebackPosition = entireLength - line.length();
        }
        return StringsKt.startsWith$default((String)line, (String)this.exceptionType, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)line, (String)this.exceptionValue, (boolean)false, (int)2, null);
    }

    public int calcExceptionStartOffset(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.tracebackPosition;
    }

    public int calcInlayPosition(@NotNull String line, int entireOffset) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return entireOffset;
    }
}

