/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.logicalStructure.mapper;

import com.intellij.ide.TypePresentationService;
import com.intellij.ide.structureView.logical.impl.mappers.LogicalModelMapper;
import com.intellij.ide.structureView.logical.impl.mappers.LogicalModelMapperProvider;
import com.intellij.ide.structureView.logical.model.LogicalStructureAssembledModel;
import com.intellij.ide.structureView.logical.model.ProvidedLogicalContainer;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ml/llm/logicalStructure/mapper/LogicalStructureYamlMapper;", "", "<init>", "()V", "Companion", "intellij.ml.llm.logicalStructure"})
public final class LogicalStructureYamlMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tJ \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002JL\u0010\u000b\u001a*\u0012\u0004\u0012\u00020\u0006\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\rj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001`\u000e0\f\"\u0004\b\u0000\u0010\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0006*\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/logicalStructure/mapper/LogicalStructureYamlMapper$Companion;", "", "<init>", "()V", "map", "", "", "T", "model", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "bfs", "mapNode", "Lkotlin/Pair;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "logicalStructureNode", "collectProperties", "", "getPathToNode", "Lcom/intellij/psi/PsiTarget;", "QueueNode", "intellij.ml.llm.logicalStructure"})
    @SourceDebugExtension(value={"SMAP\nLogicalStructureYamlMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureYamlMapper.kt\ncom/intellij/ml/llm/logicalStructure/mapper/LogicalStructureYamlMapper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1878#2,3:129\n*S KotlinDebug\n*F\n+ 1 LogicalStructureYamlMapper.kt\ncom/intellij/ml/llm/logicalStructure/mapper/LogicalStructureYamlMapper$Companion\n*L\n69#1:129,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Map<String, Object> map(@NotNull LogicalStructureAssembledModel<T> model) {
            Intrinsics.checkNotNullParameter(model, (String)"model");
            LinkedHashMap result2 = new LinkedHashMap();
            ((Map)result2).put("logical-structure", this.bfs(model));
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, Object> bfs(LogicalStructureAssembledModel<?> model) {
            LinkedHashMap result2 = new LinkedHashMap();
            HashSet<Object> visited = new HashSet<Object>();
            ArrayDeque queue = new ArrayDeque();
            com.intellij.ml.llm.logicalStructure.mapper.LogicalStructureYamlMapper$Companion.bfs$addNodeToQueue(visited, (ArrayDeque<QueueNode>)queue, model, result2, 0);
            while (!((Collection)queue).isEmpty()) {
                QueueNode node = (QueueNode)queue.removeFirst();
                Pair<String, HashMap<String, Object>> pair = this.mapNode(node.getAssembledModel(), !node.getWasVisitedBefore());
                String nodeType = (String)pair.component1();
                HashMap nodeProperties = (HashMap)pair.component2();
                if (node.getResultRoot().containsKey(nodeType)) {
                    node.getResultRoot().put(nodeType + "-" + node.getCounter(), nodeProperties);
                } else {
                    node.getResultRoot().put(nodeType, nodeProperties);
                }
                if (node.getWasVisitedBefore()) continue;
                List children2 = node.getAssembledModel().getChildren();
                Iterable $this$forEachIndexed$iv = children2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void assembledModel;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    LogicalStructureAssembledModel logicalStructureAssembledModel = (LogicalStructureAssembledModel)item$iv;
                    int index = n;
                    boolean bl = false;
                    com.intellij.ml.llm.logicalStructure.mapper.LogicalStructureYamlMapper$Companion.bfs$addNodeToQueue(visited, (ArrayDeque<QueueNode>)queue, assembledModel, nodeProperties, index);
                }
            }
            return result2;
        }

        private final <T> Pair<String, HashMap<String, Object>> mapNode(LogicalStructureAssembledModel<T> logicalStructureNode, boolean collectProperties) {
            String relativePath;
            String type2;
            String string;
            String string2;
            Object dataModel = logicalStructureNode.getModel();
            if (dataModel instanceof PsiTarget) {
                PsiElement psiElement = ((PsiTarget)dataModel).getNavigationElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
                PsiElement psiTarget = psiElement;
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked(psiTarget)) {
                    return TuplesKt.to((Object)"ai-ignored-node", new HashMap());
                }
            }
            LogicalModelMapperProvider logicalModelMapperProvider = LogicalModelMapperProvider.Companion.getInstance(dataModel);
            if (dataModel instanceof LogicalModelMapper) {
                string2 = ((LogicalModelMapper)dataModel).type();
            } else {
                LogicalModelMapperProvider logicalModelMapperProvider2 = logicalModelMapperProvider;
                if (logicalModelMapperProvider2 != null) {
                    string2 = logicalModelMapperProvider2.type(dataModel);
                } else if (dataModel instanceof ProvidedLogicalContainer) {
                    string2 = TypePresentationService.getService().getObjectName((Object)((ProvidedLogicalContainer)dataModel).getProvider());
                } else {
                    TypePresentationService typePresentationService = TypePresentationService.getService();
                    Intrinsics.checkNotNull((Object)dataModel, (String)"null cannot be cast to non-null type kotlin.Any");
                    string2 = string = typePresentationService.getObjectName(dataModel);
                }
            }
            if (string2 == null) {
                Intrinsics.checkNotNull((Object)dataModel, (String)"null cannot be cast to non-null type kotlin.Any");
                string = dataModel.getClass().getSimpleName();
            }
            String name = string;
            TypePresentationService typePresentationService = TypePresentationService.getService();
            Intrinsics.checkNotNull((Object)dataModel, (String)"null cannot be cast to non-null type kotlin.Any");
            String string3 = type2 = typePresentationService.getTypeName(dataModel);
            Object key = string3 != null ? string3 + " " + name : name;
            LinkedHashMap allProperties = new LinkedHashMap();
            if (collectProperties) {
                Map map2;
                Map map3 = allProperties;
                if (dataModel instanceof LogicalModelMapper) {
                    map2 = ((LogicalModelMapper)dataModel).attributes();
                } else {
                    LogicalModelMapperProvider logicalModelMapperProvider3 = logicalModelMapperProvider;
                    map2 = logicalModelMapperProvider3 != null ? (Map)logicalModelMapperProvider3.attributes(dataModel) : MapsKt.emptyMap();
                }
                map3.putAll(map2);
            }
            if (dataModel instanceof PsiTarget && (relativePath = this.getPathToNode((PsiTarget)dataModel)) != null) {
                ((Map)allProperties).put("file-path", relativePath);
            }
            return TuplesKt.to((Object)key, allProperties);
        }

        private final String getPathToNode(PsiTarget $this$getPathToNode) {
            PsiFile psiFile = $this$getPathToNode.getNavigationElement().getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return null;
            }
            PsiFile virtualFile2 = psiFile;
            Project project2 = $this$getPathToNode.getNavigationElement().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            VirtualFile virtualFile3 = ProjectUtil.guessProjectDir((Project)project2);
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile projectDir = virtualFile3;
            String string = VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)projectDir, (char)File.separatorChar);
            return string != null ? StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null) : null;
        }

        private static final void bfs$addNodeToQueue(HashSet<Object> visited, ArrayDeque<QueueNode> queue, LogicalStructureAssembledModel<?> logicalStructure, Map<String, Object> result2, int counter) {
            if (((Collection)visited).size() > Registry.Companion.intValue("logical.structure.retriever.yaml.max.nodes.limit", 200)) {
                return;
            }
            boolean wasVisitedBefore = CollectionsKt.contains((Iterable)visited, (Object)logicalStructure.getModel());
            if (!wasVisitedBefore) {
                Object object = logicalStructure.getModel();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
                visited.add(object);
            }
            queue.add((Object)new QueueNode(logicalStructure, result2, counter, wasVisitedBefore));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/logicalStructure/mapper/LogicalStructureYamlMapper$Companion$QueueNode;", "", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "resultRoot", "", "", "counter", "", "wasVisitedBefore", "", "<init>", "(Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;Ljava/util/Map;IZ)V", "getAssembledModel", "()Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "getResultRoot", "()Ljava/util/Map;", "getCounter", "()I", "getWasVisitedBefore", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "intellij.ml.llm.logicalStructure"})
        private static final class QueueNode {
            @NotNull
            private final LogicalStructureAssembledModel<?> assembledModel;
            @NotNull
            private final Map<String, Object> resultRoot;
            private final int counter;
            private final boolean wasVisitedBefore;

            public QueueNode(@NotNull LogicalStructureAssembledModel<?> assembledModel, @NotNull Map<String, Object> resultRoot, int counter, boolean wasVisitedBefore) {
                Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
                Intrinsics.checkNotNullParameter(resultRoot, (String)"resultRoot");
                this.assembledModel = assembledModel;
                this.resultRoot = resultRoot;
                this.counter = counter;
                this.wasVisitedBefore = wasVisitedBefore;
            }

            @NotNull
            public final LogicalStructureAssembledModel<?> getAssembledModel() {
                return this.assembledModel;
            }

            @NotNull
            public final Map<String, Object> getResultRoot() {
                return this.resultRoot;
            }

            public final int getCounter() {
                return this.counter;
            }

            public final boolean getWasVisitedBefore() {
                return this.wasVisitedBefore;
            }

            @NotNull
            public final LogicalStructureAssembledModel<?> component1() {
                return this.assembledModel;
            }

            @NotNull
            public final Map<String, Object> component2() {
                return this.resultRoot;
            }

            public final int component3() {
                return this.counter;
            }

            public final boolean component4() {
                return this.wasVisitedBefore;
            }

            @NotNull
            public final QueueNode copy(@NotNull LogicalStructureAssembledModel<?> assembledModel, @NotNull Map<String, Object> resultRoot, int counter, boolean wasVisitedBefore) {
                Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
                Intrinsics.checkNotNullParameter(resultRoot, (String)"resultRoot");
                return new QueueNode(assembledModel, resultRoot, counter, wasVisitedBefore);
            }

            public static /* synthetic */ QueueNode copy$default(QueueNode queueNode, LogicalStructureAssembledModel logicalStructureAssembledModel, Map map2, int n, boolean bl, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    logicalStructureAssembledModel = queueNode.assembledModel;
                }
                if ((n2 & 2) != 0) {
                    map2 = queueNode.resultRoot;
                }
                if ((n2 & 4) != 0) {
                    n = queueNode.counter;
                }
                if ((n2 & 8) != 0) {
                    bl = queueNode.wasVisitedBefore;
                }
                return queueNode.copy(logicalStructureAssembledModel, map2, n, bl);
            }

            @NotNull
            public String toString() {
                return "QueueNode(assembledModel=" + this.assembledModel + ", resultRoot=" + this.resultRoot + ", counter=" + this.counter + ", wasVisitedBefore=" + this.wasVisitedBefore + ")";
            }

            public int hashCode() {
                int result2 = this.assembledModel.hashCode();
                result2 = result2 * 31 + ((Object)this.resultRoot).hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.counter);
                result2 = result2 * 31 + Boolean.hashCode(this.wasVisitedBefore);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof QueueNode)) {
                    return false;
                }
                QueueNode queueNode = (QueueNode)other;
                if (!Intrinsics.areEqual(this.assembledModel, queueNode.assembledModel)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.resultRoot, queueNode.resultRoot)) {
                    return false;
                }
                if (this.counter != queueNode.counter) {
                    return false;
                }
                return this.wasVisitedBefore == queueNode.wasVisitedBefore;
            }
        }
    }
}

