/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ml.llm.mcp.client.settings.McpServerBean;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationLevel;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerEditPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0015J\b\u0010 \u001a\u00020\u0005H\u0015J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationEditDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "configurations", "", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfiguration;", "level", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationLevel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationLevel;)V", "getConfigurations", "()Ljava/util/List;", "setConfigurations", "(Ljava/util/List;)V", "getLevel", "()Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationLevel;", "content", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerEditPanel;", "getMcpServerConfigurationLevel", "initEditor", "", "configuration", "initListeners", "doOKAction", "isOKActionEnabled", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "jsonContentAsConfigurations", "", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpServerConfigurationEditDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerConfigurationEditDialog.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationEditDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1869#2:96\n295#2,2:97\n1870#2:100\n1#3:99\n*S KotlinDebug\n*F\n+ 1 McpServerConfigurationEditDialog.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationEditDialog\n*L\n68#1:96\n69#1:97,2\n68#1:100\n*E\n"})
public final class McpServerConfigurationEditDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private List<McpServerConfiguration> configurations;
    @NotNull
    private final McpServerConfigurationLevel level;
    @NotNull
    private final McpServerEditPanel content;

    public McpServerConfigurationEditDialog(@NotNull Project project2, @NotNull String title, @NotNull List<McpServerConfiguration> configurations, @NotNull McpServerConfigurationLevel level) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        super(project2, true);
        this.project = project2;
        this.configurations = configurations;
        this.level = level;
        this.content = new McpServerEditPanel(this.project, this.level, !((Collection)this.configurations).isEmpty());
        Disposer.register((Disposable)this.getDisposable(), () -> McpServerConfigurationEditDialog._init_$lambda$0(this));
        this.setTitle(title);
        this.initListeners();
        this.init();
        this.content.getWorkingDirField().addBrowseFolderListener(this.project, FileChooserDescriptorFactory.singleDir());
        McpServerConfiguration mcpServerConfiguration = (McpServerConfiguration)CollectionsKt.firstOrNull(this.configurations);
        if (mcpServerConfiguration == null) {
            mcpServerConfiguration = new McpServerCommand("", new McpServerBean(null, null, null, null, null, null, 63, null), McpServerConfigurationSource.USER);
        }
        this.initEditor(mcpServerConfiguration);
    }

    public /* synthetic */ McpServerConfigurationEditDialog(Project project2, String string, List list, McpServerConfigurationLevel mcpServerConfigurationLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        if ((n & 8) != 0) {
            mcpServerConfigurationLevel = McpServerConfigurationLevel.GLOBAL;
        }
        this(project2, string, list, mcpServerConfigurationLevel);
    }

    @NotNull
    public final List<McpServerConfiguration> getConfigurations() {
        return this.configurations;
    }

    public final void setConfigurations(@NotNull List<McpServerConfiguration> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.configurations = list;
    }

    @NotNull
    public final McpServerConfigurationLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final McpServerConfigurationLevel getMcpServerConfigurationLevel() {
        return this.content.getServerLevel();
    }

    private final void initEditor(McpServerConfiguration configuration) {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.content.getWorkingDirField();
        Object object = configuration instanceof McpServerCommand ? (McpServerCommand)configuration : null;
        if (object == null || (object = ((McpServerCommand)object).getWorkingDirectory()) == null) {
            object = "";
        }
        textFieldWithBrowseButton.setText((String)object);
        ApplicationManager.getApplication().runWriteAction(() -> McpServerConfigurationEditDialog.initEditor$lambda$0(this, configuration));
    }

    private final void initListeners() {
        this.content.getEditor().getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ McpServerConfigurationEditDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                McpServerConfigurationEditDialog.access$initValidation(this.this$0);
            }
        });
    }

    protected void doOKAction() {
        List<McpServerConfiguration> newConfigurations;
        List<McpServerConfiguration> list = newConfigurations = this.jsonContentAsConfigurations();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v1;
                McpServerConfiguration mcpServerConfiguration;
                block4: {
                    mcpServerConfiguration = (McpServerConfiguration)element$iv;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = this.configurations;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        McpServerConfiguration it = (McpServerConfiguration)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)mcpServerConfiguration.getName())) continue;
                        v1 = element$iv2;
                        break block4;
                    }
                    v1 = null;
                }
                if ((McpServerConfiguration)v1 != null) {
                    McpServerConfiguration original;
                    boolean bl = false;
                    mcpServerConfiguration.setEnabled(original.getEnabled());
                    continue;
                }
                McpServerConfigurationEditDialog $this$doOKAction_u24lambda_u240_u242 = this;
                boolean bl = false;
                mcpServerConfiguration.setEnabled(true);
            }
        }
        this.configurations.clear();
        List<McpServerConfiguration> list2 = newConfigurations;
        this.configurations.addAll(list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList());
        super.doOKAction();
    }

    public boolean isOKActionEnabled() {
        if (this.jsonContentAsConfigurations() == null) {
            return false;
        }
        return super.isOKActionEnabled();
    }

    @Nullable
    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.content.getPanel();
    }

    @Nullable
    @NotNull
    protected String getDimensionServiceKey() {
        return "llm.McpServerEditDialog";
    }

    private final List<McpServerConfiguration> jsonContentAsConfigurations() {
        return this.content.getConfigurationsFromJson();
    }

    private static final void _init_$lambda$0(McpServerConfigurationEditDialog this$0) {
        EditorFactory.getInstance().releaseEditor((Editor)this$0.content.getEditor());
    }

    private static final void initEditor$lambda$0(McpServerConfigurationEditDialog this$0, McpServerConfiguration $configuration) {
        DocumentEx documentEx = this$0.content.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document2 = documentEx;
        document2.setText((CharSequence)McpServerConfiguration.Companion.asBean(CollectionsKt.listOf((Object)$configuration)).asJson());
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument((Document)document2);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile((Document)document2);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        new FileInEditorProcessor(file2, (Editor)this$0.content.getEditor(), (LayoutCodeOptions)new ReformatCodeRunOptions(TextRangeType.WHOLE_FILE)).processCode();
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument((Document)document2);
    }

    public static final /* synthetic */ void access$initValidation(McpServerConfigurationEditDialog $this) {
        $this.initValidation();
    }
}

