/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.mcp.client.McpBundle;
import com.intellij.ml.llm.mcp.client.McpClient;
import com.intellij.ml.llm.mcp.client.McpTool;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfiguration;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationItem;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationLevel;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerURL;
import com.intellij.ml.llm.mcp.client.settings.McpServersPanelKt;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\b\u001a\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002\u001a\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u001a\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u001a\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"INTRODUCTION_URL", "", "SERVERS_URL", "createEnabledColumn", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationItem;", "", "CELL_BUTTON_LOOK", "com/intellij/ml/llm/mcp/client/settings/McpServersPanelKt$CELL_BUTTON_LOOK$1", "Lcom/intellij/ml/llm/mcp/client/settings/McpServersPanelKt$CELL_BUTTON_LOOK$1;", "createStatusColumn", "createNameColumn", "createConfigurationColumn", "createLevelColumn", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerConfigurationLevel;", "editable", "createSourceColumn", "CONFIG_FILE_NAME", "MAC_PATH", "WIN_PATH", "intellij.ml.llm.mcp"})
public final class McpServersPanelKt {
    @NotNull
    private static final String INTRODUCTION_URL = "https://modelcontextprotocol.io/introduction";
    @NotNull
    private static final String SERVERS_URL = "https://github.com/modelcontextprotocol/servers";
    @NotNull
    private static final CELL_BUTTON_LOOK.1 CELL_BUTTON_LOOK = new IdeaActionButtonLook(){

        protected JBValue getButtonArc() {
            return (JBValue)new JBValue.Float(0.0f);
        }
    };
    @NotNull
    private static final String CONFIG_FILE_NAME = "claude_desktop_config.json";
    @NotNull
    private static final String MAC_PATH = "Library/Application Support/Claude/claude_desktop_config.json";
    @NotNull
    private static final String WIN_PATH = "Claude/claude_desktop_config.json";

    private static final ColumnInfo<McpServerConfigurationItem, Boolean> createEnabledColumn() {
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, Boolean>(){

            public Boolean valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getConfiguration().getEnabled();
            }

            public Class<?> getColumnClass() {
                return Boolean.TYPE;
            }

            public boolean isCellEditable(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return true;
            }

            public void setValue(McpServerConfigurationItem item, boolean value2) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                item.getConfiguration().setEnabled(value2);
            }
        };
    }

    private static final ColumnInfo<McpServerConfigurationItem, McpServerConfigurationItem> createStatusColumn() {
        String string = McpBundle.message("ml.llm.mcp.server.status", new Object[0]);
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, McpServerConfigurationItem>(string){
            private final createStatusColumn.renderer.1 renderer;
            private final createStatusColumn.editor.1 editor;
            {
                this.renderer = new DefaultTableCellRenderer(this){
                    private final ActionButton actionButton;
                    final /* synthetic */ createStatusColumn.1 this$0;
                    {
                        this.this$0 = $receiver;
                        this.actionButton = new ActionButton((AnAction)DumbAwareAction.create((String)"", arg_0 -> createStatusColumn.renderer.1.actionButton$lambda$1(createStatusColumn.renderer.1::actionButton$lambda$0, arg_0)), new Presentation(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
                        this.actionButton.setLook((ActionButtonLook)McpServersPanelKt.access$getCELL_BUTTON_LOOK$p());
                    }

                    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean selected, boolean focus, int row, int column) {
                        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                        McpServerConfigurationItem mcpServerConfigurationItem = value2 instanceof McpServerConfigurationItem ? (McpServerConfigurationItem)value2 : null;
                        if (mcpServerConfigurationItem == null) {
                            return (Component)this.actionButton;
                        }
                        McpServerConfigurationItem item = mcpServerConfigurationItem;
                        this.actionButton.getPresentation().setIcon(createStatusColumn.1.access$getIcon(this.this$0, item));
                        this.actionButton.setBackground(selected ? table2.getSelectionBackground() : table2.getBackground());
                        return (Component)this.actionButton;
                    }

                    private static final Unit actionButton$lambda$0(AnActionEvent it) {
                        return Unit.INSTANCE;
                    }

                    private static final void actionButton$lambda$1(Function1 $tmp0, Object p0) {
                        $tmp0.invoke(p0);
                    }
                };
                this.editor = new AbstractTableCellEditor(this){
                    private McpServerConfigurationItem value;
                    private final ActionButton actionButton;
                    final /* synthetic */ createStatusColumn.1 this$0;
                    {
                        this.this$0 = $receiver;
                        this.actionButton = new ActionButton((AnAction)DumbAwareAction.create((String)"", arg_0 -> createStatusColumn.editor.1.actionButton$lambda$0((Function1)new Function1<AnActionEvent, Unit>((Object)((Object)this)){

                            public final void invoke(AnActionEvent p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                createStatusColumn.editor.1.access$showPopup((Object)this.receiver, p0);
                            }
                        }, arg_0)), new Presentation(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
                        this.actionButton.setLook((ActionButtonLook)McpServersPanelKt.access$getCELL_BUTTON_LOOK$p());
                    }

                    public Object getCellEditorValue() {
                        return null;
                    }

                    public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
                        McpServerConfigurationItem item;
                        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                        McpServerConfigurationItem mcpServerConfigurationItem = value2 instanceof McpServerConfigurationItem ? (McpServerConfigurationItem)value2 : null;
                        if (mcpServerConfigurationItem == null) {
                            return (Component)this.actionButton;
                        }
                        this.value = item = mcpServerConfigurationItem;
                        this.actionButton.getPresentation().setIcon(createStatusColumn.1.access$getIcon(this.this$0, item));
                        this.actionButton.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                        this.actionButton.setLook((ActionButtonLook)McpServersPanelKt.access$getCELL_BUTTON_LOOK$p());
                        return (Component)this.actionButton;
                    }

                    private final void showPopup(AnActionEvent e) {
                        JEditorPane jEditorPane;
                        McpServerConfigurationItem mcpServerConfigurationItem = this.value;
                        if (mcpServerConfigurationItem == null) {
                            return;
                        }
                        String text2 = createStatusColumn.1.access$getStateText(this.this$0, mcpServerConfigurationItem);
                        JEditorPane $this$showPopup_u24lambda_u241 = jEditorPane = new JEditorPane();
                        boolean bl = false;
                        $this$showPopup_u24lambda_u241.setEditorKit(HTMLEditorKitBuilder.Companion.simple());
                        $this$showPopup_u24lambda_u241.setEditable(false);
                        $this$showPopup_u24lambda_u241.setOpaque(false);
                        $this$showPopup_u24lambda_u241.setBorder(JBUI.Borders.empty((int)10));
                        $this$showPopup_u24lambda_u241.setMargin((Insets)JBUI.emptyInsets());
                        $this$showPopup_u24lambda_u241.setText(text2);
                        $this$showPopup_u24lambda_u241.setCaretPosition(0);
                        $this$showPopup_u24lambda_u241.getCaret().setVisible(false);
                        JEditorPane content2 = jEditorPane;
                        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)content2, (boolean)true);
                        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
                        JScrollPane scrollPane = jScrollPane;
                        scrollPane.setPreferredSize(new Dimension(JBUI.scale((int)400), JBUI.scale((int)200)));
                        Project project2 = e.getProject();
                        if (project2 == null) {
                            return;
                        }
                        Project project3 = project2;
                        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)scrollPane, (JComponent)content2).setDimensionServiceKey(project3, "McpServersPanelStatePopup", false).setResizable(true).setMovable(true).setRequestFocus(true).createPopup().showInBestPositionFor(e.getDataContext());
                    }

                    private static final void actionButton$lambda$0(Function1 $tmp0, Object p0) {
                        $tmp0.invoke(p0);
                    }

                    public static final /* synthetic */ void access$showPopup(createStatusColumn.editor.1 $this, AnActionEvent e) {
                        $this.showPopup(e);
                    }
                };
            }

            private final Icon getIcon(McpServerConfigurationItem item) {
                McpClient.State state2;
                StateFlow<McpClient.State> stateFlow = item.getClient();
                McpClient.State state3 = state2 = stateFlow != null && (stateFlow = stateFlow.getState()) != null ? (McpClient.State)((Object)stateFlow.getValue()) : null;
                Icon stateIcon = switch (state3 == null ? -1 : createStatusColumn.WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                    case 1 -> AllIcons.Status.Success;
                    case 2 -> AllIcons.RunConfigurations.TestError;
                    case 3 -> (Icon)AnimatedIcon.Default.INSTANCE;
                    case -1, 4 -> AllIcons.RunConfigurations.TestIgnored;
                    default -> throw new NoWhenBranchMatchedException();
                };
                Icon[] iconArray = new Icon[]{stateIcon, AllIcons.General.ArrowDown};
                return (Icon)new RowIcon(iconArray);
            }

            private final String getStateText(McpServerConfigurationItem item) {
                McpClient.State state2;
                StateFlow<McpClient.State> stateFlow = item.getClient();
                McpClient.State state3 = state2 = stateFlow != null && (stateFlow = stateFlow.getState()) != null ? (McpClient.State)((Object)stateFlow.getValue()) : null;
                return switch (state3 == null ? -1 : createStatusColumn.WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                    case 1 -> {
                        String toolText = CollectionsKt.joinToString$default((Iterable)item.getClient().getTools(), (CharSequence)"<br><br>", null, null, (int)0, null, createStatusColumn.1::getStateText$lambda$0, (int)30, null);
                        Object[] var4_5 = new Object[]{"<br><br>" + toolText + "<br>"};
                        yield "<html>" + McpBundle.message("ml.llm.mcp.server.tools", var4_5) + "</html>";
                    }
                    case 2 -> {
                        String serviceMessage;
                        String v3 = serviceMessage = item.getClient().getServiceMessage();
                        Object output = v3 != null ? "<br><br>" + v3 : "";
                        yield "<html><code>" + item.getClient().getErrorMessage() + (String)output + "<br></code></html>";
                    }
                    case 3 -> McpBundle.message("ml.llm.mcp.server.starting", new Object[0]) + "<br>";
                    case -1, 4 -> McpBundle.message("ml.llm.mcp.server.not.started", new Object[0]) + "<br>";
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public McpServerConfigurationItem valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item;
            }

            public TableCellRenderer getRenderer(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return this.renderer;
            }

            public TableCellEditor getEditor(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellEditor)((Object)this.editor);
            }

            public String getMaxStringValue() {
                return "";
            }

            public int getAdditionalWidth() {
                return 0;
            }

            public int getWidth(JTable table2) {
                return AllIcons.Status.Success.getIconWidth() + JBUIScale.scale((int)35);
            }

            public boolean isCellEditable(McpServerConfigurationItem item) {
                return true;
            }

            private static final CharSequence getStateText$lambda$0(McpTool tool) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                return "<b>" + tool.getName() + "</b>: <br>" + tool.getDescription();
            }

            public static final /* synthetic */ Icon access$getIcon(createStatusColumn.1 $this, McpServerConfigurationItem item) {
                return $this.getIcon(item);
            }

            public static final /* synthetic */ String access$getStateText(createStatusColumn.1 $this, McpServerConfigurationItem item) {
                return $this.getStateText(item);
            }
        };
    }

    private static final ColumnInfo<McpServerConfigurationItem, String> createNameColumn() {
        String string = McpBundle.message("ml.llm.mcp.server.name", new Object[0]);
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, String>(string){

            public String valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getConfiguration().getName();
            }
        };
    }

    private static final ColumnInfo<McpServerConfigurationItem, String> createConfigurationColumn() {
        String string = McpBundle.message("ml.llm.mcp.server.configuration", new Object[0]);
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, String>(string){

            public String valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                McpServerConfiguration configuration = item.getConfiguration();
                if (configuration instanceof McpServerCommand) {
                    return StringsKt.substringAfterLast$default((String)((McpServerCommand)configuration).getProgramPath(), (char)'/', null, (int)2, null) + " " + ((McpServerCommand)configuration).getArguments();
                }
                if (configuration instanceof McpServerURL) {
                    return ((McpServerURL)configuration).getUrl();
                }
                throw new IllegalStateException("Unknown configuration type: " + configuration.getClass().getName());
            }
        };
    }

    private static final ColumnInfo<McpServerConfigurationItem, McpServerConfigurationLevel> createLevelColumn(boolean editable) {
        String string = McpBundle.message("ml.llm.mcp.server.command.level", new Object[0]);
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, McpServerConfigurationLevel>(editable, string){
            private final createLevelColumn.renderer.1 renderer;
            private final AbstractTableCellEditor editor;
            final /* synthetic */ boolean $editable;
            {
                this.$editable = $editable;
                super($super_call_param$1);
                this.renderer = new DefaultTableCellRenderer(){
                    private final JBComboBoxLabel comboLabel;
                    {
                        this.comboLabel = new JBComboBoxLabel();
                    }

                    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.comboLabel.setText(((McpServerConfigurationLevel)((Object)value2)).getDisplayName());
                        this.comboLabel.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                        this.comboLabel.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
                        this.comboLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                        if (isSelected) {
                            this.comboLabel.setSelectionIcon();
                        } else {
                            this.comboLabel.setRegularIcon();
                        }
                        if (!table2.isCellEditable(row, column)) {
                            this.comboLabel.setForeground(UIUtil.getLabelDisabledForeground());
                            this.comboLabel.setIcon(null);
                        }
                        return (Component)this.comboLabel;
                    }
                };
                this.editor = new AbstractTableCellEditor(){
                    private final JBComboBoxTableCellEditorComponent component;
                    {
                        this.component = new JBComboBoxTableCellEditorComponent();
                        Object[] objectArray = new Object[]{McpServerConfigurationLevel.PROJECT, McpServerConfigurationLevel.GLOBAL};
                        this.component.setOptions(objectArray);
                        this.component.setToString(createLevelColumn.editor.1::_init_$lambda$0);
                        this.component.setWide(true);
                        this.component.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                    }

                    public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
                        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        this.component.setCell(table2, row, column);
                        this.component.setDefaultValue(value2);
                        return (Component)this.component;
                    }

                    public Object getCellEditorValue() {
                        Object object = this.component.getEditorValue();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getEditorValue(...)");
                        return object;
                    }

                    private static final String _init_$lambda$0(Object o) {
                        return o instanceof McpServerConfigurationLevel ? ((McpServerConfigurationLevel)((Object)o)).getDisplayName() : o.toString();
                    }
                };
            }

            public McpServerConfigurationLevel valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getLevel();
            }

            public int getWidth(JTable table2) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                return JBUIScale.scale((int)70);
            }

            public boolean isCellEditable(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return this.$editable;
            }

            public TableCellRenderer getRenderer(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return this.$editable ? (TableCellRenderer)this.renderer : super.getRenderer((Object)item);
            }

            public TableCellEditor getEditor(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellEditor)this.editor;
            }

            public void setValue(McpServerConfigurationItem item, McpServerConfigurationLevel level) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                item.setLevel(level);
            }
        };
    }

    private static final ColumnInfo<McpServerConfigurationItem, String> createSourceColumn() {
        String string = McpBundle.message("ml.llm.mcp.configuration.source", new Object[0]);
        return (ColumnInfo)new ColumnInfo<McpServerConfigurationItem, String>(string){

            public String valueOf(McpServerConfigurationItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = item.getConfiguration().getSource().getDisplayName().get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                return string;
            }

            public String getMaxStringValue() {
                String string = McpServerConfigurationSource.SYSTEM.getDisplayName().get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                return string;
            }
        };
    }

    public static final /* synthetic */ ColumnInfo access$createEnabledColumn() {
        return McpServersPanelKt.createEnabledColumn();
    }

    public static final /* synthetic */ ColumnInfo access$createStatusColumn() {
        return McpServersPanelKt.createStatusColumn();
    }

    public static final /* synthetic */ ColumnInfo access$createNameColumn() {
        return McpServersPanelKt.createNameColumn();
    }

    public static final /* synthetic */ ColumnInfo access$createConfigurationColumn() {
        return McpServersPanelKt.createConfigurationColumn();
    }

    public static final /* synthetic */ ColumnInfo access$createLevelColumn(boolean editable) {
        return McpServersPanelKt.createLevelColumn(editable);
    }

    public static final /* synthetic */ ColumnInfo access$createSourceColumn() {
        return McpServersPanelKt.createSourceColumn();
    }

    public static final /* synthetic */ CELL_BUTTON_LOOK.1 access$getCELL_BUTTON_LOOK$p() {
        return CELL_BUTTON_LOOK;
    }
}

