/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.diff;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.ml.llm.nextEdits.backend.diff.NextEditDiffProducerKt;
import com.intellij.ml.llm.nextEdits.common.diff.NextEditDiff;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diff/NextEditDiffProducer;", "", "<init>", "()V", "composeSingleDiff", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff;", "sourceFragment", "Lcom/intellij/diff/fragments/LineFragment;", "oldText", "", "newText", "create", "", "before", "after", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditDiffProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDiffProducer.kt\ncom/intellij/ml/llm/nextEdits/backend/diff/NextEditDiffProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1617#2,9:193\n1869#2:202\n1870#2:204\n1626#2:205\n1#3:203\n*S KotlinDebug\n*F\n+ 1 NextEditDiffProducer.kt\ncom/intellij/ml/llm/nextEdits/backend/diff/NextEditDiffProducer\n*L\n89#1:193,9\n89#1:202\n89#1:204\n89#1:205\n89#1:203\n*E\n"})
public final class NextEditDiffProducer {
    @NotNull
    public static final NextEditDiffProducer INSTANCE = new NextEditDiffProducer();

    private NextEditDiffProducer() {
    }

    private final NextEditDiff composeSingleDiff(LineFragment sourceFragment, String oldText, String newText) {
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManager, (String)"getInstance(...)");
        ComparisonManager comparisonManager2 = comparisonManager;
        List list = comparisonManager2.compareWords((CharSequence)oldText, (CharSequence)newText, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareWords(...)");
        List words = list;
        List changes2 = new ArrayList();
        for (DiffFragment word : words) {
            NextEditDiff.Change change;
            if (word.getStartOffset2() == word.getEndOffset2()) {
                change = new NextEditDiff.Change.Delete(word.getStartOffset1(), word.getEndOffset1() - word.getStartOffset1());
            } else if (word.getStartOffset1() == word.getEndOffset1()) {
                int n = word.getStartOffset1();
                String string = newText.substring(word.getStartOffset2(), word.getEndOffset2());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                change = new NextEditDiff.Change.Insert(n, string);
            } else {
                String oldPart;
                String newPart;
                Intrinsics.checkNotNullExpressionValue((Object)newText.substring(word.getStartOffset2(), word.getEndOffset2()), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)oldText.substring(word.getStartOffset1(), word.getEndOffset1()), (String)"substring(...)");
                if (StringsKt.startsWith$default((String)newPart, (String)oldPart, (boolean)false, (int)2, null)) {
                    int n = word.getStartOffset1() + oldPart.length();
                    String string = newPart.substring(oldPart.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    change = new NextEditDiff.Change.Insert(n, string);
                } else {
                    change = new NextEditDiff.Change.Replace(word.getStartOffset1(), word.getEndOffset1() - word.getStartOffset1(), newPart);
                }
            }
            NextEditDiff.Change newChange = change;
            ((Collection)changes2).add(newChange);
        }
        return new NextEditDiff(new NextEditDiff.ContentUpdate(oldText, newText, changes2), NextEditDiffProducerKt.access$toNextEditLineFragment(sourceFragment));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NextEditDiff> create(@NotNull String before, @NotNull String after) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        ThreadingAssertions.assertBackgroundThread();
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)before);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
        LineOffsets offsetsBefore = lineOffsets;
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((CharSequence)after);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(...)");
        LineOffsets offsetsAfter = lineOffsets2;
        List list = ComparisonManagerImpl.getInstanceImpl().compareLines((CharSequence)before, (CharSequence)after, offsetsBefore, offsetsAfter, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"compareLines(...)");
        List lineFragments = NextEditDiffProducerKt.access$squashIntersections(NextEditDiffProducerKt.access$adjustNewLinesAdditions(list, offsetsBefore, offsetsAfter));
        Iterable $this$mapNotNull$iv = lineFragments;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NextEditDiff nextEditDiff;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LineFragment fragment = (LineFragment)element$iv$iv;
            boolean bl2 = false;
            if (fragment.getStartOffset1() > fragment.getEndOffset1() || fragment.getStartOffset2() > fragment.getEndOffset2()) {
                nextEditDiff = null;
            } else {
                String oldText;
                String newText;
                Intrinsics.checkNotNullExpressionValue((Object)before.substring(fragment.getStartOffset1(), fragment.getEndOffset1()), (String)"substring(...)");
                Intrinsics.checkNotNullExpressionValue((Object)after.substring(fragment.getStartOffset2(), fragment.getEndOffset2()), (String)"substring(...)");
                nextEditDiff = Intrinsics.areEqual((Object)newText, (Object)oldText) ? null : INSTANCE.composeSingleDiff(fragment, oldText, newText);
            }
            if (nextEditDiff == null) continue;
            NextEditDiff it$iv$iv = nextEditDiff;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List diffs = (List)destination$iv$iv;
        return diffs;
    }
}

