/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.history;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.text.ImmutableCharSequence;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\b\u0018\u0000 52\u00020\u0001:\u0003345B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\bH\u00c6\u0003J\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003Jw\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\u0003H\u00d6\u0001J\t\u00102\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013\u00a8\u00066"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange;", "", "startOffset", "", "oldFragment", "", "newFragment", "newModificationStamp", "", "oldModificationStamp", "timestamp", "contextStartLine", "contextStartOffset", "contextEndOffset", "contextBefore", "contextAfter", "<init>", "(ILjava/lang/String;Ljava/lang/String;JJJIIILjava/lang/String;Ljava/lang/String;)V", "getStartOffset", "()I", "getOldFragment", "()Ljava/lang/String;", "getNewFragment", "getNewModificationStamp", "()J", "getOldModificationStamp", "getTimestamp", "getContextStartLine", "getContextStartOffset", "getContextEndOffset", "getContextBefore", "getContextAfter", "delta", "getDelta", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "", "other", "hashCode", "toString", "Init", "SquashResult", "Companion", "intellij.ml.llm.nextEdits.backend"})
public final class NextEditFileChange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int startOffset;
    @NotNull
    private final String oldFragment;
    @NotNull
    private final String newFragment;
    private final long newModificationStamp;
    private final long oldModificationStamp;
    private final long timestamp;
    private final int contextStartLine;
    private final int contextStartOffset;
    private final int contextEndOffset;
    @NotNull
    private final String contextBefore;
    @NotNull
    private final String contextAfter;

    public NextEditFileChange(int startOffset, @NotNull String oldFragment, @NotNull String newFragment, long newModificationStamp, long oldModificationStamp, long timestamp, int contextStartLine, int contextStartOffset, int contextEndOffset, @NotNull String contextBefore, @NotNull String contextAfter) {
        Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
        Intrinsics.checkNotNullParameter((Object)newFragment, (String)"newFragment");
        Intrinsics.checkNotNullParameter((Object)contextBefore, (String)"contextBefore");
        Intrinsics.checkNotNullParameter((Object)contextAfter, (String)"contextAfter");
        this.startOffset = startOffset;
        this.oldFragment = oldFragment;
        this.newFragment = newFragment;
        this.newModificationStamp = newModificationStamp;
        this.oldModificationStamp = oldModificationStamp;
        this.timestamp = timestamp;
        this.contextStartLine = contextStartLine;
        this.contextStartOffset = contextStartOffset;
        this.contextEndOffset = contextEndOffset;
        this.contextBefore = contextBefore;
        this.contextAfter = contextAfter;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    @NotNull
    public final String getOldFragment() {
        return this.oldFragment;
    }

    @NotNull
    public final String getNewFragment() {
        return this.newFragment;
    }

    public final long getNewModificationStamp() {
        return this.newModificationStamp;
    }

    public final long getOldModificationStamp() {
        return this.oldModificationStamp;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final int getContextStartLine() {
        return this.contextStartLine;
    }

    public final int getContextStartOffset() {
        return this.contextStartOffset;
    }

    public final int getContextEndOffset() {
        return this.contextEndOffset;
    }

    @NotNull
    public final String getContextBefore() {
        return this.contextBefore;
    }

    @NotNull
    public final String getContextAfter() {
        return this.contextAfter;
    }

    public final int getDelta() {
        return this.newFragment.length() - this.oldFragment.length();
    }

    public final int component1() {
        return this.startOffset;
    }

    @NotNull
    public final String component2() {
        return this.oldFragment;
    }

    @NotNull
    public final String component3() {
        return this.newFragment;
    }

    public final long component4() {
        return this.newModificationStamp;
    }

    public final long component5() {
        return this.oldModificationStamp;
    }

    public final long component6() {
        return this.timestamp;
    }

    public final int component7() {
        return this.contextStartLine;
    }

    public final int component8() {
        return this.contextStartOffset;
    }

    public final int component9() {
        return this.contextEndOffset;
    }

    @NotNull
    public final String component10() {
        return this.contextBefore;
    }

    @NotNull
    public final String component11() {
        return this.contextAfter;
    }

    @NotNull
    public final NextEditFileChange copy(int startOffset, @NotNull String oldFragment, @NotNull String newFragment, long newModificationStamp, long oldModificationStamp, long timestamp, int contextStartLine, int contextStartOffset, int contextEndOffset, @NotNull String contextBefore, @NotNull String contextAfter) {
        Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
        Intrinsics.checkNotNullParameter((Object)newFragment, (String)"newFragment");
        Intrinsics.checkNotNullParameter((Object)contextBefore, (String)"contextBefore");
        Intrinsics.checkNotNullParameter((Object)contextAfter, (String)"contextAfter");
        return new NextEditFileChange(startOffset, oldFragment, newFragment, newModificationStamp, oldModificationStamp, timestamp, contextStartLine, contextStartOffset, contextEndOffset, contextBefore, contextAfter);
    }

    public static /* synthetic */ NextEditFileChange copy$default(NextEditFileChange nextEditFileChange, int n, String string, String string2, long l, long l2, long l3, int n2, int n3, int n4, String string3, String string4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = nextEditFileChange.startOffset;
        }
        if ((n5 & 2) != 0) {
            string = nextEditFileChange.oldFragment;
        }
        if ((n5 & 4) != 0) {
            string2 = nextEditFileChange.newFragment;
        }
        if ((n5 & 8) != 0) {
            l = nextEditFileChange.newModificationStamp;
        }
        if ((n5 & 0x10) != 0) {
            l2 = nextEditFileChange.oldModificationStamp;
        }
        if ((n5 & 0x20) != 0) {
            l3 = nextEditFileChange.timestamp;
        }
        if ((n5 & 0x40) != 0) {
            n2 = nextEditFileChange.contextStartLine;
        }
        if ((n5 & 0x80) != 0) {
            n3 = nextEditFileChange.contextStartOffset;
        }
        if ((n5 & 0x100) != 0) {
            n4 = nextEditFileChange.contextEndOffset;
        }
        if ((n5 & 0x200) != 0) {
            string3 = nextEditFileChange.contextBefore;
        }
        if ((n5 & 0x400) != 0) {
            string4 = nextEditFileChange.contextAfter;
        }
        return nextEditFileChange.copy(n, string, string2, l, l2, l3, n2, n3, n4, string3, string4);
    }

    @NotNull
    public String toString() {
        return "NextEditFileChange(startOffset=" + this.startOffset + ", oldFragment=" + this.oldFragment + ", newFragment=" + this.newFragment + ", newModificationStamp=" + this.newModificationStamp + ", oldModificationStamp=" + this.oldModificationStamp + ", timestamp=" + this.timestamp + ", contextStartLine=" + this.contextStartLine + ", contextStartOffset=" + this.contextStartOffset + ", contextEndOffset=" + this.contextEndOffset + ", contextBefore=" + this.contextBefore + ", contextAfter=" + this.contextAfter + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.startOffset);
        result2 = result2 * 31 + this.oldFragment.hashCode();
        result2 = result2 * 31 + this.newFragment.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.newModificationStamp);
        result2 = result2 * 31 + Long.hashCode(this.oldModificationStamp);
        result2 = result2 * 31 + Long.hashCode(this.timestamp);
        result2 = result2 * 31 + Integer.hashCode(this.contextStartLine);
        result2 = result2 * 31 + Integer.hashCode(this.contextStartOffset);
        result2 = result2 * 31 + Integer.hashCode(this.contextEndOffset);
        result2 = result2 * 31 + this.contextBefore.hashCode();
        result2 = result2 * 31 + this.contextAfter.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NextEditFileChange)) {
            return false;
        }
        NextEditFileChange nextEditFileChange = (NextEditFileChange)other;
        if (this.startOffset != nextEditFileChange.startOffset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.oldFragment, (Object)nextEditFileChange.oldFragment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.newFragment, (Object)nextEditFileChange.newFragment)) {
            return false;
        }
        if (this.newModificationStamp != nextEditFileChange.newModificationStamp) {
            return false;
        }
        if (this.oldModificationStamp != nextEditFileChange.oldModificationStamp) {
            return false;
        }
        if (this.timestamp != nextEditFileChange.timestamp) {
            return false;
        }
        if (this.contextStartLine != nextEditFileChange.contextStartLine) {
            return false;
        }
        if (this.contextStartOffset != nextEditFileChange.contextStartOffset) {
            return false;
        }
        if (this.contextEndOffset != nextEditFileChange.contextEndOffset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contextBefore, (Object)nextEditFileChange.contextBefore)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.contextAfter, (Object)nextEditFileChange.contextAfter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tJ&\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Companion;", "", "<init>", "()V", "getChangeInit", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Init;", "document", "Lcom/intellij/openapi/editor/Document;", "startOffset", "", "oldFragment", "", "newFragment", "newModificationStamp", "", "oldModificationStamp", "contextLinesNumber", "documentEvent", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getChange", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange;", "changeInit", "documentContent", "Lcom/intellij/util/text/ImmutableCharSequence;", "squash", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult;", "change1", "change2", "restoreTextFromContextsAfterChange1", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditFileChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditFileChange.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,297:1\n1104#2,3:298\n*S KotlinDebug\n*F\n+ 1 NextEditFileChange.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Companion\n*L\n161#1:298,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @NotNull
        public final Init getChangeInit(@NotNull Document document2, int startOffset, @NotNull String oldFragment, @NotNull String newFragment, long newModificationStamp, long oldModificationStamp, int contextLinesNumber) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
            Intrinsics.checkNotNullParameter((Object)newFragment, (String)"newFragment");
            int startLine = document2.getLineNumber(startOffset);
            int endLine = document2.getLineNumber(startOffset + oldFragment.length());
            int contextStartLine = RangesKt.coerceAtLeast((int)(startLine - contextLinesNumber), (int)0);
            int contextEndLine = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(endLine + contextLinesNumber), (int)(document2.getLineCount() - 1)), (int)0);
            int contextStartOffset = document2.getLineStartOffset(contextStartLine);
            int contextEndOffset = document2.getLineEndOffset(contextEndLine);
            return new Init(startOffset, oldFragment, newFragment, newModificationStamp, oldModificationStamp, System.currentTimeMillis(), contextStartLine, contextStartOffset, contextEndOffset);
        }

        @RequiresReadLock
        @NotNull
        public final Init getChangeInit(@NotNull DocumentEvent documentEvent, int contextLinesNumber) {
            Intrinsics.checkNotNullParameter((Object)documentEvent, (String)"documentEvent");
            Document document2 = documentEvent.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            return this.getChangeInit(document2, documentEvent.getOffset(), ((Object)documentEvent.getOldFragment()).toString(), ((Object)documentEvent.getNewFragment()).toString(), documentEvent.getDocument().getModificationStamp(), documentEvent.getOldTimeStamp(), contextLinesNumber);
        }

        @NotNull
        public final NextEditFileChange getChange(@NotNull Init changeInit, @NotNull ImmutableCharSequence documentContent) {
            Intrinsics.checkNotNullParameter((Object)changeInit, (String)"changeInit");
            Intrinsics.checkNotNullParameter((Object)documentContent, (String)"documentContent");
            String string = documentContent.subtext(changeInit.getContextStartOffset(), changeInit.getContextEndOffset()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String textWithContext = string;
            String contextBefore = StringsKt.take((String)textWithContext, (int)(changeInit.getStartOffset() - changeInit.getContextStartOffset()));
            int actualEndOffset = changeInit.getStartOffset() + changeInit.getOldFragment().length();
            String contextAfter = StringsKt.takeLast((String)textWithContext, (int)(changeInit.getContextEndOffset() - actualEndOffset));
            return new NextEditFileChange(changeInit.getStartOffset(), changeInit.getOldFragment(), changeInit.getNewFragment(), changeInit.getNewModificationStamp(), changeInit.getOldModificationStamp(), changeInit.getTimestamp(), changeInit.getContextStartLine(), changeInit.getContextStartOffset(), changeInit.getContextEndOffset(), contextBefore, contextAfter);
        }

        @NotNull
        public final SquashResult squash(@NotNull NextEditFileChange change1, @NotNull NextEditFileChange change2, int contextLinesNumber) {
            String fragmentAfterChange1;
            String oldFragment;
            int n;
            CharSequence $this$count$iv;
            int end22;
            int change2RelativeEndOffsetAfterChange1;
            int change2RelativeStartOffsetAfterChange1;
            TextRange change2RelativeRangeAfterChange1;
            int change1RelativeEndOffsetAfterChange1;
            Intrinsics.checkNotNullParameter((Object)change1, (String)"change1");
            Intrinsics.checkNotNullParameter((Object)change2, (String)"change2");
            Pair<String, TextRange> pair = this.restoreTextFromContextsAfterChange1(change1, change2);
            if (pair == null) {
                return SquashResult.CannotSquash.INSTANCE;
            }
            Pair<String, TextRange> pair2 = pair;
            String textAfterChange1 = (String)pair2.component1();
            TextRange textAfterChange1Range = (TextRange)pair2.component2();
            int change1RelativeStartOffsetAfterChange1 = change1.getStartOffset() - textAfterChange1Range.getStartOffset();
            TextRange change1RelativeRangeAfterChange1 = new TextRange(change1RelativeStartOffsetAfterChange1, change1RelativeEndOffsetAfterChange1 = change1RelativeStartOffsetAfterChange1 + change1.getNewFragment().length());
            if (!change1RelativeRangeAfterChange1.intersects(change2RelativeRangeAfterChange1 = new TextRange(change2RelativeStartOffsetAfterChange1 = change2.getStartOffset() - textAfterChange1Range.getStartOffset(), change2RelativeEndOffsetAfterChange1 = change2RelativeStartOffsetAfterChange1 + change2.getOldFragment().length()))) {
                Pair pair3;
                if (change1RelativeRangeAfterChange1.getEndOffset() <= change2RelativeRangeAfterChange1.getStartOffset()) {
                    pair3 = TuplesKt.to((Object)change1RelativeRangeAfterChange1.getEndOffset(), (Object)change2RelativeRangeAfterChange1.getStartOffset());
                } else if (change2RelativeRangeAfterChange1.getEndOffset() <= change1RelativeRangeAfterChange1.getStartOffset()) {
                    pair3 = TuplesKt.to((Object)change2RelativeRangeAfterChange1.getEndOffset(), (Object)change1RelativeRangeAfterChange1.getStartOffset());
                } else {
                    return SquashResult.CannotSquash.INSTANCE;
                }
                Pair pair4 = pair3;
                int start2 = ((Number)pair4.component1()).intValue();
                end22 = ((Number)pair4.component2()).intValue();
                String string = textAfterChange1.substring(start2, end22);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence charSequence = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    n = 0;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                int linesBetween22 = count$iv;
                if (linesBetween22 > contextLinesNumber) {
                    return SquashResult.CannotSquash.INSTANCE;
                }
            }
            String start2 = textAfterChange1;
            end22 = change1RelativeStartOffsetAfterChange1 + change1.getNewFragment().length();
            CharSequence linesBetween22 = change1.getOldFragment();
            String initialText = ((Object)StringsKt.replaceRange((CharSequence)start2, (int)change1RelativeStartOffsetAfterChange1, (int)end22, (CharSequence)linesBetween22)).toString();
            String end22 = textAfterChange1;
            int linesBetween22 = change2RelativeStartOffsetAfterChange1 + change2.getOldFragment().length();
            $this$count$iv = change2.getNewFragment();
            String finalText = ((Object)StringsKt.replaceRange((CharSequence)end22, (int)change2RelativeStartOffsetAfterChange1, (int)linesBetween22, (CharSequence)$this$count$iv)).toString();
            TextRange finalTextRange = new TextRange(textAfterChange1Range.getStartOffset(), textAfterChange1Range.getEndOffset() + change2.getDelta());
            if (Intrinsics.areEqual((Object)initialText, (Object)finalText)) {
                return SquashResult.EmptyResult.INSTANCE;
            }
            int change2EndOffset = change2.getStartOffset() + change2.getOldFragment().length();
            int change1EndOffset = change1.getStartOffset() + change1.getOldFragment().length();
            int adjustedStart2 = com.intellij.ml.llm.nextEdits.backend.history.NextEditFileChange$Companion.squash$adjustOffsetAfterChange1ToGetInitialOffset(change1, change2.getStartOffset());
            int adjustedEnd2 = com.intellij.ml.llm.nextEdits.backend.history.NextEditFileChange$Companion.squash$adjustOffsetAfterChange1ToGetInitialOffset(change1, change2EndOffset);
            int contextStartOffset = finalTextRange.getStartOffset();
            int newStartOffset = Math.max(Math.min(change1.getStartOffset(), adjustedStart2), contextStartOffset);
            n = Math.max(change1EndOffset, adjustedEnd2);
            int n2 = contextStartOffset + initialText.length();
            int newEndOffset = Math.min(n, n2);
            String string = initialText;
            int n3 = newStartOffset - contextStartOffset;
            int n4 = newEndOffset - contextStartOffset;
            String string2 = string.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = oldFragment = string2;
            n4 = change1.getStartOffset() - newStartOffset;
            int n5 = change1EndOffset - newStartOffset;
            CharSequence charSequence = change1.getNewFragment();
            String string4 = fragmentAfterChange1 = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n4, (int)n5, (CharSequence)charSequence)).toString();
            n5 = change2.getStartOffset() - newStartOffset;
            int n6 = change2EndOffset - newStartOffset;
            CharSequence charSequence2 = change2.getNewFragment();
            String newFragment = ((Object)StringsKt.replaceRange((CharSequence)string4, (int)n5, (int)n6, (CharSequence)charSequence2)).toString();
            n5 = change1.getContextStartLine();
            n6 = change2.getContextStartLine();
            int contextStartLine = Math.min(n5, n6);
            return new SquashResult.Squashed(new NextEditFileChange(newStartOffset, oldFragment, newFragment, change2.getNewModificationStamp(), change1.getOldModificationStamp(), change2.getTimestamp(), contextStartLine, finalTextRange.getStartOffset(), finalTextRange.getEndOffset() - change1.getDelta() - change2.getDelta(), StringsKt.take((String)initialText, (int)(newStartOffset - contextStartOffset)), StringsKt.takeLast((String)finalText, (int)(contextStartOffset + initialText.length() - newEndOffset))));
        }

        private final Pair<String, TextRange> restoreTextFromContextsAfterChange1(NextEditFileChange change1, NextEditFileChange change2) {
            StringBuilder stringBuilder;
            TextRange range2AfterChange1;
            TextRange range1AfterChange1 = new TextRange(change1.getContextStartOffset(), change1.getContextEndOffset() + change1.getDelta());
            TextRange rangeIntersectionAfterChange1 = range1AfterChange1.intersection(range2AfterChange1 = new TextRange(change2.getContextStartOffset(), change2.getContextEndOffset()));
            if (rangeIntersectionAfterChange1 == null) {
                return null;
            }
            StringBuilder $this$restoreTextFromContextsAfterChange1_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$restoreTextFromContextsAfterChange1_u24lambda_u240.append(change1.getContextBefore());
            $this$restoreTextFromContextsAfterChange1_u24lambda_u240.append(change1.getNewFragment());
            $this$restoreTextFromContextsAfterChange1_u24lambda_u240.append(change1.getContextAfter());
            String text1AfterChange1 = stringBuilder.toString();
            StringBuilder $this$restoreTextFromContextsAfterChange1_u24lambda_u241 = $this$restoreTextFromContextsAfterChange1_u24lambda_u240 = new StringBuilder();
            boolean $i$a$-buildString-NextEditFileChange$Companion$restoreTextFromContextsAfterChange1$text2AfterChange1$22 = false;
            $this$restoreTextFromContextsAfterChange1_u24lambda_u241.append(change2.getContextBefore());
            $this$restoreTextFromContextsAfterChange1_u24lambda_u241.append(change2.getOldFragment());
            $this$restoreTextFromContextsAfterChange1_u24lambda_u241.append(change2.getContextAfter());
            String text2AfterChange1 = $this$restoreTextFromContextsAfterChange1_u24lambda_u240.toString();
            if (!(rangeIntersectionAfterChange1.getStartOffset() >= change1.getContextStartOffset())) {
                throw new IllegalStateException("Check failed.");
            }
            TextRange textRange = rangeIntersectionAfterChange1.shiftLeft(change1.getContextStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
            TextRange rangeToReplace = textRange;
            String $i$a$-buildString-NextEditFileChange$Companion$restoreTextFromContextsAfterChange1$text2AfterChange1$22 = text1AfterChange1;
            int n = rangeToReplace.getStartOffset();
            int n2 = rangeToReplace.getEndOffset();
            String finalText = ((Object)StringsKt.replaceRange((CharSequence)$i$a$-buildString-NextEditFileChange$Companion$restoreTextFromContextsAfterChange1$text2AfterChange1$22, (int)n, (int)n2, (CharSequence)text2AfterChange1)).toString();
            TextRange textRange2 = range1AfterChange1.union(range2AfterChange1);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"union(...)");
            TextRange finalRange = textRange2;
            if (!(finalText.length() == finalRange.getLength())) {
                throw new IllegalStateException("Check failed.");
            }
            return TuplesKt.to((Object)finalText, (Object)finalRange);
        }

        private static final int squash$adjustOffsetAfterChange1ToGetInitialOffset(NextEditFileChange $change1, int offset) {
            if (offset <= $change1.getStartOffset()) {
                return offset;
            }
            if ($change1.getDelta() < 0) {
                return offset - $change1.getDelta();
            }
            int adjustment = Math.min(offset - $change1.getStartOffset(), $change1.getDelta());
            return offset - adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003Jc\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Init;", "", "startOffset", "", "oldFragment", "", "newFragment", "newModificationStamp", "", "oldModificationStamp", "timestamp", "contextStartLine", "contextStartOffset", "contextEndOffset", "<init>", "(ILjava/lang/String;Ljava/lang/String;JJJIII)V", "getStartOffset", "()I", "getOldFragment", "()Ljava/lang/String;", "getNewFragment", "getNewModificationStamp", "()J", "getOldModificationStamp", "getTimestamp", "getContextStartLine", "getContextStartOffset", "getContextEndOffset", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.nextEdits.backend"})
    public static final class Init {
        private final int startOffset;
        @NotNull
        private final String oldFragment;
        @NotNull
        private final String newFragment;
        private final long newModificationStamp;
        private final long oldModificationStamp;
        private final long timestamp;
        private final int contextStartLine;
        private final int contextStartOffset;
        private final int contextEndOffset;

        public Init(int startOffset, @NotNull String oldFragment, @NotNull String newFragment, long newModificationStamp, long oldModificationStamp, long timestamp, int contextStartLine, int contextStartOffset, int contextEndOffset) {
            Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
            Intrinsics.checkNotNullParameter((Object)newFragment, (String)"newFragment");
            this.startOffset = startOffset;
            this.oldFragment = oldFragment;
            this.newFragment = newFragment;
            this.newModificationStamp = newModificationStamp;
            this.oldModificationStamp = oldModificationStamp;
            this.timestamp = timestamp;
            this.contextStartLine = contextStartLine;
            this.contextStartOffset = contextStartOffset;
            this.contextEndOffset = contextEndOffset;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        @NotNull
        public final String getOldFragment() {
            return this.oldFragment;
        }

        @NotNull
        public final String getNewFragment() {
            return this.newFragment;
        }

        public final long getNewModificationStamp() {
            return this.newModificationStamp;
        }

        public final long getOldModificationStamp() {
            return this.oldModificationStamp;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final int getContextStartLine() {
            return this.contextStartLine;
        }

        public final int getContextStartOffset() {
            return this.contextStartOffset;
        }

        public final int getContextEndOffset() {
            return this.contextEndOffset;
        }

        public final int component1() {
            return this.startOffset;
        }

        @NotNull
        public final String component2() {
            return this.oldFragment;
        }

        @NotNull
        public final String component3() {
            return this.newFragment;
        }

        public final long component4() {
            return this.newModificationStamp;
        }

        public final long component5() {
            return this.oldModificationStamp;
        }

        public final long component6() {
            return this.timestamp;
        }

        public final int component7() {
            return this.contextStartLine;
        }

        public final int component8() {
            return this.contextStartOffset;
        }

        public final int component9() {
            return this.contextEndOffset;
        }

        @NotNull
        public final Init copy(int startOffset, @NotNull String oldFragment, @NotNull String newFragment, long newModificationStamp, long oldModificationStamp, long timestamp, int contextStartLine, int contextStartOffset, int contextEndOffset) {
            Intrinsics.checkNotNullParameter((Object)oldFragment, (String)"oldFragment");
            Intrinsics.checkNotNullParameter((Object)newFragment, (String)"newFragment");
            return new Init(startOffset, oldFragment, newFragment, newModificationStamp, oldModificationStamp, timestamp, contextStartLine, contextStartOffset, contextEndOffset);
        }

        public static /* synthetic */ Init copy$default(Init init, int n, String string, String string2, long l, long l2, long l3, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = init.startOffset;
            }
            if ((n5 & 2) != 0) {
                string = init.oldFragment;
            }
            if ((n5 & 4) != 0) {
                string2 = init.newFragment;
            }
            if ((n5 & 8) != 0) {
                l = init.newModificationStamp;
            }
            if ((n5 & 0x10) != 0) {
                l2 = init.oldModificationStamp;
            }
            if ((n5 & 0x20) != 0) {
                l3 = init.timestamp;
            }
            if ((n5 & 0x40) != 0) {
                n2 = init.contextStartLine;
            }
            if ((n5 & 0x80) != 0) {
                n3 = init.contextStartOffset;
            }
            if ((n5 & 0x100) != 0) {
                n4 = init.contextEndOffset;
            }
            return init.copy(n, string, string2, l, l2, l3, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Init(startOffset=" + this.startOffset + ", oldFragment=" + this.oldFragment + ", newFragment=" + this.newFragment + ", newModificationStamp=" + this.newModificationStamp + ", oldModificationStamp=" + this.oldModificationStamp + ", timestamp=" + this.timestamp + ", contextStartLine=" + this.contextStartLine + ", contextStartOffset=" + this.contextStartOffset + ", contextEndOffset=" + this.contextEndOffset + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startOffset);
            result2 = result2 * 31 + this.oldFragment.hashCode();
            result2 = result2 * 31 + this.newFragment.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.newModificationStamp);
            result2 = result2 * 31 + Long.hashCode(this.oldModificationStamp);
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            result2 = result2 * 31 + Integer.hashCode(this.contextStartLine);
            result2 = result2 * 31 + Integer.hashCode(this.contextStartOffset);
            result2 = result2 * 31 + Integer.hashCode(this.contextEndOffset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Init)) {
                return false;
            }
            Init init = (Init)other;
            if (this.startOffset != init.startOffset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.oldFragment, (Object)init.oldFragment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newFragment, (Object)init.newFragment)) {
                return false;
            }
            if (this.newModificationStamp != init.newModificationStamp) {
                return false;
            }
            if (this.oldModificationStamp != init.oldModificationStamp) {
                return false;
            }
            if (this.timestamp != init.timestamp) {
                return false;
            }
            if (this.contextStartLine != init.contextStartLine) {
                return false;
            }
            if (this.contextStartOffset != init.contextStartOffset) {
                return false;
            }
            return this.contextEndOffset == init.contextEndOffset;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult;", "", "Squashed", "CannotSquash", "EmptyResult", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$CannotSquash;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$EmptyResult;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$Squashed;", "intellij.ml.llm.nextEdits.backend"})
    public static sealed interface SquashResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$CannotSquash;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
        public static final class CannotSquash
        implements SquashResult {
            @NotNull
            public static final CannotSquash INSTANCE = new CannotSquash();

            private CannotSquash() {
            }

            @NotNull
            public String toString() {
                return "CannotSquash";
            }

            public int hashCode() {
                return 214965921;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CannotSquash)) {
                    return false;
                }
                CannotSquash cfr_ignored_0 = (CannotSquash)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$EmptyResult;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
        public static final class EmptyResult
        implements SquashResult {
            @NotNull
            public static final EmptyResult INSTANCE = new EmptyResult();

            private EmptyResult() {
            }

            @NotNull
            public String toString() {
                return "EmptyResult";
            }

            public int hashCode() {
                return -2130087573;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EmptyResult)) {
                    return false;
                }
                EmptyResult cfr_ignored_0 = (EmptyResult)other;
                return true;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult$Squashed;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$SquashResult;", "new", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange;)V", "getNew", "()Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
        public static final class Squashed
        implements SquashResult {
            @NotNull
            private final NextEditFileChange new;

            public Squashed(@NotNull NextEditFileChange nextEditFileChange) {
                Intrinsics.checkNotNullParameter((Object)nextEditFileChange, (String)"new");
                this.new = nextEditFileChange;
            }

            @NotNull
            public final NextEditFileChange getNew() {
                return this.new;
            }

            @NotNull
            public final NextEditFileChange component1() {
                return this.new;
            }

            @NotNull
            public final Squashed copy(@NotNull NextEditFileChange nextEditFileChange) {
                Intrinsics.checkNotNullParameter((Object)nextEditFileChange, (String)"new");
                return new Squashed(nextEditFileChange);
            }

            public static /* synthetic */ Squashed copy$default(Squashed squashed, NextEditFileChange nextEditFileChange, int n, Object object) {
                if ((n & 1) != 0) {
                    nextEditFileChange = squashed.new;
                }
                return squashed.copy(nextEditFileChange);
            }

            @NotNull
            public String toString() {
                return "Squashed(new=" + this.new + ")";
            }

            public int hashCode() {
                return this.new.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Squashed)) {
                    return false;
                }
                Squashed squashed = (Squashed)other;
                return Intrinsics.areEqual((Object)this.new, (Object)squashed.new);
            }
        }
    }
}

