/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "changes", "", "Lcom/intellij/openapi/editor/RangeMarker;", "getRecentChanges", "", "addChange", "", "change", "isRangeAlreadyContained", "", "start", "", "end", "clearAll", "dispose", "track", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Companion", "intellij.ml.llm.nextEdits.backend"})
@SourceDebugExtension(value={"SMAP\nNextEditUserRecentChangeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1761#2,3:95\n1869#2,2:98\n*S KotlinDebug\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore\n*L\n34#1:95,3\n43#1:98,2\n*E\n"})
public final class NextEditUserRecentChangeStore
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RangeMarker> changes = new ArrayList();
    @NotNull
    private static final Key<NextEditUserRecentChangeStore> KEY = new Key("next.edit.recentChangeStore");
    private static final int MAX_RECENT_CHANGE_PER_EDITOR = 5;

    @RequiresEdt
    @NotNull
    public final List<RangeMarker> getRecentChanges() {
        ThreadingAssertions.assertEventDispatchThread();
        return CollectionsKt.toList((Iterable)this.changes);
    }

    @RequiresEdt
    public final void addChange(@NotNull RangeMarker change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ThreadingAssertions.assertEventDispatchThread();
        if (!((Collection)this.changes).isEmpty() && this.changes.size() >= 5) {
            this.changes.removeFirst().dispose();
        }
        this.changes.add(change);
    }

    @RequiresEdt
    public final boolean isRangeAlreadyContained(int start2, int end) {
        boolean bl;
        block3: {
            ThreadingAssertions.assertEventDispatchThread();
            Iterable $this$any$iv = this.changes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RangeMarker it = (RangeMarker)element$iv;
                    boolean bl2 = false;
                    if (!(it.isValid() && it.getStartOffset() <= start2 && end <= it.getEndOffset())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @RequiresEdt
    public final void clearAll() {
        ThreadingAssertions.assertEventDispatchThread();
        List<RangeMarker> changes2 = this.changes;
        boolean bl = false;
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker it = (RangeMarker)element$iv;
            boolean bl2 = false;
            it.dispose();
        }
        changes2.clear();
    }

    public void dispose() {
        this.clearAll();
    }

    @RequiresEdt
    public final void track(@NotNull DocumentEvent event2) {
        int end;
        int start2;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ThreadingAssertions.assertEventDispatchThread();
        if (event2.getOldLength() > 0) {
            this.clearAll();
        } else if (event2.getNewLength() > 0 && !this.isRangeAlreadyContained(start2 = event2.getOffset(), end = start2 + event2.getNewLength())) {
            RangeMarker rangeMarker;
            RangeMarker it = rangeMarker = event2.getDocument().createRangeMarker(start2, end);
            boolean bl = false;
            it.setGreedyToLeft(true);
            it.setGreedyToRight(true);
            RangeMarker rangeMarker2 = rangeMarker;
            Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"also(...)");
            RangeMarker rangeMarker3 = rangeMarker2;
            this.addChange(rangeMarker3);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "uninstall", "getInstance", "MAX_RECENT_CHANGE_PER_EDITOR", "", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditUserRecentChangeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditUserRecentChangeStore.kt\ncom/intellij/ml/llm/nextEdits/backend/history/NextEditUserRecentChangeStore$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditUserRecentChangeStore store = new NextEditUserRecentChangeStore();
            editor2.putUserData(KEY, (Object)store);
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.install$lambda$0(editor2));
        }

        @RequiresEdt
        public final void uninstall(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditUserRecentChangeStore nextEditUserRecentChangeStore = (NextEditUserRecentChangeStore)editor2.getUserData(KEY);
            if (nextEditUserRecentChangeStore != null) {
                NextEditUserRecentChangeStore it = nextEditUserRecentChangeStore;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
        }

        @Nullable
        public final NextEditUserRecentChangeStore getInstance(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (NextEditUserRecentChangeStore)editor2.getUserData(KEY);
        }

        private static final void install$lambda$0(Editor $editor) {
            Companion.uninstall($editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

