/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.install;

import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.diagnostics.DiagnosticsLoggerKt;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.FrontendNextEditEventsRaker;
import com.intellij.ml.llm.nextEdits.backend.history.NextEditUserRecentChangeStore;
import com.intellij.ml.llm.nextEdits.backend.install.NextEditFileHistoryDocumentListener;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditDetailedLogsService;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditFilePath;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditFilePathForDocumentProvider;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditFilePathKt;
import com.intellij.ml.llm.nextEdits.backend.util.IgnoredUtils;
import com.intellij.ml.llm.nextEdits.common.install.NextEditInstallUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/install/BackendNextEditInstaller;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "tryInstall", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "uninstall", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.nextEdits.backend"})
@SourceDebugExtension(value={"SMAP\nBackendNextEditInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/backend/install/BackendNextEditInstaller\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n1#2:72\n25#3:73\n13#4:74\n*S KotlinDebug\n*F\n+ 1 BackendNextEditInstaller.kt\ncom/intellij/ml/llm/nextEdits/backend/install/BackendNextEditInstaller\n*L\n69#1:73\n69#1:74\n*E\n"})
public final class BackendNextEditInstaller {
    @NotNull
    public static final BackendNextEditInstaller INSTANCE = new BackendNextEditInstaller();
    @NotNull
    private static final Key<Disposable> KEY;
    @NotNull
    private static final Logger LOG;

    private BackendNextEditInstaller() {
    }

    public final void tryInstall(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!EDT.isCurrentThreadEdt()) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Next Edit [backend] must be installed on EDT", null, (int)2, null);
            return;
        }
        EditorImpl editorImpl = NextEditInstallUtils.INSTANCE.getEditorIfSupported(editor2, project2);
        if (editorImpl == null) {
            return;
        }
        EditorImpl editorImpl2 = editorImpl;
        NextEditDetailedLogsService.Companion.getInstance();
        DocumentEx documentEx = editorImpl2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document2 = documentEx;
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)document2);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        if (IgnoredUtils.INSTANCE.isIgnored(file2, project2)) {
            return;
        }
        Disposable disposable = NextEditInstallUtils.INSTANCE.createDisposableWithEditor((Editor)editorImpl2, file2);
        Disposable disposable2 = (Disposable)editorImpl2.getUserData(KEY);
        if (disposable2 != null) {
            Disposable it = disposable2;
            boolean bl = false;
            DiagnosticsLoggerKt.debug((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), () -> BackendNextEditInstaller.tryInstall$lambda$0$0(file2));
            INSTANCE.uninstall((Editor)editorImpl2);
        }
        editorImpl2.putUserData(KEY, (Object)disposable);
        NextEditFilePath filePath = NextEditFilePathKt.getNextEditFilePath(file2, project2);
        NextEditFilePathForDocumentProvider nextEditFilePathForDocumentProvider = NextEditFilePathForDocumentProvider.Companion.getInstance(project2);
        DocumentEx documentEx2 = editorImpl2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"getDocument(...)");
        nextEditFilePathForDocumentProvider.registerPath((Document)documentEx2, filePath);
        editorImpl2.getDocument().addDocumentListener((DocumentListener)new NextEditFileHistoryDocumentListener(project2, editor2, filePath), disposable);
        NextEditUserRecentChangeStore.Companion.install(editor2);
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> BackendNextEditInstaller.tryInstall$lambda$1(editor2));
    }

    public final void uninstall(@NotNull Editor editor2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!EDT.isCurrentThreadEdt()) {
                DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Next Edit [backend] must be uninstalled on EDT", null, (int)2, null);
                return;
            }
            FrontendNextEditEventsRaker.Companion.getInstance().uninstall(editor2);
            Disposable disposable = (Disposable)editor2.getUserData(KEY);
            if (disposable == null) break block1;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    private static final String tryInstall$lambda$0$0(VirtualFile $file) {
        return "Next Edit [backend] is going to be re-initialized for " + $file.getPath();
    }

    private static final Unit tryInstall$lambda$1(Editor $editor) {
        NextEditUserRecentChangeStore.Companion.uninstall($editor);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"ml.llm.next.edit.backend.disposable");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        BackendNextEditInstaller $this$thisNextEditLogger$iv = INSTANCE;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendNextEditInstaller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
    }
}

