/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.intellij.ml.llm.nextEdits.backend.provider.caches.TrigramSimilarity;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.TrigramSimilarityKt;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditSuggestionSimilarityId;
import com.intellij.openapi.util.registry.Registry;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditTrigramSimilarityMatcher;", "", "targetFilePath", "", "targetTrigrams", "", "", "", "similarityThresholdProvider", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "isSimilar", "", "candidate", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
public final class NextEditTrigramSimilarityMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String targetFilePath;
    @NotNull
    private final Map<Long, Integer> targetTrigrams;
    @NotNull
    private final Function0<Double> similarityThresholdProvider;
    private static final double DEFAULT_SIMILARITY_THRESHOLD = 0.9;
    @NotNull
    private static final Function0<Double> defaultSimilarityThresholdProvider = NextEditTrigramSimilarityMatcher::defaultSimilarityThresholdProvider$lambda$0;

    public NextEditTrigramSimilarityMatcher(@NotNull String targetFilePath, @NotNull Map<Long, Integer> targetTrigrams, @NotNull Function0<Double> similarityThresholdProvider) {
        Intrinsics.checkNotNullParameter((Object)targetFilePath, (String)"targetFilePath");
        Intrinsics.checkNotNullParameter(targetTrigrams, (String)"targetTrigrams");
        Intrinsics.checkNotNullParameter(similarityThresholdProvider, (String)"similarityThresholdProvider");
        this.targetFilePath = targetFilePath;
        this.targetTrigrams = targetTrigrams;
        this.similarityThresholdProvider = similarityThresholdProvider;
    }

    public /* synthetic */ NextEditTrigramSimilarityMatcher(String string, Map map2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = defaultSimilarityThresholdProvider;
        }
        this(string, map2, function0);
    }

    public final boolean isSimilar(@NotNull NextEditSuggestionSimilarityId candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        if (!Intrinsics.areEqual((Object)candidate.getFilePath(), (Object)this.targetFilePath)) {
            return false;
        }
        Map<Long, Integer> candidateTrigrams = TrigramSimilarityKt.extractTrigrams(candidate);
        return TrigramSimilarity.INSTANCE.calculateTrigramSimilarity(candidateTrigrams, this.targetTrigrams) >= ((Number)this.similarityThresholdProvider.invoke()).doubleValue();
    }

    private static final double defaultSimilarityThresholdProvider$lambda$0() {
        return Registry.Companion.doubleValue("ml.llm.nextEdits.backend.rejection.similarity.threshold", 0.9);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditTrigramSimilarityMatcher$Companion;", "", "<init>", "()V", "DEFAULT_SIMILARITY_THRESHOLD", "", "defaultSimilarityThresholdProvider", "Lkotlin/Function0;", "forSuggestion", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditTrigramSimilarityMatcher;", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "similarityThresholdProvider", "intellij.ml.llm.nextEdits.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditTrigramSimilarityMatcher forSuggestion(@NotNull NextEditSuggestionSimilarityId suggestionId, @Nullable Function0<Double> similarityThresholdProvider) {
            Intrinsics.checkNotNullParameter((Object)suggestionId, (String)"suggestionId");
            String string = suggestionId.getFilePath();
            Map<Long, Integer> map2 = TrigramSimilarityKt.extractTrigrams(suggestionId);
            Function0 function0 = similarityThresholdProvider;
            if (function0 == null) {
                function0 = defaultSimilarityThresholdProvider;
            }
            return new NextEditTrigramSimilarityMatcher(string, map2, function0);
        }

        public static /* synthetic */ NextEditTrigramSimilarityMatcher forSuggestion$default(Companion companion, NextEditSuggestionSimilarityId nextEditSuggestionSimilarityId, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                function0 = null;
            }
            return companion.forSuggestion(nextEditSuggestionSimilarityId, (Function0<Double>)function0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

