/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J.\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0010\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/TrigramSimilarity;", "", "<init>", "()V", "calculateSimilarity", "", "text1", "", "text2", "calculateTrigramSimilarity", "trigrams1", "", "", "", "trigrams2", "buildTrigramMap", "text", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
public final class TrigramSimilarity {
    @NotNull
    public static final TrigramSimilarity INSTANCE = new TrigramSimilarity();

    private TrigramSimilarity() {
    }

    public final double calculateSimilarity(@NotNull String text1, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Map<Long, Integer> trigrams1 = this.buildTrigramMap(text1);
        Map<Long, Integer> trigrams2 = this.buildTrigramMap(text2);
        return this.calculateTrigramSimilarity(trigrams1, trigrams2);
    }

    public final double calculateTrigramSimilarity(@NotNull Map<Long, Integer> trigrams1, @NotNull Map<Long, Integer> trigrams2) {
        Intrinsics.checkNotNullParameter(trigrams1, (String)"trigrams1");
        Intrinsics.checkNotNullParameter(trigrams2, (String)"trigrams2");
        if (trigrams1.isEmpty() && trigrams2.isEmpty()) {
            return 1.0;
        }
        if (trigrams1.isEmpty() || trigrams2.isEmpty()) {
            return 0.0;
        }
        int intersectionSize = 0;
        for (Map.Entry<Long, Integer> entry : trigrams1.entrySet()) {
            long trigram = ((Number)entry.getKey()).longValue();
            int count1 = ((Number)entry.getValue()).intValue();
            Integer n = trigrams2.get(trigram);
            int count2 = n != null ? n : 0;
            intersectionSize += Math.min(count1, count2);
        }
        Set allTrigrams = SetsKt.plus(trigrams1.keySet(), (Iterable)trigrams2.keySet());
        int unionSize = 0;
        Iterator iterator = allTrigrams.iterator();
        while (iterator.hasNext()) {
            long trigram = ((Number)iterator.next()).longValue();
            Integer n = trigrams1.get(trigram);
            int count1 = n != null ? n : 0;
            Integer n2 = trigrams2.get(trigram);
            int count2 = n2 != null ? n2 : 0;
            unionSize += Math.max(count1, count2);
        }
        return (double)intersectionSize / (double)unionSize;
    }

    @NotNull
    public final Map<Long, Integer> buildTrigramMap(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        HashMap trigrams = new HashMap();
        if (((CharSequence)text2).length() == 0) {
            return MapsKt.emptyMap();
        }
        if (text2.length() == 1) {
            char c = text2.charAt(0);
            long hash = (long)c << 32 | 1L;
            ((Map)trigrams).put(hash, 1);
        } else if (text2.length() == 2) {
            char c1 = text2.charAt(0);
            char c2 = text2.charAt(1);
            long hash = (long)c1 << 32 | (long)c2 << 16 | 2L;
            ((Map)trigrams).put(hash, 1);
        } else {
            int n = text2.length() - 2;
            for (int i = 0; i < n; ++i) {
                char c1 = text2.charAt(i);
                char c2 = text2.charAt(i + 1);
                char c3 = text2.charAt(i + 2);
                long trigramHash = (long)c1 << 32 | (long)c2 << 16 | (long)c3;
                ((Map)trigrams).put(trigramHash, ((Number)trigrams.getOrDefault(trigramHash, 0)).intValue() + 1);
            }
        }
        return trigrams;
    }
}

