/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.settings;

import com.intellij.ml.llm.nextEdits.backend.settings.BackendNextEditFeatureToggles;
import com.intellij.ml.llm.nextEdits.backend.settings.NextEditSettingsComponent;
import com.intellij.ml.llm.nextEdits.backend.settings.NextEditSettingsController;
import com.intellij.ml.llm.nextEdits.common.NextEditPreviewMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tJ\u0015\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\tJ\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\u000bH\u0007J\b\u0010\"\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/settings/BackendNextEditSettings;", "", "<init>", "()V", "settings", "Lcom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsComponent;", "getSettings", "()Lcom/intellij/ml/llm/nextEdits/backend/settings/NextEditSettingsComponent;", "isEnabled", "", "setEnabled", "", "enabled", "isLimitFileTypes", "setLimitFileTypes", "limitFileTypes", "isCodeInsightActionsEnabled", "setCodeInsightActionsEnabled", "allowCodeInsightActions", "isLanguageEnabledOrNull", "language", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "setLanguageEnabled", "isChainSuggestionsEnabled", "setChainSuggestionsEnabled", "isWhitespaceOnlyChangesEnabled", "setWhitespaceOnlyChangesEnabled", "getPreviewMode", "Lcom/intellij/ml/llm/nextEdits/common/NextEditPreviewMode;", "setPreviewMode", "previewMode", "asDebugString", "reset", "triggerSettingsChanged", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
public final class BackendNextEditSettings {
    @NotNull
    public static final BackendNextEditSettings INSTANCE = new BackendNextEditSettings();

    private BackendNextEditSettings() {
    }

    private final NextEditSettingsComponent getSettings() {
        return NextEditSettingsComponent.Companion.getInstance();
    }

    public final boolean isEnabled() {
        return this.getSettings().getState().getEnabled();
    }

    public final void setEnabled(boolean enabled) {
        this.getSettings().getState().setEnabled(enabled);
        this.triggerSettingsChanged();
    }

    public final boolean isLimitFileTypes() {
        return this.getSettings().getState().getLimitFileTypes();
    }

    public final void setLimitFileTypes(boolean limitFileTypes) {
        this.getSettings().getState().setLimitFileTypes(limitFileTypes);
        this.triggerSettingsChanged();
    }

    public final boolean isCodeInsightActionsEnabled() {
        return this.getSettings().getState().getAllowCodeInsightActions() && !BackendNextEditFeatureToggles.INSTANCE.getForcedDisabledCodeInsightActions();
    }

    public final void setCodeInsightActionsEnabled(boolean allowCodeInsightActions) {
        this.getSettings().getState().setAllowCodeInsightActions(allowCodeInsightActions);
        this.triggerSettingsChanged();
    }

    @Nullable
    public final Boolean isLanguageEnabledOrNull(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return this.getSettings().getState().getLanguageToEnabled().get(language);
    }

    public final void setLanguageEnabled(@NotNull String language, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.getSettings().getState().getLanguageToEnabled().put(language, enabled);
        this.triggerSettingsChanged();
    }

    public final boolean isChainSuggestionsEnabled() {
        return this.getSettings().getState().getChainNextEditSuggestions();
    }

    public final void setChainSuggestionsEnabled(boolean enabled) {
        this.getSettings().getState().setChainNextEditSuggestions(enabled);
        this.triggerSettingsChanged();
    }

    public final boolean isWhitespaceOnlyChangesEnabled() {
        return this.getSettings().getState().getEnableWhitespaceOnlyChanges();
    }

    public final void setWhitespaceOnlyChangesEnabled(boolean enabled) {
        this.getSettings().getState().setEnableWhitespaceOnlyChanges(enabled);
        this.triggerSettingsChanged();
    }

    @NotNull
    public final NextEditPreviewMode getPreviewMode() {
        return this.getSettings().getState().getPreviewMode();
    }

    public final void setPreviewMode(@NotNull NextEditPreviewMode previewMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)previewMode), (String)"previewMode");
        this.getSettings().getState().setPreviewMode(previewMode);
        this.triggerSettingsChanged();
    }

    @NotNull
    public final String asDebugString() {
        return this.getSettings().getState().toString();
    }

    @TestOnly
    public final void reset() {
        this.getSettings().reset();
    }

    private final void triggerSettingsChanged() {
        NextEditSettingsController.Companion.getInstance().settingsChanged();
    }
}

