/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.listeners;

import com.intellij.codeInsight.inline.completion.render.InlineCompletionLineRenderer;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditInlayRendererMarker;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshReason;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\n\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0014\u0010\u000b\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u001c\u0010\f\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/listeners/NextEditRefreshOnBlockInlayChangesListener;", "Lcom/intellij/openapi/editor/InlayModel$Listener;", "<init>", "()V", "doRefreshIfNeeded", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "onAdded", "onRemoved", "onUpdated", "changeFlags", "", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditRefreshOnBlockInlayChangesListener
implements InlayModel.Listener {
    private final void doRefreshIfNeeded(Editor editor2, Inlay<?> inlay) {
        block2: {
            if (inlay.getPlacement() != Inlay.Placement.ABOVE_LINE && inlay.getPlacement() != Inlay.Placement.BELOW_LINE) {
                return;
            }
            if (inlay.getRenderer() instanceof InlineCompletionLineRenderer || inlay.getRenderer() instanceof NextEditInlayRendererMarker) {
                return;
            }
            Object object = NextEditSessionManager.Companion.getInstance(editor2);
            if (object == null || (object = ((NextEditSessionManager)object).getSession()) == null) break block2;
            ((NextEditSession)object).refreshIfNeeded(NextEditViewRefreshReason.BlockInlaysChanged.INSTANCE);
        }
    }

    public void onAdded(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        this.doRefreshIfNeeded(editor2, inlay);
    }

    public void onRemoved(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        this.doRefreshIfNeeded(editor2, inlay);
    }

    public void onUpdated(@NotNull Inlay<?> inlay, int changeFlags) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        if ((changeFlags & 2) != 0) {
            Editor editor2 = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            this.doRefreshIfNeeded(editor2, inlay);
        }
    }
}

