/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.services;

import com.intellij.codeInsight.inline.edit.InlineEditRequestExecutor;
import com.intellij.lang.Language;
import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.common.PsiFileUtils;
import com.intellij.ml.llm.nextEdits.common.logs.NextEditEventRpc;
import com.intellij.ml.llm.nextEdits.common.provider.BackendNextEditSuggestionProviderRemoteApi;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditRequestId;
import com.intellij.ml.llm.nextEdits.common.settings.BackendNextEditSettingsRemoteApi;
import com.intellij.ml.llm.nextEdits.common.settings.NextEditBehaviourSettings;
import com.intellij.ml.llm.nextEdits.frontend.UtilsKt;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLoggerKt;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditMagicWand;
import com.intellij.ml.llm.nextEdits.frontend.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.frontend.logs.FrontendNextEditEventsReporter;
import com.intellij.ml.llm.nextEdits.frontend.request.NextEditRequest;
import com.intellij.ml.llm.nextEdits.frontend.request.NextEditRequestKt;
import com.intellij.ml.llm.nextEdits.frontend.services.NextEditRequestService;
import com.intellij.ml.llm.nextEdits.frontend.services.TestActionRethrower;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionProgress;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditViewModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import fleet.rpc.core.RpcFlow;
import fleet.rpc.core.RpcFlowKt;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 52\u00020\u0001:\u00015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\rH\u0007J\u001d\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0001\u00a2\u0006\u0002\b\u0018J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000fH\u0002J\u000e\u0010\u001b\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\rH\u0016J-\u0010\u001e\u001a\u00020\r2\u001e\u0010\u001f\u001a\u001a\b\u0001\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\"0!\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0003\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\"H\u0082@\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\u00020\r2\u0006\u0010&\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0083@\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\r2\u0006\u0010&\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0082@\u00a2\u0006\u0002\u0010/J.\u00100\u001a\u00020\r2\u0006\u0010&\u001a\u00020\"2\u0006\u0010)\u001a\u00020*2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020.H\u0082@\u00a2\u0006\u0002\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "requestExecutor", "Lcom/intellij/codeInsight/inline/edit/InlineEditRequestExecutor;", "errorRethrower", "Lcom/intellij/ml/llm/nextEdits/frontend/services/TestActionRethrower;", "newRequest", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "triggerReason", "Lcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;", "cancelRequests", "handleCaretEvent", "caretEvent", "Lcom/intellij/openapi/editor/event/CaretEvent;", "type", "Lcom/intellij/ml/llm/nextEdits/frontend/listeners/CaretEventType;", "handleCaretEvent$intellij_ml_llm_nextEdits_frontend", "wasEditedRecently", "", "awaitRequests", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "dispatchRequest", "requestFactory", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;", "", "(Lkotlin/jvm/functions/Function1;)V", "handleRequest", "request", "(Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleRequestUnsafe", "behaviourSettings", "Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;", "(Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "syncLogsWithBackend", "frontendReporter", "Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;", "(Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryStartSession", "progress", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionProgress;", "reporter", "(Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionProgress;Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nNextEditRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n+ 4 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 5 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,352:1\n75#2:353\n75#2:358\n105#3:354\n106#3,2:360\n125#3:363\n95#4:355\n135#4,2:356\n137#4:359\n374#5:362\n*S KotlinDebug\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService\n*L\n241#1:353\n293#1:358\n291#1:354\n291#1:360,2\n314#1:363\n291#1:355\n291#1:356,2\n291#1:359\n305#1:362\n*E\n"})
public final class NextEditRequestService
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final InlineEditRequestExecutor requestExecutor;
    @NotNull
    private final TestActionRethrower errorRethrower;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger logger;

    public NextEditRequestService(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.requestExecutor = InlineEditRequestExecutor.Companion.create(scope);
        this.errorRethrower = new TestActionRethrower();
    }

    @RequiresEdt
    public final void newRequest(@NotNull Editor editor2, @NotNull NextEditTriggerReason triggerReason) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)triggerReason), (String)"triggerReason");
        ThreadingAssertions.assertEventDispatchThread();
        Project project2 = editor2.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (!UtilsKt.isNextEditSupported(editor2)) {
            return;
        }
        if (editor2.isDisposed()) {
            logger.debug((Function0<String>)((Function0)NextEditRequestService::newRequest$lambda$0));
            return;
        }
        if (editor2.getVirtualFile() == null) {
            logger.debug((Function0<String>)((Function0)NextEditRequestService::newRequest$lambda$1));
            return;
        }
        if (editor2.getCaretModel().getCaretCount() != 1) {
            logger.debug((Function0<String>)((Function0)NextEditRequestService::newRequest$lambda$2));
            return;
        }
        if (EditorIdKt.editorIdOrNull((Editor)editor2) == null) {
            logger.debug((Function0<String>)((Function0)NextEditRequestService::newRequest$lambda$3));
            return;
        }
        Object object = NextEditSessionManager.Companion.getInstance(editor2);
        boolean bl = object != null && (object = ((NextEditSessionManager)object).getSession()) != null ? !((NextEditSession)object).canBeDestroyed() : false;
        if (bl) {
            logger.debug((Function0<String>)((Function0)NextEditRequestService::newRequest$lambda$4));
            return;
        }
        NextEditRequest.LightweightEditorSnapshot editorSnapshot = (NextEditRequest.LightweightEditorSnapshot)ActionsKt.runReadAction(() -> NextEditRequestService.newRequest$lambda$5(editor2));
        DataContext dataContext2 = EditorUtil.getEditorDataContext((Editor)editor2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getEditorDataContext(...)");
        DataContext editorDataContext = dataContext2;
        int caretOffset = editor2.getCaretModel().getOffset();
        long timestamp = System.currentTimeMillis();
        this.dispatchRequest((Function1<? super Continuation<? super NextEditRequest>, ? extends Object>)((Function1)new Function1<Continuation<? super NextEditRequest>, Object>(editor2, project3, editorDataContext, caretOffset, editorSnapshot, timestamp, triggerReason, null){
            int label;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ DataContext $editorDataContext;
            final /* synthetic */ int $caretOffset;
            final /* synthetic */ NextEditRequest.LightweightEditorSnapshot $editorSnapshot;
            final /* synthetic */ long $timestamp;
            final /* synthetic */ NextEditTriggerReason $triggerReason;
            {
                this.$editor = $editor;
                this.$project = $project;
                this.$editorDataContext = $editorDataContext;
                this.$caretOffset = $caretOffset;
                this.$editorSnapshot = $editorSnapshot;
                this.$timestamp = $timestamp;
                this.$triggerReason = $triggerReason;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.readAction(() -> newRequest.6.invokeSuspend$lambda$0(this.$editor, this.$project, this.$editorDataContext, this.$caretOffset, this.$editorSnapshot, this.$timestamp, this.$triggerReason), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super NextEditRequest> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final NextEditRequest invokeSuspend$lambda$0(Editor $editor, Project $project, DataContext $editorDataContext, int $caretOffset, NextEditRequest.LightweightEditorSnapshot $editorSnapshot, long $timestamp, NextEditTriggerReason $triggerReason) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = PsiFileUtils.INSTANCE.getPsiFile($editor, $project, $editorDataContext);
                if (psiFile == null) {
                    return null;
                }
                PsiFile psiFile2 = psiFile;
                PsiUtilCore.ensureValid((PsiElement)((PsiElement)psiFile2));
                Language language = PsiFileUtils.INSTANCE.getLanguage(psiFile2, $caretOffset);
                return new NextEditRequest($project, $editor, psiFile2, language, $caretOffset, $editorSnapshot, $timestamp, $triggerReason, NextEditRequestId.Companion.create());
            }
        }));
    }

    @RequiresEdt
    public final void cancelRequests() {
        ThreadingAssertions.assertEventDispatchThread();
        this.requestExecutor.cancelActiveRequest();
        logger.trace((Function0<String>)((Function0)NextEditRequestService::cancelRequests$lambda$0));
    }

    @RequiresEdt
    public final void handleCaretEvent$intellij_ml_llm_nextEdits_frontend(@NotNull CaretEvent caretEvent, @NotNull CaretEventType type2) {
        Intrinsics.checkNotNullParameter((Object)caretEvent, (String)"caretEvent");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: 
            case 2: {
                this.cancelRequests();
                break;
            }
            case 3: {
                boolean areDocumentChangesGuarded;
                if (caretEvent.getOldPosition().line != caretEvent.getNewPosition().line) {
                    this.cancelRequests();
                }
                Editor editor2 = caretEvent.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                NextEditSessionManager nextEditSessionManager = NextEditSessionManager.Companion.getInstance(editor3);
                NextEditSession session = nextEditSessionManager != null ? nextEditSessionManager.getSession() : null;
                boolean bl = areDocumentChangesGuarded = session != null && session.areDocumentChangesGuarded();
                if (areDocumentChangesGuarded || !this.wasEditedRecently(editor3)) break;
                this.newRequest(editor3, NextEditTriggerReason.CARET_MOVE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final boolean wasEditedRecently(Editor $this$wasEditedRecently) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        if (fileDocumentManager2.isDocumentUnsaved($this$wasEditedRecently.getDocument())) {
            return true;
        }
        VirtualFile virtualFile2 = fileDocumentManager2.getFile($this$wasEditedRecently.getDocument());
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        long lastModified = virtualFile3.getTimeStamp();
        return System.currentTimeMillis() - lastModified <= Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitRequests(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitRequests.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitRequests((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.requestExecutor.awaitActiveRequest((Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                this.errorRethrower.throwErrorIfTest();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.requestExecutor));
    }

    @RequiresEdt
    private final void dispatchRequest(Function1<? super Continuation<? super NextEditRequest>, ? extends Object> requestFactory) {
        ThreadingAssertions.assertEventDispatchThread();
        this.requestExecutor.switchRequest((Function1)dispatchRequest.1.INSTANCE, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, requestFactory, null){
            Object L$0;
            Object L$1;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ NextEditRequestService this$0;
            final /* synthetic */ Function1<Continuation<? super NextEditRequest>, Object> $requestFactory;
            {
                this.this$0 = $receiver;
                this.$requestFactory = $requestFactory;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = NextEditRequestService.access$getErrorRethrower$p(this.this$0);
                        var3_4 = this.$requestFactory;
                        var4_5 = this.this$0;
                        $i$f$collectError = 0;
                        $i$a$-collectError-NextEditRequestService$dispatchRequest$2$1 = 0;
                        this.L$0 = this_$iv;
                        this.L$1 = var4_5;
                        this.I$0 = $i$f$collectError;
                        this.I$1 = $i$a$-collectError-NextEditRequestService$dispatchRequest$2$1;
                        this.label = 1;
                        v0 = var3_4.invoke((Object)this);
                        ** if (v0 != var9_2) goto lbl20
lbl19:
                        // 1 sources

                        return var9_2;
lbl20:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$a$-collectError-NextEditRequestService$dispatchRequest$2$1 = this.I$1;
                        $i$f$collectError = this.I$0;
                        var4_5 = (NextEditRequestService)this.L$1;
                        this_$iv = (TestActionRethrower)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        if ((request = (NextEditRequest)v0) == null) ** GOTO lbl55
                        this.L$0 = this_$iv;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)request);
                        this.I$0 = $i$f$collectError;
                        this.I$1 = $i$a$-collectError-NextEditRequestService$dispatchRequest$2$1;
                        this.label = 2;
                        v1 = NextEditRequestService.access$handleRequest(var4_5, request, (Continuation)this);
                        ** if (v1 != var9_2) goto lbl39
lbl38:
                        // 1 sources

                        return var9_2;
lbl39:
                        // 1 sources

                        ** GOTO lbl55
                    }
                    case 2: {
                        $i$a$-collectError-NextEditRequestService$dispatchRequest$2$1 = this.I$1;
                        $i$f$collectError = this.I$0;
                        request = (NextEditRequest)this.L$1;
                        this_$iv = (TestActionRethrower)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Throwable e$iv) {
                            LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                            TestActionRethrower.access$getFirstError$p(this_$iv).compareAndSet(null, e$iv);
                            throw e$iv;
                        }
lbl55:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRequest(NextEditRequest request, Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleRequest.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NextEditRequestService.access$handleRequest(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = request;
                $continuation.label = 1;
                v0 = BackendNextEditSettingsRemoteApi.Companion.getInstance((Continuation<? super BackendNextEditSettingsRemoteApi>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                v1 = (BackendNextEditSettingsRemoteApi)v0;
                v2 = request.getLanguage().getID();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getID(...)");
                $continuation.L$0 = request;
                $continuation.label = 2;
                v3 = v1.getBehaviourSettings(v2, (Continuation<? super NextEditBehaviourSettings>)$continuation);
                ** if (v3 != var6_5) goto lbl34
lbl33:
                // 1 sources

                return var6_5;
lbl34:
                // 1 sources

                ** GOTO lbl41
            }
            case 2: {
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl41:
                // 2 sources

                if ((behaviourSettings = (NextEditBehaviourSettings)v3) == null) {
                    NextEditRequestService.logger.debug((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleRequest$lambda$0(com.intellij.ml.llm.nextEdits.frontend.request.NextEditRequest ), ()Ljava/lang/String;)((NextEditRequest)request));
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = request;
                $continuation.L$1 = behaviourSettings;
                $continuation.label = 3;
                v4 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                ** if (v4 != var6_5) goto lbl50
lbl49:
                // 1 sources

                return var6_5;
lbl50:
                // 1 sources

                ** GOTO lbl58
            }
            case 3: {
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl58:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)behaviourSettings);
                $continuation.label = 4;
                v5 = NextEditMagicWand.Companion.getInstance().displayDuring(request.getEditor(), behaviourSettings.isIndicatorEnabled(), (Function1)new Function1<Continuation<? super Unit>, Object>(this, request, behaviourSettings, null){
                    int label;
                    final /* synthetic */ NextEditRequestService this$0;
                    final /* synthetic */ NextEditRequest $request;
                    final /* synthetic */ NextEditBehaviourSettings $behaviourSettings;
                    {
                        this.this$0 = $receiver;
                        this.$request = $request;
                        this.$behaviourSettings = $behaviourSettings;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = NextEditRequestService.access$handleRequestUnsafe(this.this$0, this.$request, this.$behaviourSettings, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v5 != var6_5) goto lbl64
lbl63:
                // 1 sources

                return var6_5;
lbl64:
                // 1 sources

                ** GOTO lbl76
            }
            case 4: {
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
                }
                catch (Throwable e) {
                    if (NextEditRequestService.logger.errorIfNotMessage(e)) ** GOTO lbl76
                    throw e;
                }
lbl76:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @RequiresBackgroundThread
    private final Object handleRequestUnsafe(NextEditRequest request, NextEditBehaviourSettings behaviourSettings, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CASE], 8[SWITCH]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object syncLogsWithBackend(NextEditRequest request, FrontendNextEditEventsReporter frontendReporter, Continuation<? super Unit> $completion) {
        if (!($completion instanceof syncLogsWithBackend.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NextEditRequestService.access$syncLogsWithBackend(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = EditorIdKt.editorIdOrNull((Editor)request.getEditor());
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                editorId = v0;
                $continuation.L$0 = request;
                $continuation.L$1 = frontendReporter;
                $continuation.L$2 = editorId;
                $continuation.label = 1;
                v1 = BackendNextEditSuggestionProviderRemoteApi.Companion.getInstance((Continuation<? super BackendNextEditSuggestionProviderRemoteApi>)$continuation);
                if (v1 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                editorId = (EditorId)$continuation.L$2;
                frontendReporter = (FrontendNextEditEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                v2 = (BackendNextEditSuggestionProviderRemoteApi)v1;
                v3 = request.getId();
                v4 = request.getLanguage().getID();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getID(...)");
                var8_9 = v4;
                var7_10 = v3;
                var6_11 = editorId;
                var5_12 = v2;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)frontendReporter);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)editorId);
                $continuation.L$3 = var5_12;
                $continuation.L$4 = var6_11;
                $continuation.L$5 = var7_10;
                $continuation.L$6 = var8_9;
                $continuation.label = 2;
                v5 = RpcFlowKt.toRpc(frontendReporter.receiveEvents(), (Continuation)$continuation);
                if (v5 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl60
            }
            case 2: {
                var8_9 = (String)$continuation.L$6;
                var7_10 = (NextEditRequestId)$continuation.L$5;
                var6_11 = (EditorId)$continuation.L$4;
                var5_12 = (BackendNextEditSuggestionProviderRemoteApi)$continuation.L$3;
                editorId = (EditorId)$continuation.L$2;
                frontendReporter = (FrontendNextEditEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl60:
                // 2 sources

                var9_13 = v5;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)frontendReporter);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)editorId);
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.label = 3;
                v6 = var5_12.syncLogs(var6_11, var7_10, var8_9, (RpcFlow<NextEditEventRpc>)((RpcFlow)var9_13), (Continuation<? super Unit>)$continuation);
                if (v6 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl79
            }
            case 3: {
                editorId = (EditorId)$continuation.L$2;
                frontendReporter = (FrontendNextEditEventsReporter)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl79:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object tryStartSession(NextEditRequest request, NextEditBehaviourSettings behaviourSettings, NextEditSessionProgress progress, FrontendNextEditEventsReporter reporter, Continuation<? super Unit> $completion) {
        if (!($completion instanceof tryStartSession.1)) ** GOTO lbl-1000
        var26_6 = $completion;
        if ((var26_6.label & -2147483648) != 0) {
            var26_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int I$5;
                int I$6;
                long J$0;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ NextEditRequestService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NextEditRequestService.access$tryStartSession(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                sessionCreated = 0;
                $continuation.L$0 = request;
                $continuation.L$1 = behaviourSettings;
                $continuation.L$2 = progress;
                $continuation.L$3 = reporter;
                $continuation.I$0 = sessionCreated;
                $continuation.label = 1;
                v0 = NextEditRequestKt.checkValidity(request, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var27_8) goto lbl24
lbl23:
                // 1 sources

                return var27_8;
lbl24:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                sessionCreated = $continuation.I$0;
                reporter = (FrontendNextEditEventsReporter)$continuation.L$3;
                progress = (NextEditSessionProgress)$continuation.L$2;
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                isValidSuggestion = (Function1)new Function1<Continuation<? super Boolean>, Object>(request, null){
                    int label;
                    final /* synthetic */ NextEditRequest $request;
                    {
                        this.$request = $request;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = CoroutinesKt.readAction(() -> tryStartSession.isValidSuggestion.1.invokeSuspend$lambda$0(this.$request), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Boolean> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(NextEditRequest $request) {
                        return $request.isValid();
                    }
                };
                var8_16 = NextEditRequestService.logger;
                actionName$iv = "Initialize UI session";
                $i$f$logActionTime = 0;
                $i$f$measureTimedValue = 0;
                $this$measureTimedValue$iv$iv$iv = TimeSource.Monotonic.INSTANCE;
                $i$f$measureTimedValue = 0;
                mark$iv$iv$iv = $this$measureTimedValue$iv$iv$iv.markNow-z9LOYto();
                $i$a$-measureTimedValue-FrontendNextEditDiagnosticsLoggerKt$logActionTime$1$iv = 0;
                $i$a$-logActionTime-NextEditRequestService$tryStartSession$2 = 0;
                var18_32 = (ComponentManager)this.project;
                var19_33 = $continuation;
                $i$f$serviceAsync = 0;
                Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = request;
                $continuation.L$1 = behaviourSettings;
                $continuation.L$2 = progress;
                $continuation.L$3 = reporter;
                $continuation.L$4 = isValidSuggestion;
                $continuation.L$5 = $this$logActionTime$iv;
                $continuation.L$6 = actionName$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$measureTimedValue$iv$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                $continuation.I$0 = sessionCreated;
                $continuation.I$1 = $i$f$logActionTime;
                $continuation.I$2 = $i$f$measureTimedValue;
                $continuation.I$3 = $i$f$measureTimedValue;
                $continuation.J$0 = mark$iv$iv$iv;
                $continuation.I$4 = $i$a$-measureTimedValue-FrontendNextEditDiagnosticsLoggerKt$logActionTime$1$iv;
                $continuation.I$5 = $i$a$-logActionTime-NextEditRequestService$tryStartSession$2;
                $continuation.I$6 = $i$f$serviceAsync;
                $continuation.label = 2;
                v1 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(NextEditViewModel.class, (Continuation)$completion$iv);
                ** if (v1 != var27_8) goto lbl72
lbl71:
                // 1 sources

                return var27_8;
lbl72:
                // 1 sources

                ** GOTO lbl97
            }
            case 2: {
                $i$f$serviceAsync = $continuation.I$6;
                $i$a$-logActionTime-NextEditRequestService$tryStartSession$2 = $continuation.I$5;
                $i$a$-measureTimedValue-FrontendNextEditDiagnosticsLoggerKt$logActionTime$1$iv = $continuation.I$4;
                mark$iv$iv$iv = $continuation.J$0;
                $i$f$measureTimedValue = $continuation.I$3;
                $i$f$measureTimedValue = $continuation.I$2;
                $i$f$logActionTime = $continuation.I$1;
                sessionCreated = $continuation.I$0;
                $completion$iv = $continuation.L$9;
                $this$serviceAsync$iv = (ComponentManager)$continuation.L$8;
                $this$measureTimedValue$iv$iv$iv = (TimeSource.Monotonic)$continuation.L$7;
                actionName$iv = (String)$continuation.L$6;
                $this$logActionTime$iv = (FrontendNextEditDiagnosticsLogger)$continuation.L$5;
                isValidSuggestion = (Function1)$continuation.L$4;
                reporter = (FrontendNextEditEventsReporter)$continuation.L$3;
                progress = (NextEditSessionProgress)$continuation.L$2;
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl97:
                // 2 sources

                var21_37 = (NextEditViewModel)v1;
                var18_32 = request.getEditor();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)behaviourSettings);
                $continuation.L$2 = progress;
                $continuation.L$3 = reporter;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)isValidSuggestion);
                $continuation.L$5 = $this$logActionTime$iv;
                $continuation.L$6 = actionName$iv;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$measureTimedValue$iv$iv$iv);
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.I$0 = sessionCreated;
                $continuation.I$1 = $i$f$logActionTime;
                $continuation.I$2 = $i$f$measureTimedValue;
                $continuation.I$3 = $i$f$measureTimedValue;
                $continuation.J$0 = mark$iv$iv$iv;
                $continuation.I$4 = $i$a$-measureTimedValue-FrontendNextEditDiagnosticsLoggerKt$logActionTime$1$iv;
                $continuation.I$5 = $i$a$-logActionTime-NextEditRequestService$tryStartSession$2;
                $continuation.label = 3;
                v2 = var21_37.tryStartNewNextEditSession((Editor)var18_32, progress, reporter, behaviourSettings, (Function1<? super Continuation<? super Boolean>, ? extends Object>)isValidSuggestion, (Continuation<? super Boolean>)$continuation);
                ** if (v2 != var27_8) goto lbl120
lbl119:
                // 1 sources

                return var27_8;
lbl120:
                // 1 sources

                ** GOTO lbl143
            }
            case 3: {
                $i$a$-logActionTime-NextEditRequestService$tryStartSession$2 = $continuation.I$5;
                $i$a$-measureTimedValue-FrontendNextEditDiagnosticsLoggerKt$logActionTime$1$iv = $continuation.I$4;
                mark$iv$iv$iv = $continuation.J$0;
                $i$f$measureTimedValue = $continuation.I$3;
                $i$f$measureTimedValue = $continuation.I$2;
                $i$f$logActionTime = $continuation.I$1;
                sessionCreated = $continuation.I$0;
                $this$measureTimedValue$iv$iv$iv = (TimeSource.Monotonic)$continuation.L$7;
                actionName$iv = (String)$continuation.L$6;
                $this$logActionTime$iv = (FrontendNextEditDiagnosticsLogger)$continuation.L$5;
                isValidSuggestion = (Function1)$continuation.L$4;
                reporter = (FrontendNextEditEventsReporter)$continuation.L$3;
                progress = (NextEditSessionProgress)$continuation.L$2;
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl143:
                // 2 sources

                result$iv$iv$iv = Boxing.boxBoolean((boolean)((Boolean)v2));
                var22_38 = new TimedValue((Object)result$iv$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv$iv), null);
                value$iv = var22_38.component1();
                time$iv = var22_38.component2-UwyO8pc();
                FrontendNextEditDiagnosticsLoggerKt.logActionTime($this$logActionTime$iv, actionName$iv, Duration.getInWholeMilliseconds-impl((long)time$iv));
                sessionCreated = (int)((Boolean)value$iv).booleanValue();
                if (sessionCreated != 0) break;
                $i$f$currentCoroutineContext = false;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)behaviourSettings);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)reporter);
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.Z$0 = sessionCreated;
                $continuation.label = 4;
                v3 = BuildersKt.withContext((CoroutineContext)$continuation.getContext().plus((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(reporter, progress, null){
                    int label;
                    final /* synthetic */ FrontendNextEditEventsReporter $reporter;
                    final /* synthetic */ NextEditSessionProgress $progress;
                    {
                        this.$reporter = $reporter;
                        this.$progress = $progress;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.$reporter.dispose();
                                Disposer.dispose((Disposable)this.$progress);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var27_8) {
                    return var27_8;
                }
                break;
            }
            case 4: {
                sessionCreated = $continuation.Z$0;
                reporter = (FrontendNextEditEventsReporter)$continuation.L$3;
                progress = (NextEditSessionProgress)$continuation.L$2;
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
                break;
            }
        }
        catch (Throwable var7_14) {
            if (sessionCreated == 0) {
                $i$f$currentCoroutineContext = false;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)behaviourSettings);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)progress);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)reporter);
                $continuation.L$4 = var7_14;
                $continuation.L$5 = null;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.I$0 = sessionCreated;
                $continuation.label = 5;
                v4 = BuildersKt.withContext((CoroutineContext)$continuation.getContext().plus((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)$continuation);
                if (v4 == var27_8) {
                    return var27_8;
                }
            }
            ** GOTO lbl205
        }
        {
            case 5: {
                sessionCreated = $continuation.I$0;
                var7_15 = (Throwable)$continuation.L$4;
                reporter = (FrontendNextEditEventsReporter)$continuation.L$3;
                progress = (NextEditSessionProgress)$continuation.L$2;
                behaviourSettings = (NextEditBehaviourSettings)$continuation.L$1;
                request = (NextEditRequest)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl205:
                // 2 sources

                throw var7_15;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String newRequest$lambda$0() {
        return "Editor is disposed. Not supported.";
    }

    private static final String newRequest$lambda$1() {
        return "Editor is not file-based. Not supported.";
    }

    private static final String newRequest$lambda$2() {
        return "Editor has more than one caret. Not supported.";
    }

    private static final String newRequest$lambda$3() {
        return "Editor has no editor ID. Not supported.";
    }

    private static final String newRequest$lambda$4() {
        return "There is an ongoing non-destroyable session. Shouldn't execute a new request.";
    }

    private static final NextEditRequest.LightweightEditorSnapshot newRequest$lambda$5(Editor $editor) {
        long l = $editor.getDocument().getModificationStamp();
        LogicalPosition logicalPosition = $editor.getCaretModel().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        return new NextEditRequest.LightweightEditorSnapshot(l, logicalPosition);
    }

    private static final String cancelRequests$lambda$0() {
        return "Requests are cancelled.";
    }

    private static final String handleRequest$lambda$0(NextEditRequest $request) {
        return "No behaviour settings found for language '" + $request.getLanguage().getID() + "'. Not supported.";
    }

    public static final /* synthetic */ TestActionRethrower access$getErrorRethrower$p(NextEditRequestService $this) {
        return $this.errorRethrower;
    }

    public static final /* synthetic */ Object access$handleRequest(NextEditRequestService $this, NextEditRequest request2, Continuation $completion) {
        return $this.handleRequest(request2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleRequestUnsafe(NextEditRequestService $this, NextEditRequest request2, NextEditBehaviourSettings behaviourSettings, Continuation $completion) {
        return $this.handleRequestUnsafe(request2, behaviourSettings, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$syncLogsWithBackend(NextEditRequestService $this, NextEditRequest request2, FrontendNextEditEventsReporter frontendReporter, Continuation $completion) {
        return $this.syncLogsWithBackend(request2, frontendReporter, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$tryStartSession(NextEditRequestService $this, NextEditRequest request2, NextEditBehaviourSettings behaviourSettings, NextEditSessionProgress progress, FrontendNextEditEventsReporter reporter, Continuation $completion) {
        return $this.tryStartSession(request2, behaviourSettings, progress, reporter, (Continuation<? super Unit>)$completion);
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        logger = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "getInstance", "Lcom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.nextEdits.frontend"})
    @SourceDebugExtension(value={"SMAP\nNextEditRequestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,352:1\n30#2,2:353\n*S KotlinDebug\n*F\n+ 1 NextEditRequestService.kt\ncom/intellij/ml/llm/nextEdits/frontend/services/NextEditRequestService$Companion\n*L\n316#1:353,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditRequestService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditRequestService> serviceClass$iv = NextEditRequestService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditRequestService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CaretEventType.values().length];
            try {
                nArray[CaretEventType.CARET_ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.MOVEMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

