/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.session;

import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.common.provider.ActionHintPresentation;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditDisplayIntrusionMode;
import com.intellij.ml.llm.nextEdits.common.provider.SuggestionKind;
import com.intellij.ml.llm.nextEdits.common.settings.NextEditBehaviourSettings;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.frontend.logs.ExtKt;
import com.intellij.ml.llm.nextEdits.frontend.logs.FrontendNextEditEventsReporter;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditIntrusionModeController;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionListener;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionProgress;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.DocumentChangeGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.Guarder;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.NextEditSessionSuppressionGuarder;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.NextEditSessionSuppressionGuarderKt;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditSessionStep;
import com.intellij.ml.llm.nextEdits.frontend.session.step.UndoableCaretMoveAction;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditDisplayManager;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditDisplayParameters;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditDisplayState;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshManager;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshReason;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0001YBR\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0007J\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00104\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00105\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u000208H\u0007J\b\u00109\u001a\u000202H\u0007J\u0006\u0010:\u001a\u000202J\b\u0010;\u001a\u00020\u0012H\u0007J\u000e\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00122\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u00020CH\u0007J\b\u0010D\u001a\u00020\u0012H\u0002J\u000e\u0010E\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010F\u001a\u00020\u0012H\u0002J\b\u0010G\u001a\u00020\u0012H\u0002J\u0010\u0010H\u001a\u00020\u00122\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u00020\u00122\u0006\u0010L\u001a\u000202H\u0002J\u0018\u0010M\u001a\u00020\u00122\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020JH\u0003J\b\u0010Q\u001a\u00020\u0012H\u0003J\u0010\u0010R\u001a\u00020\u00122\u0006\u0010S\u001a\u00020CH\u0002J\b\u0010T\u001a\u00020\u0012H\u0016J\b\u0010U\u001a\u00020VH\u0002J\b\u0010W\u001a\u00020XH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u0004\u0018\u00010'8G\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006Z"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "progress", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionProgress;", "reporter", "Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;", "behaviourSettings", "Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;", "autoDestroy", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/nextEdits/common/NextEditSessionFinishType;", "Lkotlin/ParameterName;", "name", "finishType", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionProgress;Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;Lkotlin/jvm/functions/Function1;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getBehaviourSettings", "()Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;", "suppressionGuarder", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/NextEditSessionSuppressionGuarder;", "ignoreDocumentChangesGuarder", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/DocumentChangeGuardPurpose;", "intrusionModeController", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditIntrusionModeController;", "displayManager", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager;", "refreshManager", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager;", "actionHintPresentation", "Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "getActionHintPresentation", "()Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "currentSuggestionKind", "Lcom/intellij/ml/llm/nextEdits/common/provider/SuggestionKind;", "getCurrentSuggestionKind", "()Lcom/intellij/ml/llm/nextEdits/common/provider/SuggestionKind;", "suppressIfNeeded", "purpose", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/SuppressSessionGuardPurpose;", "areDocumentChangesGuarded", "", "doMarkSuppressedByPurposeAndLog", "unsuppress", "doMarkUnsuppressedByPurposeAndLog", "refreshIfNeeded", "reason", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshReason;", "isActive", "canBeDestroyed", "handleTab", "onDocumentEvent", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onCaretEvent", "type", "Lcom/intellij/ml/llm/nextEdits/frontend/listeners/CaretEventType;", "getDisplayState", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayState;", "startSession", "reportSessionFinished", "handleStepRepresentationUpdated", "doRefreshView", "doHandleJump", "stepController", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController;", "displayCurrentStepOrJump", "notifyIntrusionController", "acceptStep", "step", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditSessionStep;", "controller", "makeCurrentStepViewVisibleIfRendering", "onDisplayStateChanged", "newState", "dispose", "getCurrentDisplayParameters", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayParameters;", "getCurrentEditRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSession.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession\n+ 2 Guarder.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder$Companion\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,457:1\n68#2:458\n19#3:459\n125#4:460\n*S KotlinDebug\n*F\n+ 1 NextEditSession.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession\n*L\n49#1:458\n413#1:459\n455#1:460\n*E\n"})
public final class NextEditSession
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final NextEditSessionProgress progress;
    @NotNull
    private final FrontendNextEditEventsReporter reporter;
    @NotNull
    private final NextEditBehaviourSettings behaviourSettings;
    @NotNull
    private final Function1<NextEditSessionFinishType, Unit> autoDestroy;
    @NotNull
    private final NextEditSessionSuppressionGuarder suppressionGuarder;
    @NotNull
    private final Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder;
    @NotNull
    private final NextEditIntrusionModeController intrusionModeController;
    @NotNull
    private final NextEditDisplayManager displayManager;
    @NotNull
    private final NextEditViewRefreshManager refreshManager;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    /*
     * WARNING - void declaration
     */
    public NextEditSession(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditSessionProgress progress, @NotNull FrontendNextEditEventsReporter reporter, @NotNull NextEditBehaviourSettings behaviourSettings, @NotNull Function1<? super NextEditSessionFinishType, Unit> autoDestroy) {
        void assertions$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)behaviourSettings, (String)"behaviourSettings");
        Intrinsics.checkNotNullParameter(autoDestroy, (String)"autoDestroy");
        this.editor = editor2;
        this.project = project2;
        this.progress = progress;
        this.reporter = reporter;
        this.behaviourSettings = behaviourSettings;
        this.autoDestroy = autoDestroy;
        this.suppressionGuarder = new NextEditSessionSuppressionGuarder();
        Guarder.Companion companion = Guarder.Companion;
        String string = "Ignore document changes in session";
        Function0 function0 = NextEditSession::ignoreDocumentChangesGuarder$lambda$0;
        boolean $i$f$invoke = false;
        this.ignoreDocumentChangesGuarder = new Guarder<DocumentChangeGuardPurpose>((String)name$iv, (Function0<Boolean>)assertions$iv, DocumentChangeGuardPurpose.class);
        this.intrusionModeController = NextEditIntrusionModeController.Companion.of(this.editor, this.behaviourSettings.getPreviewMode());
        this.displayManager = new NextEditDisplayManager(this.ignoreDocumentChangesGuarder, this.behaviourSettings, (Function1<? super NextEditDisplayState, Unit>)((Function1)new Function1<NextEditDisplayState, Unit>((Object)this){

            public final void invoke(NextEditDisplayState p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                NextEditSession.access$onDisplayStateChanged((NextEditSession)this.receiver, p0);
            }
        }));
        this.refreshManager = new NextEditViewRefreshManager((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                NextEditSession.access$doRefreshView((NextEditSession)this.receiver);
            }
        }));
        this.startSession();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NextEditBehaviourSettings getBehaviourSettings() {
        return this.behaviourSettings;
    }

    @TestOnly
    @Nullable
    public final ActionHintPresentation getActionHintPresentation() {
        return this.progress.getActionHintPresentation();
    }

    @NotNull
    public final SuggestionKind getCurrentSuggestionKind() {
        return this.progress.getSuggestionKind();
    }

    @RequiresEdt
    public final void suppressIfNeeded(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        NextEditDisplayState displayState = this.displayManager.getDisplayState();
        if (displayState instanceof NextEditDisplayState.StepShown) {
            NextEditStepController.SuppressHandlerType suppressHandlerType = ((NextEditDisplayState.StepShown)displayState).getStepController().getSuppressHandlerType(this.editor, this.project, purpose);
            switch (WhenMappings.$EnumSwitchMapping$0[suppressHandlerType.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.displayCurrentStepOrJump(false);
                    this.suppressionGuarder.suppressionSkipped(purpose);
                    return;
                }
                case 3: {
                    this.suppressionGuarder.suppressionSkipped(purpose);
                    return;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        boolean wasSuppressed = this.suppressionGuarder.isSuppressed();
        this.doMarkSuppressedByPurposeAndLog(purpose);
        if (!wasSuppressed) {
            this.displayManager.suppress();
        }
    }

    public final boolean areDocumentChangesGuarded() {
        return this.ignoreDocumentChangesGuarder.isGuarded();
    }

    private final void doMarkSuppressedByPurposeAndLog(SuppressSessionGuardPurpose purpose) {
        boolean wasSuppressedByPurpose = this.suppressionGuarder.isSuppressed(purpose);
        boolean wasSuppressedByInline = NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder);
        this.suppressionGuarder.suppressed(purpose);
        if (!wasSuppressedByPurpose) {
            switch (WhenMappings.$EnumSwitchMapping$1[purpose.ordinal()]) {
                case 1: 
                case 2: {
                    if (wasSuppressedByInline) break;
                    this.reporter.onSuppressedByInline();
                    break;
                }
                case 3: {
                    this.reporter.onSuppressedByLookup();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.intrusionModeController.sessionSuppressed(purpose);
        }
    }

    @RequiresEdt
    public final void unsuppress(@NotNull SuppressSessionGuardPurpose purpose) {
        Intrinsics.checkNotNullParameter((Object)((Object)purpose), (String)"purpose");
        boolean wasSuppressed = this.suppressionGuarder.isSuppressed();
        this.doMarkUnsuppressedByPurposeAndLog(purpose);
        if (wasSuppressed && !this.suppressionGuarder.isSuppressed()) {
            this.displayCurrentStepOrJump(true);
        }
    }

    private final void doMarkUnsuppressedByPurposeAndLog(SuppressSessionGuardPurpose purpose) {
        boolean wasSuppressedByPurpose = this.suppressionGuarder.isSuppressed(purpose);
        boolean wasSuppressedByInline = NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder);
        this.suppressionGuarder.unsuppressed(purpose);
        if (wasSuppressedByPurpose && !this.suppressionGuarder.isSuppressed(purpose)) {
            switch (WhenMappings.$EnumSwitchMapping$1[purpose.ordinal()]) {
                case 1: 
                case 2: {
                    if (!wasSuppressedByInline || NextEditSessionSuppressionGuarderKt.isSuppressedByAnyInlineCompletionReason(this.suppressionGuarder)) break;
                    this.reporter.onUnsuppressedByInline();
                    break;
                }
                case 3: {
                    this.reporter.onUnsuppressedByLookup();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.intrusionModeController.sessionUnsuppressed(purpose);
        }
    }

    @RequiresEdt
    public final void refreshIfNeeded(@NotNull NextEditViewRefreshReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.displayManager.isDisplayInProgress()) {
            return;
        }
        NextEditDisplayState displayState = this.displayManager.getDisplayState();
        if (!(displayState instanceof NextEditDisplayState.StepShown)) {
            return;
        }
        if (((NextEditDisplayState.StepShown)displayState).getStepController().shouldRefreshOn(this.editor, this.project, reason)) {
            this.refreshManager.scheduleRefresh();
        }
    }

    @RequiresEdt
    public final boolean isActive() {
        NextEditDisplayState state2 = this.displayManager.getDisplayState();
        return this.progress.isActive() && (state2 instanceof NextEditDisplayState.StepShown || state2 instanceof NextEditDisplayState.JumpShown);
    }

    public final boolean canBeDestroyed() {
        boolean bl;
        SuggestionKind suggestionKind = this.getCurrentSuggestionKind();
        if (suggestionKind instanceof SuggestionKind.AI) {
            bl = !this.progress.isActive();
        } else if (suggestionKind instanceof SuggestionKind.Deterministic) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @RequiresWriteLock
    public final void handleTab() {
        block12: {
            NextEditDisplayState state2;
            block13: {
                ThreadingAssertions.assertEventDispatchThread();
                ThreadingAssertions.assertWriteAccess();
                if (!this.progress.isActive()) {
                    return;
                }
                state2 = this.displayManager.getDisplayState();
                if (Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Empty.INSTANCE)) break block12;
                if (Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Suppressed.INSTANCE)) {
                    FrontendNextEditDiagnosticsLogger.error$default(LOG, "Shortcut mustn't be handled when session is suppressed.", null, 2, null);
                    return;
                }
                if (!(state2 instanceof NextEditDisplayState.StepShown)) break block13;
                NextEditStepController stepController = ((NextEditDisplayState.StepShown)state2).getStepController();
                NextEditDisplayParameters viewParameters = this.getCurrentDisplayParameters();
                switch (WhenMappings.$EnumSwitchMapping$2[stepController.getKeyHandlerType(this.editor, this.project).ordinal()]) {
                    case 1: {
                        if (NextEditEditorUtil.INSTANCE.isCorrespondingLineVisible(this.editor, viewParameters.getStartOffset())) {
                            this.displayManager.undisplay();
                            NextEditSessionListener publisher = (NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC());
                            NextEditSessionStep stepToAccept = this.progress.currentStep();
                            publisher.beforeStepAccepted(this.editor, stepToAccept);
                            try {
                                this.acceptStep(stepToAccept, stepController);
                                this.intrusionModeController.stepAccepted();
                                break block12;
                            }
                            finally {
                                publisher.afterStepAccepted(this.editor, stepToAccept);
                                this.progress.advance();
                            }
                        }
                        stepController.makeVisible(this.editor, this.project);
                        return;
                    }
                    case 2: {
                        this.doHandleJump(((NextEditDisplayState.StepShown)state2).getStepController());
                        break block12;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (state2 instanceof NextEditDisplayState.JumpShown) {
                this.doHandleJump(((NextEditDisplayState.JumpShown)state2).getStepController());
                this.reporter.onJumpAccepted();
                this.intrusionModeController.jumpAccepted();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.displayCurrentStepOrJump(true);
        this.makeCurrentStepViewVisibleIfRendering();
    }

    public final void onDocumentEvent(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.ignoreDocumentChangesGuarder.isGuarded()) {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.DOCUMENT_CHANGE);
        }
    }

    public final void onCaretEvent(@NotNull CaretEventType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        if (!this.progress.isActive()) {
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$3[type2.ordinal()]) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.autoDestroy.invoke((Object)NextEditSessionFinishType.INCOMPATIBLE_CARET_CHANGE);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.ignoreDocumentChangesGuarder.isGuarded()) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.getCurrentSuggestionKind(), (Object)SuggestionKind.AI.INSTANCE)) {
            if (!this.intrusionModeController.caretMoved(this.getCurrentEditRange())) {
                this.autoDestroy.invoke((Object)NextEditSessionFinishType.INCOMPATIBLE_CARET_CHANGE);
            } else if (this.isActive()) {
                this.displayCurrentStepOrJump(false);
            }
        }
    }

    @TestOnly
    @NotNull
    public final NextEditDisplayState getDisplayState() {
        return this.displayManager.getDisplayState();
    }

    private final void startSession() {
        if (this.progress.isActive()) {
            NextEditSessionProgress.Listener progressListener2 = new NextEditSessionProgress.Listener(this){
                final /* synthetic */ NextEditSession this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onRepresentationUpdate() {
                    NextEditSession.access$handleStepRepresentationUpdated(this.this$0);
                }
            };
            this.progress.addListener(progressListener2);
        }
        this.displayCurrentStepOrJump(true);
    }

    public final void reportSessionFinished(@NotNull NextEditSessionFinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        this.reporter.onSessionFinished(finishType, EditorIdKt.editorIdOrNull((Editor)this.editor));
        LOG.trace((Function0<String>)((Function0)() -> NextEditSession.reportSessionFinished$lambda$0(finishType)));
    }

    private final void handleStepRepresentationUpdated() {
        ThreadingAssertions.assertEventDispatchThread();
        NextEditDisplayState state2 = this.displayManager.getDisplayState();
        if (!(Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Empty.INSTANCE) || Intrinsics.areEqual((Object)state2, (Object)NextEditDisplayState.Suppressed.INSTANCE) || state2 instanceof NextEditDisplayState.JumpShown)) {
            if (state2 instanceof NextEditDisplayState.StepShown) {
                NextEditStepController stepController = ((NextEditDisplayState.StepShown)state2).getStepController();
                NextEditStepController.RepresentationUpdateHandler updateResult = stepController.onRepresentationUpdated(this.editor, this.project);
                switch (WhenMappings.$EnumSwitchMapping$4[updateResult.ordinal()]) {
                    case 1: {
                        this.displayCurrentStepOrJump(false);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                LOG.trace((Function0<String>)((Function0)() -> NextEditSession.handleStepRepresentationUpdated$lambda$0(stepController, updateResult)));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void doRefreshView() {
        NextEditDisplayState nextEditDisplayState = this.displayManager.getDisplayState();
        if (nextEditDisplayState instanceof NextEditDisplayState.StepShown) {
            this.displayCurrentStepOrJump(false);
        } else if (!(nextEditDisplayState instanceof NextEditDisplayState.JumpShown || Intrinsics.areEqual((Object)nextEditDisplayState, (Object)NextEditDisplayState.Empty.INSTANCE) || Intrinsics.areEqual((Object)nextEditDisplayState, (Object)NextEditDisplayState.Suppressed.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void doHandleJump(NextEditStepController stepController) {
        int currentOffset;
        int offsetToJump = stepController.getOffsetToJump(this.editor, this.project);
        if (offsetToJump != (currentOffset = this.editor.getCaretModel().getOffset())) {
            this.ignoreDocumentChangesGuarder.withGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.JUMPING_TO_STEP), () -> NextEditSession.doHandleJump$lambda$0(this, offsetToJump));
            UndoableCaretMoveAction undoableAction = new UndoableCaretMoveAction(this.editor, currentOffset, offsetToJump);
            UndoManager.getInstance((Project)this.project).undoableActionPerformed((UndoableAction)undoableAction);
        }
        this.displayManager.undisplay();
    }

    private final void displayCurrentStepOrJump(boolean notifyIntrusionController) {
        if (this.progress.isActive()) {
            boolean success;
            NextEditDisplayParameters displayParameters;
            NextEditDisplayIntrusionMode nextEditDisplayIntrusionMode;
            if (notifyIntrusionController) {
                this.intrusionModeController.beforeNewViewShown(this.getCurrentEditRange());
            }
            if ((nextEditDisplayIntrusionMode = (displayParameters = this.getCurrentDisplayParameters()).getIntrusionMode()) == null) {
                nextEditDisplayIntrusionMode = this.intrusionModeController.getIntrusionMode();
            }
            if (!(success = this.displayManager.display(displayParameters, nextEditDisplayIntrusionMode, this.reporter))) {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Failed to display step/jump view in the active progress. Session will be destroyed.", null, 2, null);
                this.autoDestroy.invoke((Object)NextEditSessionFinishType.COULD_NOT_SHOW);
            }
        } else if (this.progress.isCompleted()) {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.ACCEPTED);
        } else {
            this.autoDestroy.invoke((Object)NextEditSessionFinishType.INACTIVE);
        }
    }

    @RequiresEdt
    @RequiresWriteLock
    private final void acceptStep(NextEditSessionStep step2, NextEditStepController controller2) {
        this.ignoreDocumentChangesGuarder.withGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.ACCEPTING_STEP), () -> NextEditSession.acceptStep$lambda$0(this, step2, controller2));
    }

    @RequiresEdt
    private final void makeCurrentStepViewVisibleIfRendering() {
        block2: {
            NextEditStepController viewController;
            ThreadingAssertions.assertEventDispatchThread();
            if (!this.isActive()) break block2;
            NextEditDisplayState $this$asSafely$iv = this.displayManager.getDisplayState();
            boolean $i$f$asSafely = false;
            NextEditDisplayState nextEditDisplayState = $this$asSafely$iv;
            if (!(nextEditDisplayState instanceof NextEditDisplayState.StepShown)) {
                nextEditDisplayState = null;
            }
            NextEditDisplayState.StepShown stepShown = (NextEditDisplayState.StepShown)nextEditDisplayState;
            NextEditStepController nextEditStepController = viewController = stepShown != null ? stepShown.getStepController() : null;
            if (nextEditStepController != null) {
                nextEditStepController.makeVisible(this.editor, this.project);
            }
        }
    }

    private final void onDisplayStateChanged(NextEditDisplayState newState) {
        ThreadingAssertions.assertEventDispatchThread();
        NextEditDisplayState nextEditDisplayState = newState;
        if (nextEditDisplayState instanceof NextEditDisplayState.StepShown) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterStepShown(this.editor, this);
        } else if (nextEditDisplayState instanceof NextEditDisplayState.Suppressed) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionSuppressed(this.editor, this);
        } else if (nextEditDisplayState instanceof NextEditDisplayState.JumpShown) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterJumpShown(this.editor, this);
        } else if (!(nextEditDisplayState instanceof NextEditDisplayState.Empty)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.progress);
        Disposer.dispose((Disposable)this.displayManager);
        Disposer.dispose((Disposable)this.refreshManager);
    }

    private final NextEditDisplayParameters getCurrentDisplayParameters() {
        NextEditSessionStep nextEditSessionStep = this.progress.currentStep();
        ActionHintPresentation actionHintPresentation = this.progress.getActionHintPresentation();
        NextEditDisplayIntrusionMode nextEditDisplayIntrusionMode = this.progress.getForcedIntrusionMode();
        if (nextEditDisplayIntrusionMode == null) {
            nextEditDisplayIntrusionMode = this.intrusionModeController.getIntrusionMode();
        }
        return new NextEditDisplayParameters(nextEditSessionStep, this.editor, this.project, actionHintPresentation, nextEditDisplayIntrusionMode);
    }

    private final TextRange getCurrentEditRange() {
        return this.progress.currentStep().getCorrespondingRange();
    }

    private static final boolean ignoreDocumentChangesGuarder$lambda$0() {
        return EDT.isCurrentThreadEdt();
    }

    private static final String reportSessionFinished$lambda$0(NextEditSessionFinishType $finishType) {
        return "Session finished with " + $finishType;
    }

    private static final String handleStepRepresentationUpdated$lambda$0(NextEditStepController $stepController, NextEditStepController.RepresentationUpdateHandler $updateResult) {
        return "Step controller " + $stepController.getClass().getSimpleName() + " handled representation update: " + $updateResult.name();
    }

    private static final Unit doHandleJump$lambda$0(NextEditSession this$0, int $offsetToJump) {
        this$0.editor.getCaretModel().moveToOffset($offsetToJump);
        return Unit.INSTANCE;
    }

    private static final Unit acceptStep$lambda$0(NextEditSession this$0, NextEditSessionStep $step, NextEditStepController $controller) {
        ExtKt.onAccepted(this$0.reporter, $step, this$0.editor);
        $controller.accept(this$0.editor, this$0.project);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$handleStepRepresentationUpdated(NextEditSession $this) {
        $this.handleStepRepresentationUpdated();
    }

    public static final /* synthetic */ void access$onDisplayStateChanged(NextEditSession $this, NextEditDisplayState newState) {
        $this.onDisplayStateChanged(newState);
    }

    public static final /* synthetic */ void access$doRefreshView(NextEditSession $this) {
        $this.doRefreshView();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[NextEditStepController.SuppressHandlerType.values().length];
            try {
                nArray[NextEditStepController.SuppressHandlerType.SUPPRESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.SuppressHandlerType.RERENDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.SuppressHandlerType.DO_NOTHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SuppressSessionGuardPurpose.values().length];
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.LOOKUP_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NextEditStepController.KeyHandlerType.values().length];
            try {
                nArray[NextEditStepController.KeyHandlerType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.KeyHandlerType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[CaretEventType.values().length];
            try {
                nArray[CaretEventType.MOVEMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaretEventType.CARET_ADDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[NextEditStepController.RepresentationUpdateHandler.values().length];
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.RERENDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.PROCESSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.RepresentationUpdateHandler.DO_NOTHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

