/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.diff.general;

import com.intellij.ml.llm.nextEdits.common.provider.ActionHintPresentation;
import com.intellij.ml.llm.nextEdits.frontend.session.highlight.NextEditHighlightingInfo;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.EnrichedNextEditDiffPresentation;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.NextEditStepView;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.general.NextEditPanelViewBase;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.general.NextEditRightPanelView;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.general.NextEditUnderPanelView;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditShortcutHintType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditDiffGeneralView;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/NextEditStepView;", "diff", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;", "presentation", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "additionalHighlighting", "Lcom/intellij/ml/llm/nextEdits/frontend/session/highlight/NextEditHighlightingInfo;", "actionHintPresentation", "Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/nextEdits/frontend/session/highlight/NextEditHighlightingInfo;Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;)V", "underView", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditUnderPanelView;", "rightView", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditRightPanelView;", "currentPlace", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditPanelViewBase$Place;", "currentDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "show", "", "hintType", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditShortcutHintType;", "doShow", "dispose", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditDiffGeneralView
implements NextEditStepView {
    @NotNull
    private final Editor editor;
    @NotNull
    private final NextEditUnderPanelView underView;
    @NotNull
    private final NextEditRightPanelView rightView;
    @Nullable
    private NextEditPanelViewBase.Place currentPlace;
    @NotNull
    private Disposable currentDisposable;

    public NextEditDiffGeneralView(@NotNull NextEditGeneralDiffModel diff2, @NotNull EnrichedNextEditDiffPresentation presentation2, @NotNull FileType fileType2, @NotNull Project project2, @NotNull Editor editor2, @NotNull NextEditHighlightingInfo additionalHighlighting, @Nullable ActionHintPresentation actionHintPresentation) {
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)additionalHighlighting, (String)"additionalHighlighting");
        this.editor = editor2;
        this.underView = new NextEditUnderPanelView(diff2, presentation2, fileType2, project2, this.editor, additionalHighlighting, actionHintPresentation);
        this.rightView = new NextEditRightPanelView(diff2, presentation2, fileType2, project2, this.editor, additionalHighlighting, actionHintPresentation);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.currentDisposable = disposable;
    }

    @Override
    public void show(@NotNull NextEditShortcutHintType hintType) {
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        this.doShow(hintType);
        VisibleAreaListener listener2 = arg_0 -> NextEditDiffGeneralView.show$lambda$0(this, hintType, arg_0);
        this.editor.getScrollingModel().addVisibleAreaListener(listener2, (Disposable)this);
    }

    private final void doShow(NextEditShortcutHintType hintType) {
        boolean isRightPossible = this.rightView.isPossibleToShow();
        if (this.currentPlace != null && this.currentPlace == NextEditPanelViewBase.Place.RIGHT == isRightPossible) {
            return;
        }
        Disposer.dispose((Disposable)this.currentDisposable);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.currentDisposable = disposable;
        if (isRightPossible) {
            this.currentPlace = NextEditPanelViewBase.Place.RIGHT;
            this.rightView.show(hintType, this.currentDisposable);
        } else {
            this.currentPlace = NextEditPanelViewBase.Place.UNDER;
            this.underView.show(hintType, this.currentDisposable);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.currentDisposable);
        this.currentPlace = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void show$lambda$0(NextEditDiffGeneralView this$0, NextEditShortcutHintType $hintType, VisibleAreaEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Rectangle rectangle = event2.getOldRectangle();
        boolean bl = rectangle != null ? rectangle.x == event2.getNewRectangle().x : false;
        if (bl) {
            boolean bl2;
            Rectangle rectangle2 = event2.getOldRectangle();
            if (rectangle2 != null) {
                if (rectangle2.width == event2.getNewRectangle().width) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return;
        }
        boolean bl3 = true;
        boolean isHorizontallyChanged = bl3;
        if (!isHorizontallyChanged) return;
        if (this$0.currentPlace == null) return;
        ApplicationKt.getApplication().invokeLater(() -> NextEditDiffGeneralView.show$lambda$0$0(this$0, $hintType));
    }

    private static final void show$lambda$0$0(NextEditDiffGeneralView this$0, NextEditShortcutHintType $hintType) {
        if (this$0.currentPlace != null) {
            this$0.doShow($hintType);
        }
    }
}

