/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.view;

import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.frontend.completion.inline.InlineCompletionSuppressStateByNextEditSupplier;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionManager;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.DocumentChangeGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.Guarder;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditActionModel;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.NextEditActionView;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditActionDisplayer;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditShortcutHintType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayerImpl;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayer;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditActionModel;", "action", "ignoreDocumentChangesGuarder", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/DocumentChangeGuardPurpose;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditActionModel;Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder;)V", "isIntrusive", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "show", "", "hintType", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditShortcutHintType;", "disposable", "Lcom/intellij/openapi/Disposable;", "guardDocumentChanged", "endSessionWhenCaretLeavesRegion", "suppressInlineCompletion", "InvalidateSessionWhenCaretLeavesRegionListener", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditActionDisplayerImpl
extends NextEditActionDisplayer<NextEditActionModel> {
    @NotNull
    private final Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder;

    public NextEditActionDisplayerImpl(@NotNull NextEditActionModel action2, @NotNull Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter(ignoreDocumentChangesGuarder, (String)"ignoreDocumentChangesGuarder");
        super(action2);
        this.ignoreDocumentChangesGuarder = ignoreDocumentChangesGuarder;
    }

    @Override
    public boolean isIntrusive(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return false;
    }

    @Override
    public void show(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditShortcutHintType hintType, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        NextEditActionView view = new NextEditActionView(editor2, this.getAction().getAction().shortcutHintText(), this.getAction().getActionRange());
        view.show(hintType);
        Disposer.register((Disposable)disposable, (Disposable)view);
        this.guardDocumentChanged(disposable);
        this.endSessionWhenCaretLeavesRegion(editor2, disposable);
        this.suppressInlineCompletion(editor2, disposable);
    }

    private final void guardDocumentChanged(Disposable disposable) {
        this.ignoreDocumentChangesGuarder.startGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.ACTION_VIEW_IS_SHOWN));
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditActionDisplayerImpl.guardDocumentChanged$lambda$0(this));
    }

    private final void endSessionWhenCaretLeavesRegion(Editor editor2, Disposable disposable) {
        InvalidateSessionWhenCaretLeavesRegionListener caretListener2 = InvalidateSessionWhenCaretLeavesRegionListener.Companion.installIfNotInstalled(editor2);
        caretListener2.watch(this.getAction().getActionRange());
        DisposerUtilKt.whenDisposed((Disposable)disposable, () -> NextEditActionDisplayerImpl.endSessionWhenCaretLeavesRegion$lambda$0(caretListener2));
    }

    private final void suppressInlineCompletion(Editor editor2, Disposable disposable) {
        block1: {
            InlineCompletionSuppressStateByNextEditSupplier.Companion.suppress(editor2, disposable);
            InlineCompletionSession inlineCompletionSession = InlineCompletionSession.Companion.getOrNull(editor2);
            if (inlineCompletionSession == null || inlineCompletionSession.getContext().isCurrentlyDisplaying()) break block1;
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull(editor2);
            if (inlineCompletionHandler != null) {
                inlineCompletionHandler.hide(inlineCompletionSession.getContext(), InlineCompletionUsageTracker.ShownEvents.FinishType.OTHER);
            }
        }
    }

    private static final Unit guardDocumentChanged$lambda$0(NextEditActionDisplayerImpl this$0) {
        this$0.ignoreDocumentChangesGuarder.endGuard((DocumentChangeGuardPurpose)((Enum)DocumentChangeGuardPurpose.ACTION_VIEW_IS_SHOWN));
        return Unit.INSTANCE;
    }

    private static final Unit endSessionWhenCaretLeavesRegion$lambda$0(InvalidateSessionWhenCaretLeavesRegionListener $caretListener) {
        $caretListener.unwatch();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayerImpl$InvalidateSessionWhenCaretLeavesRegionListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "watchedRegion", "Lcom/intellij/openapi/editor/RangeMarker;", "watch", "", "region", "Lcom/intellij/openapi/util/TextRange;", "unwatch", "caretPositionChanged", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "dispose", "Companion", "intellij.ml.llm.nextEdits.frontend"})
    private static final class InvalidateSessionWhenCaretLeavesRegionListener
    implements CaretListener,
    Disposable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Editor editor;
        @Nullable
        private RangeMarker watchedRegion;
        @NotNull
        private static final Key<InvalidateSessionWhenCaretLeavesRegionListener> LISTENER_KEY;

        public InvalidateSessionWhenCaretLeavesRegionListener(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.editor = editor2;
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        public final void watch(@NotNull TextRange region) {
            void it;
            RangeMarker rangeMarker;
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            ThreadingAssertions.assertEventDispatchThread();
            RangeMarker rangeMarker2 = this.watchedRegion;
            if (rangeMarker2 != null) {
                rangeMarker2.dispose();
            }
            RangeMarker rangeMarker3 = rangeMarker = this.editor.getDocument().createRangeMarker(region);
            InvalidateSessionWhenCaretLeavesRegionListener invalidateSessionWhenCaretLeavesRegionListener = this;
            boolean bl = false;
            it.setGreedyToLeft(true);
            it.setGreedyToRight(true);
            invalidateSessionWhenCaretLeavesRegionListener.watchedRegion = rangeMarker;
        }

        @RequiresEdt
        public final void unwatch() {
            ThreadingAssertions.assertEventDispatchThread();
            RangeMarker rangeMarker = this.watchedRegion;
            if (rangeMarker != null) {
                rangeMarker.dispose();
            }
            this.watchedRegion = null;
        }

        public void caretPositionChanged(@NotNull CaretEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            RangeMarker rangeMarker = this.watchedRegion;
            if (rangeMarker == null) {
                return;
            }
            RangeMarker watchedRegion = rangeMarker;
            int newOffset = this.editor.logicalPositionToOffset(event2.getNewPosition());
            int n = watchedRegion.getStartOffset();
            if (!(newOffset <= watchedRegion.getEndOffset() ? n <= newOffset : false)) {
                ApplicationKt.getApplication().invokeLater(() -> InvalidateSessionWhenCaretLeavesRegionListener.caretPositionChanged$lambda$0(this));
            }
        }

        public void dispose() {
            RangeMarker rangeMarker = this.watchedRegion;
            if (rangeMarker != null) {
                rangeMarker.dispose();
            }
            this.watchedRegion = null;
        }

        private static final void caretPositionChanged$lambda$0(InvalidateSessionWhenCaretLeavesRegionListener this$0) {
            block0: {
                NextEditSessionManager nextEditSessionManager = NextEditSessionManager.Companion.getInstance(this$0.editor);
                if (nextEditSessionManager == null) break block0;
                nextEditSessionManager.finishSession(NextEditSessionFinishType.INCOMPATIBLE_CARET_CHANGE);
            }
        }

        static {
            Key key = Key.create((String)"intellij.ml.llm.next.edits.codeInsight.session.caret.listener");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            LISTENER_KEY = key;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayerImpl$InvalidateSessionWhenCaretLeavesRegionListener$Companion;", "", "<init>", "()V", "LISTENER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayerImpl$InvalidateSessionWhenCaretLeavesRegionListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "installIfNotInstalled", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.ml.llm.nextEdits.frontend"})
        @SourceDebugExtension(value={"SMAP\nNextEditActionDisplayerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditActionDisplayerImpl.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditActionDisplayerImpl$InvalidateSessionWhenCaretLeavesRegionListener$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @RequiresEdt
            @NotNull
            public final InvalidateSessionWhenCaretLeavesRegionListener installIfNotInstalled(@NotNull Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                ThreadingAssertions.assertEventDispatchThread();
                InvalidateSessionWhenCaretLeavesRegionListener invalidateSessionWhenCaretLeavesRegionListener = (InvalidateSessionWhenCaretLeavesRegionListener)editor2.getUserData(LISTENER_KEY);
                if (invalidateSessionWhenCaretLeavesRegionListener != null) {
                    InvalidateSessionWhenCaretLeavesRegionListener it = invalidateSessionWhenCaretLeavesRegionListener;
                    boolean bl = false;
                    return it;
                }
                InvalidateSessionWhenCaretLeavesRegionListener listener2 = new InvalidateSessionWhenCaretLeavesRegionListener(editor2);
                editor2.getCaretModel().addCaretListener((CaretListener)listener2);
                editor2.putUserData(LISTENER_KEY, (Object)listener2);
                EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.installIfNotInstalled$lambda$1(editor2));
                return listener2;
            }

            private static final void installIfNotInstalled$lambda$1(Editor $editor) {
                InvalidateSessionWhenCaretLeavesRegionListener finalListener;
                InvalidateSessionWhenCaretLeavesRegionListener invalidateSessionWhenCaretLeavesRegionListener = finalListener = (InvalidateSessionWhenCaretLeavesRegionListener)$editor.getUserData(LISTENER_KEY);
                if (invalidateSessionWhenCaretLeavesRegionListener != null) {
                    InvalidateSessionWhenCaretLeavesRegionListener it = invalidateSessionWhenCaretLeavesRegionListener;
                    boolean bl = false;
                    $editor.getCaretModel().removeCaretListener((CaretListener)it);
                    Disposer.dispose((Disposable)it);
                }
                $editor.putUserData(LISTENER_KEY, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

