/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore.internal;

import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/internal/AiAssistantMeasureAiCheck;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.ml.llm.privacy"})
@SourceDebugExtension(value={"SMAP\nAiAssistantMeasureAiCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiAssistantMeasureAiCheck.kt\ncom/intellij/ml/llm/privacy/aiignore/internal/AiAssistantMeasureAiCheck\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,47:1\n45#2,3:48\n*S KotlinDebug\n*F\n+ 1 AiAssistantMeasureAiCheck.kt\ncom/intellij/ml/llm/privacy/aiignore/internal/AiAssistantMeasureAiCheck\n*L\n27#1:48,3\n*E\n"})
public final class AiAssistantMeasureAiCheck
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String title = "AI Assistant AiIgnore Measurement";
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        VirtualFile vf = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (vf == null || !vf.isValid()) {
            String message = "Can't measure. Execute in valid file";
            Messages.showWarningDialog((String)message, (String)title);
            return;
        }
        int n = 100;
        int trueCount = 0;
        int falseCount = 0;
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            int it = i;
            boolean bl2 = false;
            if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project3, vf)) {
                n2 = trueCount;
                trueCount = n2 + 1;
                continue;
            }
            n2 = falseCount;
            falseCount = n2 + 1;
        }
        long time = System.nanoTime() - start$iv;
        String result2 = trueCount == n ? "true" : (falseCount == n ? "false" : "(true " + trueCount + ", false " + falseCount + ")");
        String message = "Time " + Duration.toString-impl((long)Duration.div-UwyO8pc((long)DurationKt.toDuration((long)time, (DurationUnit)DurationUnit.NANOSECONDS), (int)n)) + " ns. result: " + result2;
        Messages.showInfoMessage((String)message, (String)title);
    }
}

