/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.intentions;

import com.intellij.ml.llm.LLMBundle;
import com.intellij.ml.llm.python.intentions.HighlighterDismisser;
import com.intellij.ml.llm.python.intentions.RevertGutterRenderer;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a.\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\tH\u0000\u00a8\u0006\n"}, d2={"update", "", "Lcom/intellij/openapi/editor/Editor;", "newText", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "updateWithRevertAction", "onGutterClick", "Lkotlin/Function0;", "intellij.ml.llm.python"})
public final class IntentionUtilsKt {
    public static final void update(@NotNull Editor $this$update, @NotNull String newText, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Project project2 = $this$update.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        CommandProcessor.getInstance().executeCommand(project3, () -> IntentionUtilsKt.update$lambda$0($this$update, textRange, newText, project3), LLMBundle.message((String)"command.name.update.document", (Object[])new Object[0]), null);
    }

    public static final void updateWithRevertAction(@NotNull Editor $this$updateWithRevertAction, @NotNull String newText, @NotNull TextRange textRange, @Nullable Function0<Unit> onGutterClick) {
        Intrinsics.checkNotNullParameter((Object)$this$updateWithRevertAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Project project2 = $this$updateWithRevertAction.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        TextAttributes highlightAttributes = new TextAttributes(null, $this$updateWithRevertAction.getColorsScheme().getColor(EditorColors.MODIFIED_LINES_COLOR), $this$updateWithRevertAction.getColorsScheme().getColor(EditorColors.BORDER_LINES_COLOR), EffectType.BOXED, 0);
        TextRange newRange = new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + newText.length());
        CommandProcessor.getInstance().executeCommand(project3, () -> IntentionUtilsKt.updateWithRevertAction$lambda$0($this$updateWithRevertAction, newText, textRange), null, null);
        RangeHighlighter rangeHighlighter = $this$updateWithRevertAction.getMarkupModel().addRangeHighlighter(newRange.getStartOffset(), newRange.getEndOffset(), 6000, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter;
        HighlighterDismisser dismissListener = new HighlighterDismisser(highlighter);
        $this$updateWithRevertAction.getDocument().addDocumentListener((DocumentListener)dismissListener);
        highlighter.setGutterIconRenderer((GutterIconRenderer)new RevertGutterRenderer((Function0<Unit>)((Function0)() -> IntentionUtilsKt.updateWithRevertAction$lambda$1($this$updateWithRevertAction, project3, onGutterClick))));
    }

    public static /* synthetic */ void updateWithRevertAction$default(Editor editor2, String string, TextRange textRange, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        IntentionUtilsKt.updateWithRevertAction(editor2, string, textRange, (Function0<Unit>)function0);
    }

    private static final void update$lambda$0(Editor $this_update, TextRange $textRange, String $newText, Project $project) {
        block0: {
            PsiFile psiFile;
            $this_update.getDocument().replaceString($textRange.getStartOffset(), $textRange.getEndOffset(), (CharSequence)$newText);
            PsiDocumentManager.getInstance((Project)$project).commitDocument($this_update.getDocument());
            PsiFile psiFile2 = psiFile = PsiDocumentManager.getInstance((Project)$project).getPsiFile($this_update.getDocument());
            if (psiFile2 == null) break block0;
            PsiFile it = psiFile2;
            boolean bl = false;
            TextRange reformatRange = new TextRange($textRange.getStartOffset(), $textRange.getStartOffset() + $newText.length());
            CodeStyleManager.getInstance((Project)$project).reformatText(it, (Collection)CollectionsKt.listOf((Object)reformatRange));
        }
    }

    private static final void updateWithRevertAction$lambda$0(Editor $this_updateWithRevertAction, String $newText, TextRange $textRange) {
        IntentionUtilsKt.update($this_updateWithRevertAction, $newText, $textRange);
    }

    private static final Unit updateWithRevertAction$lambda$1(Editor $this_updateWithRevertAction, Project $project, Function0 $onGutterClick) {
        UndoManager undoManager;
        TextEditor textEditor = TextEditorProvider.Companion.getInstance().getTextEditor($this_updateWithRevertAction);
        UndoManager $this$updateWithRevertAction_u24lambda_u241_u240 = undoManager = UndoManager.getInstance((Project)$project);
        boolean bl = false;
        Function0 function0 = $onGutterClick;
        if (function0 != null) {
            function0.invoke();
        }
        if ($this$updateWithRevertAction_u24lambda_u241_u240.isUndoAvailable((FileEditor)textEditor)) {
            $this$updateWithRevertAction_u24lambda_u241_u240.undo((FileEditor)textEditor);
        }
        return Unit.INSTANCE;
    }
}

