/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.postProcessing;

import com.intellij.ml.llm.core.postProcessing.IndentMatcherProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStatementWithElse;
import com.jetbrains.python.psi.PyTryExceptStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\u000b*\u00020\u000bH\u0002J\f\u0010\r\u001a\u00020\u000b*\u00020\u000bH\u0002J\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J \u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0002JM\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\"\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0 0\u001f\"\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0 H\u0002\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J%\u0010#\u001a\u00020\u0017*\u00020\u000b2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001f\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010%J<\u0010&\u001a\u0004\u0018\u00010\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(2\u0006\u0010)\u001a\u00020\u000b2\u001a\u0010*\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020,0 \u0012\u0004\u0012\u00020\u000b0+H\u0002J=\u0010-\u001a\u0004\u0018\u00010\u00112\b\u0010.\u001a\u0004\u0018\u00010\u00112\"\u0010\u001e\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110 0\u001f\"\n\u0012\u0006\b\u0001\u0012\u00020\u00110 H\u0002\u00a2\u0006\u0002\u0010/J(\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0002\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/python/postProcessing/PythonIndentMatcherProvider;", "Lcom/intellij/ml/llm/core/postProcessing/IndentMatcherProvider;", "<init>", "()V", "getMatcher", "Lcom/intellij/ml/llm/core/postProcessing/IndentMatcherProvider$Matcher;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/util/TextRange;", "textBefore", "", "getLineIndent", "getMinIndent", "ensureSuffix", "suffix", "getBlockOrElem", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "pos", "", "hasNewlineAt", "", "Lcom/intellij/openapi/editor/Document;", "offset", "getIndentAfter", "document", "getContainingElement", "T", "classes", "", "Ljava/lang/Class;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "isInsideLiteral", "startsWithKeyword", "keywords", "(Ljava/lang/String;[Ljava/lang/String;)Z", "calculateDeindent", "filteredLines", "", "indentUnit", "containerIndents", "", "Lcom/jetbrains/python/psi/PyStatement;", "selfOrParentOfType", "psiElement", "(Lcom/intellij/psi/PsiElement;[Ljava/lang/Class;)Lcom/intellij/psi/PsiElement;", "calculateRestIndent", "firstLine", "indent", "currentRestIndent", "intellij.ml.llm.python"})
@SourceDebugExtension(value={"SMAP\nPythonIndentMatcherProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonIndentMatcherProvider.kt\ncom/intellij/ml/llm/python/postProcessing/PythonIndentMatcherProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1563#2:227\n1634#2,3:228\n774#2:231\n865#2,2:232\n1193#2,2:234\n1267#2,4:236\n774#2:245\n865#2,2:246\n1563#2:248\n1634#2,3:249\n2783#2,7:252\n774#2:260\n865#2,2:261\n648#3,5:240\n1#4:259\n*S KotlinDebug\n*F\n+ 1 PythonIndentMatcherProvider.kt\ncom/intellij/ml/llm/python/postProcessing/PythonIndentMatcherProvider\n*L\n61#1:227\n61#1:228,3\n62#1:231\n62#1:232,2\n63#1:234,2\n63#1:236,4\n129#1:245\n129#1:246,2\n130#1:248\n130#1:249,3\n131#1:252,7\n66#1:260\n66#1:261,2\n126#1:240,5\n*E\n"})
public final class PythonIndentMatcherProvider
implements IndentMatcherProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public IndentMatcherProvider.Matcher getMatcher(@NotNull Editor editor2, @NotNull TextRange range, @NotNull String textBefore) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair pair;
        Pair it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string;
        Object indent;
        PsiElement block;
        String indentUnit;
        VirtualFile psiFile;
        block11: {
            Object object;
            block10: {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter((Object)textBefore, (String)"textBefore");
                Project project2 = editor2.getProject();
                if (project2 == null) {
                    return null;
                }
                Project project3 = project2;
                VirtualFile virtualFile2 = editor2.getVirtualFile();
                if (virtualFile2 == null || (virtualFile2 = VirtualFileUtil.findPsiFile((VirtualFile)virtualFile2, (Project)project3)) == null) {
                    return null;
                }
                psiFile = virtualFile2;
                String string2 = PyIndentUtil.getIndentFromSettings((PsiFile)psiFile);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIndentFromSettings(...)");
                indentUnit = string2;
                if (this.isInsideLiteral((PsiFile)psiFile, range) || StringsKt.isBlank((CharSequence)textBefore)) {
                    return null;
                }
                block = this.getBlockOrElem((PsiFile)psiFile, range.getStartOffset());
                object = block;
                if (object == null) break block10;
                PsiElement it2 = object;
                boolean bl = false;
                String string3 = it2 instanceof PyStatementListContainer ? PyIndentUtil.getElementIndent((PsiElement)((PsiElement)((PyStatementListContainer)it2).getStatementList())) : PyIndentUtil.getElementIndent((PsiElement)it2);
                object = string3;
                if (string3 != null) break block11;
            }
            object = indent = "";
        }
        if ((string = (String)CollectionsKt.lastOrNull((List)StringsKt.lines((CharSequence)textBefore))) == null) {
            string = "";
        }
        String lastLineBefore = string;
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        String indentAfter = this.getIndentAfter((PsiFile)psiFile, document2, range.getEndOffset());
        Document document3 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        boolean textAfterStartsNL = this.hasNewlineAt(document3, range.getEndOffset());
        boolean lastLineDeindented = this.getLineIndent(lastLineBefore).length() < ((String)indent).length();
        Object object = new Class[]{PyFunction.class, PyClass.class, PyStatementWithElse.class, PyTryExceptStatement.class};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$map = false;
        void var16_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Class clazz = (Class)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            pair = new Pair[]{it};
            collection.add(TuplesKt.to((Object)it, (Object)this.selfOrParentOfType(block, (Class<? extends PsiElement>)pair)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            Pair it3 = (Pair)element$iv$iv;
            boolean bl = false;
            Object object2 = it3.getFirst();
            Object object3 = it3.getSecond();
            Intrinsics.checkNotNull((Object)object3);
            pair = TuplesKt.to((Object)object2, (Object)PyIndentUtil.getElementIndent((PsiElement)((PsiElement)object3)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map containerIndents = destination$iv$iv2;
        return arg_0 -> PythonIndentMatcherProvider.getMatcher$lambda$4(textBefore, lastLineDeindented, this, indentUnit, containerIndents, (String)indent, lastLineBefore, textAfterStartsNL, indentAfter, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final String getLineIndent(String $this$getLineIndent) {
        String string;
        block1: {
            void var2_2;
            String $this$takeWhile$iv = $this$getLineIndent;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == ' ' || it == '\t') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String getMinIndent(String $this$getMinIndent) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)$this$getMinIndent);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getLineIndent(it));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void s;
            String $i$f$mapTo2 = (String)iterator$iv.next();
            String minS = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = minS.length() < s.length() ? minS : s;
        }
        return (String)accumulator$iv;
    }

    private final String ensureSuffix(String $this$ensureSuffix, String suffix) {
        return StringsKt.endsWith$default((String)$this$ensureSuffix, (String)suffix, (boolean)false, (int)2, null) ? $this$ensureSuffix : $this$ensureSuffix + suffix;
    }

    private final PsiElement getBlockOrElem(PsiFile file2, int pos) {
        PsiElement psiElement;
        int offset = Math.max(pos - 1, 0);
        PsiElement psiElem = file2.findElementAt(offset);
        while (offset >= 0 && (psiElem == null || (psiElem instanceof PsiWhiteSpace || psiElem instanceof PsiComment) && PsiTreeUtil.getParentOfType((PsiElement)psiElem, PyStatementListContainer.class) == null) && (offset = ((psiElement = psiElem) != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset) - 1) >= 0) {
            psiElem = file2.findElementAt(offset);
        }
        if (psiElem == null) {
            return null;
        }
        PyStatementListContainer pyStatementListContainer = (PyStatementListContainer)PsiTreeUtil.getParentOfType((PsiElement)psiElem, PyStatementListContainer.class);
        if (pyStatementListContainer == null) {
            return psiElem;
        }
        PyStatementListContainer block = pyStatementListContainer;
        return (PsiElement)block;
    }

    private final boolean hasNewlineAt(Document $this$hasNewlineAt, int offset) {
        if (offset + 1 >= $this$hasNewlineAt.getTextLength()) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$hasNewlineAt.getText(new TextRange(offset, offset + 1)), (Object)"\n");
    }

    private final String getIndentAfter(PsiFile file2, Document document2, int offset) {
        if (offset + 1 >= file2.getTextLength()) {
            return "";
        }
        if (this.hasNewlineAt(document2, offset)) {
            return "";
        }
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return "";
        }
        PsiElement psiElem = psiElement;
        String string = PyIndentUtil.getElementIndent((PsiElement)psiElem);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementIndent(...)");
        return string;
    }

    private final <T extends PsiElement> T getContainingElement(PsiFile file2, TextRange range, Class<? extends T> ... classes2) {
        PsiElement psiElement = file2.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return null;
        }
        PsiElement startElem = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)startElem, (Class[])Arrays.copyOf(classes2, classes2.length));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement el = psiElement2;
        if (el.getTextRange().getEndOffset() < range.getEndOffset()) {
            return null;
        }
        return (T)el;
    }

    private final boolean isInsideLiteral(PsiFile file2, TextRange range) {
        Class[] classArray = new Class[]{PyLiteralExpression.class, PsiComment.class};
        return this.getContainingElement(file2, range, classArray) != null;
    }

    private final boolean startsWithKeyword(String $this$startsWithKeyword, String ... keywords) {
        for (String keyword : keywords) {
            if (!StringsKt.startsWith$default((String)$this$startsWithKeyword, (String)keyword, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private final String calculateDeindent(List<String> filteredLines, String indentUnit, Map<Class<? extends PyStatement>, String> containerIndents) {
        String string = (String)CollectionsKt.firstOrNull(filteredLines);
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return null;
        }
        String firstLine = string;
        Object object = new String[]{"class"};
        if (this.startsWithKeyword(firstLine, (String)object)) {
            object = containerIndents.get(PyClass.class);
            if (object != null) {
                String[] it = object;
                boolean bl = false;
                return it;
            }
            object = containerIndents.get(PyFunction.class);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        }
        if (this.startsWithKeyword(firstLine, (String)(object = new String[]{"def"}))) {
            object = containerIndents.get(PyFunction.class);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            object = containerIndents.get(PyClass.class);
            if (object != null) {
                String[] it = object;
                boolean bl = false;
                return (String)it + indentUnit;
            }
        }
        object = new String[]{"else", "elif"};
        if (this.startsWithKeyword(firstLine, (String)object) && (object = containerIndents.get(PyStatementWithElse.class)) != null) {
            String[] it = object;
            boolean bl = false;
            return it;
        }
        object = new String[]{"catch", "finally"};
        if (this.startsWithKeyword(firstLine, (String)object) && (object = containerIndents.get(PyTryExceptStatement.class)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final PsiElement selfOrParentOfType(PsiElement psiElement, Class<? extends PsiElement> ... classes2) {
        int n = classes2.length;
        for (int i = 0; i < n; ++i) {
            Class<? extends PsiElement> c = classes2[i];
            if (!c.isInstance(psiElement)) continue;
            return psiElement;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])Arrays.copyOf(classes2, classes2.length));
    }

    private final String calculateRestIndent(String firstLine, String indent, String currentRestIndent, String indentUnit) {
        boolean shouldIndentLess;
        String originalFirstLineIndent = this.getLineIndent(firstLine);
        boolean bl = shouldIndentLess = currentRestIndent.length() < this.getLineIndent(firstLine).length();
        if (shouldIndentLess) {
            String delta = StringsKt.removePrefix((String)originalFirstLineIndent, (CharSequence)currentRestIndent);
            return StringsKt.removePrefix((String)indent, (CharSequence)delta);
        }
        boolean shouldIndentMore = StringsKt.endsWith$default((String)firstLine, (String)":", (boolean)false, (int)2, null);
        return shouldIndentMore ? indent + indentUnit : indent;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getMatcher$lambda$4(String $textBefore, boolean $lastLineDeindented, PythonIndentMatcherProvider this$0, String $indentUnit, Map $containerIndents, String $indent, String $lastLineBefore, boolean $textAfterStartsNL, String $indentAfter, String response2) {
        Object firstLine;
        Object object;
        String adjustedIndent;
        String responseSuffix;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        Iterable $this$filter$iv = StringsKt.lines((CharSequence)response2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredLines = (List)destination$iv$iv;
        boolean doesStartNewLine = StringsKt.startsWith$default((String)response2, (String)"\n", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$textBefore, (String)"\n", (boolean)false, (int)2, null);
        String responsePrefix = StringsKt.startsWith$default((String)response2, (String)"\n", (boolean)false, (int)2, null) ? "\n" : "";
        String string = responseSuffix = StringsKt.endsWith$default((String)response2, (String)"\n", (boolean)false, (int)2, null) ? "\n" : "";
        if (doesStartNewLine || $lastLineDeindented) {
            v2 = this$0.calculateDeindent(filteredLines, $indentUnit, $containerIndents);
            if (v2 == null) {
                v2 = $indent;
            }
        } else {
            v2 = adjustedIndent = $indent;
        }
        if (doesStartNewLine) {
            String string2 = (String)CollectionsKt.firstOrNull((List)filteredLines);
            object = Intrinsics.areEqual((Object)(string2 != null ? this$0.getLineIndent(string2) : null), (Object)adjustedIndent) ? response2 : StringsKt.replaceIndent((String)response2, (String)adjustedIndent);
        } else if (Intrinsics.areEqual((Object)this$0.getLineIndent(response2), (Object)adjustedIndent) && StringsKt.isBlank((CharSequence)$lastLineBefore)) {
            object = StringsKt.removePrefix((String)response2, (CharSequence)$lastLineBefore);
        } else {
            firstLine = (String)CollectionsKt.firstOrNull((List)filteredLines);
            if (firstLine == null) {
                object = response2;
            } else {
                Object firstLineAdjusted = StringsKt.isBlank((CharSequence)$lastLineBefore) ? StringsKt.replaceIndent((String)firstLine, (String)adjustedIndent) : firstLine;
                String prefixToRemove = StringsKt.isBlank((CharSequence)$lastLineBefore) ? $lastLineBefore : "";
                String rest = StringsKt.substringAfter((String)response2, (String)((String)firstLine + "\n"), (String)"");
                if (prefixToRemove.length() > this$0.getLineIndent((String)firstLineAdjusted).length()) {
                    responsePrefix = this$0.ensureSuffix(responsePrefix, "\n");
                }
                if (StringsKt.isBlank((CharSequence)rest)) {
                    object = StringsKt.removePrefix((String)firstLineAdjusted, (CharSequence)prefixToRemove);
                } else {
                    String restIndent = this$0.calculateRestIndent((String)firstLine, adjustedIndent, this$0.getMinIndent(rest), $indentUnit);
                    object = StringsKt.removePrefix((String)firstLineAdjusted, (CharSequence)prefixToRemove) + "\n" + StringsKt.replaceIndent((String)rest, (String)restIndent);
                }
            }
        }
        firstLine = new char[1];
        firstLine[0] = 10;
        String formattedResponse = StringsKt.trim((String)object, (char[])firstLine);
        String responseWthNLs = responsePrefix + formattedResponse + responseSuffix;
        String suffixNormalized = $textAfterStartsNL ? responseWthNLs : this$0.ensureSuffix(responseWthNLs, "\n") + $indentAfter;
        return suffixNormalized;
    }
}

