/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.csharp.debug;

import com.intellij.ide.ui.text.StyledTextPane;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.ml.llm.core.AIAssistantBrandingIcons;
import com.intellij.ml.llm.rider.csharp.RiderLLMBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebuggerDescriptionComponentProvider;
import com.intellij.xdebugger.impl.frame.XDebuggerExecutionStackDescription;
import com.intellij.xdebugger.impl.frame.XDebuggerExecutionStackDescriptionService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0015\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\f\u001aZ\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0011 \u000f*\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010 \u000f*,\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0011 \u000f*\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010\u0018\u00010\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/rider/csharp/debug/RiderDescriptionComponentProvider;", "Lcom/intellij/xdebugger/impl/frame/XDebuggerDescriptionComponentProvider;", "sessionProxy", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "viewDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;Lcom/intellij/openapi/Disposable;)V", "getSessionProxy", "()Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "myCurrentDescriptionComponentLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "descriptionCalculationMap", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/xdebugger/impl/frame/XDebuggerExecutionStackDescription;", "", "clear", "", "currentDescriptionComponent", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Ljavax/swing/JComponent;", "getCurrentDescriptionComponent", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "setPaneText", "pane", "Lcom/intellij/ide/ui/text/StyledTextPane;", "text", "", "onExecutionStackSelected", "stack", "requestDescription", "executionStack", "requestDescription$intellij_ml_llm_rider_csharp", "intellij.ml.llm.rider.csharp"})
@SourceDebugExtension(value={"SMAP\nRiderDescriptionComponentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDescriptionComponentProvider.kt\ncom/intellij/ml/llm/rider/csharp/debug/RiderDescriptionComponentProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 TextPart.kt\ncom/intellij/ide/ui/text/parts/TextPart\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,107:1\n216#2,2:108\n34#3,2:110\n30#4,2:112\n30#4,2:114\n382#5,7:116\n*S KotlinDebug\n*F\n+ 1 RiderDescriptionComponentProvider.kt\ncom/intellij/ml/llm/rider/csharp/debug/RiderDescriptionComponentProvider\n*L\n42#1:108,2\n50#1:110,2\n57#1:112,2\n100#1:114,2\n103#1:116,7\n*E\n"})
public final class RiderDescriptionComponentProvider
implements XDebuggerDescriptionComponentProvider {
    @NotNull
    private final XDebugSessionProxy sessionProxy;
    @NotNull
    private final SequentialLifetimes myCurrentDescriptionComponentLifetime;
    private final Map<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> descriptionCalculationMap;
    @NotNull
    private final MutableStateFlow<JComponent> currentDescriptionComponent;

    public RiderDescriptionComponentProvider(@NotNull XDebugSessionProxy sessionProxy, @NotNull Disposable viewDisposable) {
        Intrinsics.checkNotNullParameter((Object)sessionProxy, (String)"sessionProxy");
        Intrinsics.checkNotNullParameter((Object)viewDisposable, (String)"viewDisposable");
        this.sessionProxy = sessionProxy;
        this.myCurrentDescriptionComponentLifetime = new SequentialLifetimes(LifetimeDisposableExKt.createLifetime((Disposable)viewDisposable));
        this.descriptionCalculationMap = Collections.synchronizedMap(new LinkedHashMap());
        this.currentDescriptionComponent = StateFlowKt.MutableStateFlow(null);
    }

    @NotNull
    public final XDebugSessionProxy getSessionProxy() {
        return this.sessionProxy;
    }

    public void clear() {
        Map<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> map2 = this.descriptionCalculationMap;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"descriptionCalculationMap");
        Map<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> element$iv;
            Map.Entry<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> entry = element$iv = iterator.next();
            boolean bl = false;
            CompletableFuture<XDebuggerExecutionStackDescription> future = entry.getValue();
            future.cancel(true);
        }
        this.descriptionCalculationMap.clear();
    }

    @NotNull
    public MutableStateFlow<JComponent> getCurrentDescriptionComponent() {
        return this.currentDescriptionComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final void setPaneText(StyledTextPane pane2, @Nls String text2) {
        void $this$setPaneText_u24lambda_u240;
        RegularTextPart regularTextPart;
        RegularTextPart regularTextPart2 = regularTextPart = new RegularTextPart(text2, false, 2, null);
        StyledTextPane styledTextPane = pane2;
        boolean bl = false;
        TextPart this_$iv = (TextPart)$this$setPaneText_u24lambda_u240;
        boolean $i$f$editAttributes = false;
        SimpleAttributeSet $this$setPaneText_u24lambda_u240_u240 = this_$iv.getAttributes();
        boolean bl2 = false;
        StyleConstants.setForeground($this$setPaneText_u24lambda_u240_u240, NamedColorUtil.getInactiveTextColor());
        List list = CollectionsKt.listOf((Object)regularTextPart);
        styledTextPane.setParagraphs(CollectionsKt.listOf((Object)new TextParagraph(list)));
    }

    public void onExecutionStackSelected(@NotNull XExecutionStack stack, @NotNull XDebugSessionProxy sessionProxy) {
        ActionLink actionLink;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)sessionProxy, (String)"sessionProxy");
        ComponentManager $this$service$iv = (ComponentManager)sessionProxy.getProject();
        boolean $i$f$service = false;
        Class<XDebuggerExecutionStackDescriptionService> serviceClass$iv = XDebuggerExecutionStackDescriptionService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        XDebuggerExecutionStackDescriptionService descriptionService = (XDebuggerExecutionStackDescriptionService)object;
        if (!descriptionService.isAvailable()) {
            this.getCurrentDescriptionComponent().setValue(null);
            return;
        }
        CompletableFuture<XDebuggerExecutionStackDescription> descriptionFuture = this.descriptionCalculationMap.get(stack);
        LifetimeDefinition nextLifetime = this.myCurrentDescriptionComponentLifetime.next();
        if (descriptionFuture != null) {
            StyledTextPane styledTextPane;
            StyledTextPane $this$onExecutionStackSelected_u24lambda_u240 = styledTextPane = new StyledTextPane();
            boolean bl = false;
            Disposer.register((Disposable)LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)((Lifetime)nextLifetime), null, (int)1, null), (Disposable)((Disposable)$this$onExecutionStackSelected_u24lambda_u240));
            $this$onExecutionStackSelected_u24lambda_u240.setBackground(JBUI.CurrentTheme.ToolWindow.background());
            StyledTextPane pane2 = styledTextPane;
            String string = XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.setPaneText(pane2, string);
            descriptionFuture.whenCompleteAsync((arg_0, arg_1) -> RiderDescriptionComponentProvider.onExecutionStackSelected$lambda$2((arg_0, arg_1) -> RiderDescriptionComponentProvider.onExecutionStackSelected$lambda$1(this, pane2, arg_0, arg_1), arg_0, arg_1), (Executor)EdtExecutorService.getInstance());
            this.getCurrentDescriptionComponent().setValue((Object)pane2);
            return;
        }
        ActionLink $this$onExecutionStackSelected_u24lambda_u244 = actionLink = new ActionLink(RiderLLMBundle.message("llm.rider.debugger.what.does.this.thread.do.message", new Object[0]), arg_0 -> RiderDescriptionComponentProvider.onExecutionStackSelected$lambda$3(this, stack, sessionProxy, arg_0));
        boolean bl = false;
        $this$onExecutionStackSelected_u24lambda_u244.setIcon(AIAssistantBrandingIcons.Logo16);
        ActionLink actionLink2 = actionLink;
        this.getCurrentDescriptionComponent().setValue((Object)actionLink2);
    }

    /*
     * WARNING - void declaration
     */
    public final void requestDescription$intellij_ml_llm_rider_csharp(@NotNull XExecutionStack executionStack) {
        block2: {
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)executionStack, (String)"executionStack");
            Object $this$service$iv = (ComponentManager)this.sessionProxy.getProject();
            boolean $i$f$service = false;
            Class<XDebuggerExecutionStackDescriptionService> serviceClass$iv = XDebuggerExecutionStackDescriptionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            XDebuggerExecutionStackDescriptionService descriptionService = (XDebuggerExecutionStackDescriptionService)object;
            if (!descriptionService.isAvailable()) {
                return;
            }
            Map<XExecutionStack, CompletableFuture<XDebuggerExecutionStackDescription>> map2 = this.descriptionCalculationMap;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"descriptionCalculationMap");
            $this$service$iv = map2;
            XExecutionStack key$iv = executionStack;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv != null) break block2;
            boolean bl = false;
            CompletableFuture answer$iv = FutureKt.asCompletableFuture((Deferred)descriptionService.getExecutionStackDescription(executionStack, this.sessionProxy));
            $this$getOrPut$iv.put(key$iv, answer$iv);
        }
    }

    private static final Unit onExecutionStackSelected$lambda$1(RiderDescriptionComponentProvider this$0, StyledTextPane $pane, XDebuggerExecutionStackDescription description, Throwable exception) {
        if (exception != null) {
            String string = XDebuggerBundle.message((String)"xdebugger.execution.stack.description.not.available.message", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this$0.setPaneText($pane, string);
            return Unit.INSTANCE;
        }
        this$0.setPaneText($pane, description.getLongDescription());
        $pane.revalidate();
        $pane.revalidate();
        return Unit.INSTANCE;
    }

    private static final void onExecutionStackSelected$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void onExecutionStackSelected$lambda$3(RiderDescriptionComponentProvider this$0, XExecutionStack $stack, XDebugSessionProxy $sessionProxy, ActionEvent it) {
        this$0.requestDescription$intellij_ml_llm_rider_csharp($stack);
        this$0.onExecutionStackSelected($stack, $sessionProxy);
    }
}

