/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rider.csharp.errorExplanation;

import com.intellij.ml.llm.errorExplanation.filters.ExceptionRange;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002J\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/rider/csharp/errorExplanation/DotnetExceptionPostprocessor;", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "<init>", "()V", "tracePattern", "Lkotlin/text/Regex;", "isTraceLine", "", "", "getLineRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/Document;", "line", "", "getNewRange", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRange;", "oldRange", "postprocess", "consoleDocument", "oldExceptionRange", "Companion", "intellij.ml.llm.rider.csharp"})
public final class DotnetExceptionPostprocessor
extends ExceptionRangePostprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex tracePattern = new Regex("(^\\s*(at|\u0432|bei|en|kohteessa|\u5834\u6240|\u5728)\\s(?:(?<namespace>[\\p{L}\\d_.]*)\\.)?(?<class>[\\p{L}\\d_.+`]*(\\.[\\p{L}\\d_.+<>`]+)?)\\.(?<method>[\\p{L}\\d_\\[\\]<>`]*)\\s*\\((?:(?<parameter>[\\p{L}\\d`_.]+(?:\\[]|&|\\*)? [\\p{L}\\d_]+)(?:, )?)*\\))|(^\\s*--->)|(^\\s*--- End of inner exception stack trace ---)");
    @NotNull
    public static final String TRACE_LINE_PREFIX = "^\\s*(at|\u0432|bei|en|kohteessa|\u5834\u6240|\u5728)";
    @NotNull
    public static final String TRACE_LINE = "(?:(?<namespace>[\\p{L}\\d_.]*)\\.)?(?<class>[\\p{L}\\d_.+`]*(\\.[\\p{L}\\d_.+<>`]+)?)\\.(?<method>[\\p{L}\\d_\\[\\]<>`]*)\\s*\\((?:(?<parameter>[\\p{L}\\d`_.]+(?:\\[]|&|\\*)? [\\p{L}\\d_]+)(?:, )?)*\\)";
    @NotNull
    public static final String TRACE_INNER_BEGIN = "^\\s*--->";
    @NotNull
    public static final String TRACE_INNER_END = "^\\s*--- End of inner exception stack trace ---";

    private final boolean isTraceLine(String $this$isTraceLine) {
        return this.tracePattern.containsMatchIn((CharSequence)$this$isTraceLine);
    }

    private final TextRange getLineRange(Document $this$getLineRange, int line) {
        return new TextRange($this$getLineRange.getLineStartOffset(line), $this$getLineRange.getLineEndOffset(line));
    }

    private final ExceptionRange getNewRange(Document $this$getNewRange, ExceptionRange oldRange) {
        int line;
        int maxLine = $this$getNewRange.getLineCount();
        for (line = $this$getNewRange.getLineNumber(oldRange.getStartOffset()) + 1; line < maxLine; ++line) {
            String string = $this$getNewRange.getText(this.getLineRange($this$getNewRange, line));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!this.isTraceLine(string)) break;
        }
        return new ExceptionRange(oldRange.getStartOffset(), Integer.valueOf($this$getNewRange.getLineEndOffset(line - 1)));
    }

    @NotNull
    public ExceptionRange postprocess(@NotNull Document consoleDocument, @NotNull ExceptionRange oldExceptionRange) {
        Intrinsics.checkNotNullParameter((Object)consoleDocument, (String)"consoleDocument");
        Intrinsics.checkNotNullParameter((Object)oldExceptionRange, (String)"oldExceptionRange");
        return this.getNewRange(consoleDocument, oldExceptionRange);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/rider/csharp/errorExplanation/DotnetExceptionPostprocessor$Companion;", "", "<init>", "()V", "TRACE_LINE_PREFIX", "", "TRACE_LINE", "TRACE_INNER_BEGIN", "TRACE_INNER_END", "intellij.ml.llm.rider.csharp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

