/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.listeners;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.history.ActivityId;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateFileChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.integration.CommonActivity;
import com.intellij.ml.llm.riderNext.latest.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.ChroniclesEvents;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.mergeableEvents.ChronicleEventFile;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.mergeableEvents.ChronicleEventFileContentTrigger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesLocalHistoryListener;", "Lcom/intellij/history/core/LocalHistoryFacade$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "changeSetFinished", "", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "handleChangeSets", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChroniclesLocalHistoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChroniclesLocalHistoryListener.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesLocalHistoryListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n1869#2,2:72\n13#3:74\n*S KotlinDebug\n*F\n+ 1 ChroniclesLocalHistoryListener.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesLocalHistoryListener\n*L\n52#1:72,2\n16#1:74\n*E\n"})
public final class ChroniclesLocalHistoryListener
extends LocalHistoryFacade.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public static final int $stable = 8;
    @NotNull
    private static final Logger log;

    public ChroniclesLocalHistoryListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void changeSetFinished(@NotNull ChangeSet changeSet) {
        Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return;
        }
        try {
            this.handleChangeSets(changeSet);
        }
        catch (ProcessCanceledException pcs) {
            throw pcs;
        }
        catch (Throwable e) {
            log.error("Failed to handle change set", e);
        }
    }

    private final void handleChangeSets(ChangeSet changeSet) {
        String providerId;
        if (Intrinsics.areEqual((Object)changeSet.getActivityId(), (Object)CommonActivity.ExternalChange)) {
            List list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChanges(...)");
            if (((Collection)list).size() > 10) {
                return;
            }
        }
        ChroniclesEvents events = ChroniclesEvents.Companion.getInstance(this.project);
        changeSet.getActivityId();
        ActivityId activityId = changeSet.getActivityId();
        String string = providerId = activityId != null ? activityId.getProviderId() : null;
        if (Intrinsics.areEqual((Object)providerId, (Object)"Git") || Intrinsics.areEqual((Object)providerId, (Object)"Vcs")) {
            return;
        }
        List list = changeSet.getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChanges(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Change change = (Change)element$iv;
            boolean bl = false;
            Change change2 = change;
            if (change2 instanceof CreateFileChange) {
                String string2 = ((CreateFileChange)change).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                events.add(new ChronicleEventFile(string2, ChronicleEventFile.Kind.NewFile.INSTANCE, changeSet.getName()));
                continue;
            }
            if (change2 instanceof DeleteChange) {
                String string3 = ((DeleteChange)change).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                events.add(new ChronicleEventFile(string3, ChronicleEventFile.Kind.DeleteFile.INSTANCE, changeSet.getName()));
                continue;
            }
            if (!(change2 instanceof ContentChange)) continue;
            events.add(new ChronicleEventFileContentTrigger());
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChroniclesLocalHistoryListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/events/listeners/ChroniclesLocalHistoryListener$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.riderNext.latest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

