/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.events.storage;

import com.intellij.ml.llm.riderNext.latest.chronicles.ChronicleEntry;
import com.intellij.ml.llm.riderNext.latest.chronicles.ChroniclePath;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\t"}, d2={"fromCsv", "Lkotlin/Result;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry;", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry$Companion;", "csvLine", "", "", "(Lcom/intellij/ml/llm/riderNext/latest/chronicles/ChronicleEntry$Companion;Ljava/util/List;)Ljava/lang/Object;", "toCsv", "intellij.ml.llm.riderNext.latest"})
public final class ChroniclesEventExtensionsKt {
    @NotNull
    public static final Object fromCsv(@NotNull ChronicleEntry.Companion $this$fromCsv, @NotNull List<String> csvLine) {
        ChronicleEntry chronicleEntry;
        Object e2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fromCsv, (String)"<this>");
        Intrinsics.checkNotNullParameter(csvLine, (String)"csvLine");
        if (csvLine.size() < 4) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid csv line length: " + csvLine.size())));
        }
        Long l = StringsKt.toLongOrNull((String)csvLine.get(0));
        if (l == null) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid timestamp: " + csvLine.get(0))));
        }
        long timestamp = l;
        String type2 = csvLine.get(1);
        String caption = csvLine.get(2);
        String payload = csvLine.get(3);
        String extra = (String)CollectionsKt.getOrNull(csvLine, (int)4);
        Base64.Default base64 = Base64.Default;
        try {
            object = Base64.decode$default((Base64)((Base64)base64), (CharSequence)caption, (int)0, (int)0, (int)6, null);
            object = new String((byte[])object, Charsets.UTF_8);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e2) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode base64 caption: " + caption + ", error: " + e2.getMessage())));
        }
        Object captionDecoded = object;
        try {
            e2 = Base64.decode$default((Base64)((Base64)base64), (CharSequence)payload, (int)0, (int)0, (int)6, null);
            e2 = new String((byte[])e2, Charsets.UTF_8);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e3) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Failed to decode base64 caption: " + caption + ", error: " + e3.getMessage())));
        }
        Object payloadDecoded = e2;
        String string = type2;
        if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FileSwitch.class.getSimpleName())) {
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            ChroniclePath path = chroniclePath;
            chronicleEntry = new ChronicleEntry.FileSwitch(path, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindInFile.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FindInFile((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindInPath.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.FindInPath((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.FindUsages.class.getSimpleName())) {
            String string2 = extra;
            chronicleEntry = new ChronicleEntry.FindUsages((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), string2 != null ? StringsKt.toIntOrNull((String)string2) : null, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.GotoDeclaration.class.getSimpleName())) {
            String string3 = extra;
            chronicleEntry = new ChronicleEntry.GotoDeclaration((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), string3 != null ? StringsKt.toIntOrNull((String)string3) : null, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Idle.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Idle(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Run.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Run((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Shutdown.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Shutdown(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Startup.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Startup(timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Tests.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.Tests((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DocumentChange.class.getSimpleName())) {
            if (extra == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Missing extra for DocumentChange event")));
            }
            Long l2 = StringsKt.toLongOrNull((String)extra);
            if (l2 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid extra for DocumentChange event: " + extra)));
            }
            long duration2 = l2;
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            path = chroniclePath;
            chronicleEntry = new ChronicleEntry.DocumentChange(path, (String)payloadDecoded, duration2, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointSet.class.getSimpleName())) {
            String string4 = extra;
            chronicleEntry = new ChronicleEntry.BreakpointSet((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), string4 != null ? StringsKt.toIntOrNull((String)string4) : null, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointRemoved.class.getSimpleName())) {
            String string5 = extra;
            chronicleEntry = new ChronicleEntry.BreakpointRemoved((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), string5 != null ? StringsKt.toIntOrNull((String)string5) : null, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BreakpointHit.class.getSimpleName())) {
            String string6 = extra;
            chronicleEntry = new ChronicleEntry.BreakpointHit((String)captionDecoded, ChroniclePath.Companion.createUnsafe((String)payloadDecoded), string6 != null ? StringsKt.toIntOrNull((String)string6) : null, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DebugStart.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.DebugStart((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DebugStop.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.DebugStop((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildStart.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildStart((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildSuccess.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildSuccess((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.BuildFailed.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.BuildFailed((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.NewFile.class.getSimpleName())) {
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            ChroniclePath path = chroniclePath;
            chronicleEntry = new ChronicleEntry.NewFile(path, extra, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.DeleteFile.class.getSimpleName())) {
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            ChroniclePath path = chroniclePath;
            chronicleEntry = new ChronicleEntry.DeleteFile(path, extra, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.MoveFile.class.getSimpleName())) {
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            ChroniclePath from = chroniclePath;
            ChroniclePath chroniclePath2 = ChroniclePath.Companion.createUnsafe((String)payloadDecoded);
            if (chroniclePath2 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)payloadDecoded)));
            }
            to = chroniclePath2;
            chronicleEntry = new ChronicleEntry.MoveFile(from, to, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.CopyFile.class.getSimpleName())) {
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            ChroniclePath from = chroniclePath;
            ChroniclePath chroniclePath3 = ChroniclePath.Companion.createUnsafe((String)payloadDecoded);
            if (chroniclePath3 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)payloadDecoded)));
            }
            to = chroniclePath3;
            chronicleEntry = new ChronicleEntry.CopyFile(from, to, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.ChangeBranches.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.ChangeBranches((String)captionDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.AiCodeGeneration.class.getSimpleName())) {
            chronicleEntry = new ChronicleEntry.AiCodeGeneration((String)captionDecoded, (String)payloadDecoded, timestamp);
        } else if (Intrinsics.areEqual((Object)string, (Object)ChronicleEntry.Scroll.class.getSimpleName())) {
            if (extra == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Missing extra for Scroll event")));
            }
            Long l3 = StringsKt.toLongOrNull((String)extra);
            if (l3 == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid extra for Scroll event: " + extra)));
            }
            long duration3 = l3;
            ChroniclePath chroniclePath = ChroniclePath.Companion.createUnsafe((String)captionDecoded);
            if (chroniclePath == null) {
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Invalid path: " + (String)captionDecoded)));
            }
            path = chroniclePath;
            chronicleEntry = new ChronicleEntry.Scroll(path, duration3, timestamp);
        } else {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Unknown event type: " + type2)));
        }
        ChronicleEntry event2 = chronicleEntry;
        return Result.constructor-impl((Object)event2);
    }

    @NotNull
    public static final String toCsv(@NotNull ChronicleEntry $this$toCsv) {
        Object object;
        Object object2;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toCsv, (String)"<this>");
        Base64.Default base64 = Base64.Default;
        String type2 = $this$toCsv.getClass().getSimpleName();
        ChronicleEntry chronicleEntry = $this$toCsv;
        if (chronicleEntry instanceof ChronicleEntry.FileSwitch) {
            string = ((Object)((ChronicleEntry.FileSwitch)$this$toCsv).getPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.FindInFile) {
            string = ((ChronicleEntry.FindInFile)$this$toCsv).getSearchPattern();
        } else if (chronicleEntry instanceof ChronicleEntry.FindInPath) {
            string = ((ChronicleEntry.FindInPath)$this$toCsv).getSearchPattern();
        } else if (chronicleEntry instanceof ChronicleEntry.FindUsages) {
            string = ((ChronicleEntry.FindUsages)$this$toCsv).getToken();
        } else if (chronicleEntry instanceof ChronicleEntry.GotoDeclaration) {
            string = ((ChronicleEntry.GotoDeclaration)$this$toCsv).getToken();
        } else if (chronicleEntry instanceof ChronicleEntry.Idle) {
            string = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Run) {
            string = ((ChronicleEntry.Run)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.Shutdown) {
            string = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Startup) {
            string = "";
        } else if (chronicleEntry instanceof ChronicleEntry.Tests) {
            string = ((ChronicleEntry.Tests)$this$toCsv).getOverview();
        } else if (chronicleEntry instanceof ChronicleEntry.DocumentChange) {
            string = ((Object)((ChronicleEntry.DocumentChange)$this$toCsv).getPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointSet) {
            string = ((ChronicleEntry.BreakpointSet)$this$toCsv).getDisplayText();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointRemoved) {
            string = ((ChronicleEntry.BreakpointRemoved)$this$toCsv).getDisplayText();
        } else if (chronicleEntry instanceof ChronicleEntry.BreakpointHit) {
            string = ((ChronicleEntry.BreakpointHit)$this$toCsv).getMessage();
        } else if (chronicleEntry instanceof ChronicleEntry.DebugStart) {
            string = ((ChronicleEntry.DebugStart)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.DebugStop) {
            string = ((ChronicleEntry.DebugStop)$this$toCsv).getConfigName();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildStart) {
            string = ((ChronicleEntry.BuildStart)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildSuccess) {
            string = ((ChronicleEntry.BuildSuccess)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.BuildFailed) {
            string = ((ChronicleEntry.BuildFailed)$this$toCsv).getRunConfiguration();
        } else if (chronicleEntry instanceof ChronicleEntry.Scroll) {
            string = ((Object)((ChronicleEntry.Scroll)$this$toCsv).getPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.ChangeBranches) {
            string = ((ChronicleEntry.ChangeBranches)$this$toCsv).getBranchName();
        } else if (chronicleEntry instanceof ChronicleEntry.NewFile) {
            string = ((Object)((ChronicleEntry.NewFile)$this$toCsv).getPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.DeleteFile) {
            string = ((Object)((ChronicleEntry.DeleteFile)$this$toCsv).getPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.MoveFile) {
            string = ((Object)((ChronicleEntry.MoveFile)$this$toCsv).getFromPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.CopyFile) {
            string = ((Object)((ChronicleEntry.CopyFile)$this$toCsv).getFromPath().getRelativePath()).toString();
        } else if (chronicleEntry instanceof ChronicleEntry.AiCodeGeneration) {
            string = ((ChronicleEntry.AiCodeGeneration)$this$toCsv).getSummary();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String captionRaw = string;
        Base64 base642 = (Base64)base64;
        String string2 = captionRaw;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String captionBase64 = Base64.encode$default((Base64)base642, (byte[])byArray, (int)0, (int)0, (int)6, null);
        ChronicleEntry chronicleEntry2 = $this$toCsv;
        if (chronicleEntry2 instanceof ChronicleEntry.FileSwitch) {
            object2 = ((ChronicleEntry.FileSwitch)$this$toCsv).getPosition();
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindInFile) {
            object2 = ((ChronicleEntry.FindInFile)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindInPath) {
            object2 = ((ChronicleEntry.FindInPath)$this$toCsv).getDirectoryName();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.FindUsages) {
            object2 = ((ChronicleEntry.FindUsages)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.GotoDeclaration) {
            object2 = ((ChronicleEntry.GotoDeclaration)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.Idle) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Run) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Shutdown) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Startup) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.Tests) {
            object2 = ((ChronicleEntry.Tests)$this$toCsv).getDetails();
        } else if (chronicleEntry2 instanceof ChronicleEntry.DocumentChange) {
            object2 = ((ChronicleEntry.DocumentChange)$this$toCsv).getDiff();
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointSet) {
            object2 = ((ChronicleEntry.BreakpointSet)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointRemoved) {
            object2 = ((ChronicleEntry.BreakpointRemoved)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.BreakpointHit) {
            object2 = ((ChronicleEntry.BreakpointHit)$this$toCsv).getPath();
            if (object2 == null || (object2 = ((ChroniclePath)object2).getRelativePath()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
        } else if (chronicleEntry2 instanceof ChronicleEntry.DebugStart) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.DebugStop) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildStart) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildSuccess) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.BuildFailed) {
            object2 = ((ChronicleEntry.BuildFailed)$this$toCsv).getReason();
        } else if (chronicleEntry2 instanceof ChronicleEntry.Scroll) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.ChangeBranches) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.NewFile) {
            object2 = ((ChronicleEntry.NewFile)$this$toCsv).getContent();
        } else if (chronicleEntry2 instanceof ChronicleEntry.DeleteFile) {
            object2 = "";
        } else if (chronicleEntry2 instanceof ChronicleEntry.MoveFile) {
            object2 = ((Object)((ChronicleEntry.MoveFile)$this$toCsv).getToPath().getRelativePath()).toString();
        } else if (chronicleEntry2 instanceof ChronicleEntry.CopyFile) {
            object2 = ((Object)((ChronicleEntry.CopyFile)$this$toCsv).getToPath().getRelativePath()).toString();
        } else if (chronicleEntry2 instanceof ChronicleEntry.AiCodeGeneration) {
            object2 = ((ChronicleEntry.AiCodeGeneration)$this$toCsv).getDiff();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String payloadRaw = object2;
        Base64 base643 = (Base64)base64;
        String string3 = payloadRaw;
        byte[] byArray2 = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        String payloadBase64 = Base64.encode$default((Base64)base643, (byte[])byArray2, (int)0, (int)0, (int)6, null);
        ChronicleEntry chronicleEntry3 = $this$toCsv;
        if (chronicleEntry3 instanceof ChronicleEntry.DocumentChange) {
            object = String.valueOf(((ChronicleEntry.DocumentChange)$this$toCsv).getDurationMs());
        } else if (chronicleEntry3 instanceof ChronicleEntry.Scroll) {
            object = String.valueOf(((ChronicleEntry.Scroll)$this$toCsv).getDurationMs());
        } else if (chronicleEntry3 instanceof ChronicleEntry.NewFile) {
            object = ((ChronicleEntry.NewFile)$this$toCsv).getCommand();
        } else if (chronicleEntry3 instanceof ChronicleEntry.DeleteFile) {
            object = ((ChronicleEntry.DeleteFile)$this$toCsv).getCommand();
        } else if (chronicleEntry3 instanceof ChronicleEntry.BreakpointSet) {
            object = ((ChronicleEntry.BreakpointSet)$this$toCsv).getLine();
            if (object == null || (object = String.valueOf((Integer)object)) == null) {
                object = "";
            }
        } else if (chronicleEntry3 instanceof ChronicleEntry.BreakpointRemoved) {
            object = ((ChronicleEntry.BreakpointRemoved)$this$toCsv).getLine();
            if (object == null || (object = String.valueOf((Integer)object)) == null) {
                object = "";
            }
        } else if (chronicleEntry3 instanceof ChronicleEntry.BreakpointHit) {
            object = ((ChronicleEntry.BreakpointHit)$this$toCsv).getLine();
            if (object == null || (object = String.valueOf((Integer)object)) == null) {
                object = "";
            }
        } else {
            object = chronicleEntry3 instanceof ChronicleEntry.FindUsages ? String.valueOf(((ChronicleEntry.FindUsages)$this$toCsv).getOffset()) : (chronicleEntry3 instanceof ChronicleEntry.GotoDeclaration ? String.valueOf(((ChronicleEntry.GotoDeclaration)$this$toCsv).getOffset()) : "");
        }
        String extra = object;
        return $this$toCsv.getTimestamp() + "," + type2 + "," + captionBase64 + "," + payloadBase64 + "," + extra;
    }
}

