/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import com.intellij.ml.llm.riderNext.latest.LLMRiderNextBundle;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.RecapLLMLog;
import com.intellij.ml.llm.riderNext.latest.chronicles.events.storage.ChroniclesStorage;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapViewState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.text.DateFormatUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"dumpRecap", "", "state", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapViewState;", "project", "Lcom/intellij/openapi/project/Project;", "saveZip", "chroniclesPath", "Ljava/nio/file/Path;", "llmLog", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/ai/RecapLLMLog;", "recapJson", "", "outputZip", "stringToFile", "stream", "Ljava/util/zip/ZipOutputStream;", "string", "fileName", "intellij.ml.llm.riderNext.latest"})
@SourceDebugExtension(value={"SMAP\ndumpRecap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dumpRecap.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/DumpRecapKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n205#2:70\n57#3:71\n35#3,2:72\n*S KotlinDebug\n*F\n+ 1 dumpRecap.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/DumpRecapKt\n*L\n33#1:70\n39#1:71\n39#1:72,2\n*E\n"})
public final class DumpRecapKt {
    /*
     * WARNING - void declaration
     */
    public static final void dumpRecap(@NotNull RecapViewState state2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(LLMRiderNextBundle.message("recap.dump", new Object[0]), LLMRiderNextBundle.message("recap.dump.info", new Object[0]), "zip");
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project2);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog dialog2 = fileSaverDialog;
        String filename = "recap_" + project2.getName() + "_" + DateFormatUtil.formatDateTime((long)Clock.getTime()) + ".zip";
        VirtualFileWrapper wrapper = dialog2.save(filename);
        if (wrapper != null) {
            void this_$iv;
            Path target = wrapper.getFile().toPath();
            Path chroniclesPath = ChroniclesStorage.Companion.getInstance(project2).getCsvPath();
            RecapLLMLog llmLog = state2.getAgentResult().getLog();
            Json json = (Json)Json.Default;
            RecapViewState value$iv = state2;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String results2 = this_$iv.encodeToString((SerializationStrategy)RecapViewState.Companion.serializer(), (Object)value$iv);
            try {
                Intrinsics.checkNotNull((Object)target);
                DumpRecapKt.saveZip(chroniclesPath, llmLog, results2, target);
            }
            catch (Exception e) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to save recap", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveZip(Path chroniclesPath, RecapLLMLog llmLog, String recapJson, Path outputZip) {
        Closeable closeable = new FileOutputStream(outputZip.toFile());
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new ZipOutputStream(fos);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zos = (ZipOutputStream)closeable2;
                boolean bl2 = false;
                String entryName = ((Object)chroniclesPath.getFileName()).toString();
                zos.putNextEntry(new ZipEntry(entryName));
                Closeable closeable3 = new FileInputStream(chroniclesPath.toFile());
                Throwable throwable3 = null;
                try {
                    FileInputStream input2 = (FileInputStream)closeable3;
                    boolean bl3 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)input2, (OutputStream)zos, (int)0, (int)2, null);
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                zos.closeEntry();
                DumpRecapKt.stringToFile(zos, llmLog.getTrack30Min().getChronicles(), "chronicles30min.json");
                DumpRecapKt.stringToFile(zos, llmLog.getTrack30Min().getResponse(), "response30min.json");
                DumpRecapKt.stringToFile(zos, llmLog.getTrack2H().getChronicles(), "chronicles2h.json");
                DumpRecapKt.stringToFile(zos, llmLog.getTrack2H().getResponse(), "response2h.json");
                DumpRecapKt.stringToFile(zos, recapJson, "recap.json");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void stringToFile(ZipOutputStream stream, String string, String fileName) {
        stream.putNextEntry(new ZipEntry(fileName));
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)stream, (int)0, (int)2, null);
        stream.closeEntry();
    }
}

