/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.chronicles.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ide.IdleTracker;
import com.intellij.ml.llm.riderNext.latest.NextRegistryKt;
import com.intellij.ml.llm.riderNext.latest.chronicles.ai.ChroniclesAgentService;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChronicleKind;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenter;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclePresenterParent;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ChroniclesViewService;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapSpentCounter;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapTriggerService;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapUselessUpdatesCounter;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.RecapViewModel;
import com.intellij.ml.llm.riderNext.latest.chronicles.view.ShowRecapGotItKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "activityTrackerJob", "Lkotlinx/coroutines/Job;", "userWasActiveDuringComputation", "", "userActivityTimestamp", "", "Ljava/lang/Long;", "triggerOnIdle", "handleRecapCompletion", "", "chroniclesChanged", "hasSignificantEventsSinceStartup", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRecapTriggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapTriggerService.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n57#2:138\n35#2,2:139\n57#2:141\n35#2,2:142\n57#2:144\n35#2,2:145\n57#2:147\n35#2,2:148\n57#2:150\n35#2,2:151\n57#2:166\n35#2,2:167\n57#2:172\n35#2,2:173\n1374#3:153\n1460#3,5:154\n360#3,7:159\n1761#3,3:169\n*S KotlinDebug\n*F\n+ 1 RecapTriggerService.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService\n*L\n35#1:138\n35#1:139,2\n40#1:141\n40#1:142,2\n83#1:144\n83#1:145,2\n96#1:147\n96#1:148,2\n103#1:150\n103#1:151,2\n124#1:166\n124#1:167,2\n133#1:172\n133#1:173,2\n119#1:153\n119#1:154,5\n122#1:159,7\n129#1:169,3\n*E\n"})
public final class RecapTriggerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job activityTrackerJob;
    private boolean userWasActiveDuringComputation;
    @Nullable
    private Long userActivityTimestamp;
    public static final int $stable = 8;

    public RecapTriggerService(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project2;
        this.scope = scope;
    }

    public final boolean triggerOnIdle() {
        if (!NextRegistryKt.isChroniclesEnabled()) {
            return false;
        }
        if (!ChroniclesAgentService.Companion.isAvailable()) {
            return false;
        }
        if (RecapUselessUpdatesCounter.Companion.getInstance(this.project).getSuspended()) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.trace("Recap trigger suspended");
            return false;
        }
        if (RecapSpentCounter.Companion.getInstance(this.project).isThresholdReached()) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.trace("USD spent threshold reached, skipping recap trigger");
            return false;
        }
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RecapTriggerService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RecapViewModel.Companion.getInstance(RecapTriggerService.access$getProject$p(this.this$0)).isActualRecapCalculating((Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v1 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInstance(...)");
                            v1.debug("Actual recap already calculating, ignoring trigger");
                            return Unit.INSTANCE;
                        }
                        this.label = 2;
                        v2 = RecapTriggerService.access$hasSignificantEventsSinceStartup(this.this$0, (Continuation)this);
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl30:
                        // 2 sources

                        if (!((Boolean)v2).booleanValue()) {
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v3 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                            v3.debug("No significant events since startup, skipping recap trigger");
                            return Unit.INSTANCE;
                        }
                        RecapTriggerService.access$setUserWasActiveDuringComputation$p(this.this$0, false);
                        RecapTriggerService.access$setUserActivityTimestamp$p(this.this$0, null);
                        v4 = RecapTriggerService.access$getActivityTrackerJob$p(this.this$0);
                        if (v4 != null) {
                            Job.DefaultImpls.cancel$default((Job)v4, null, (int)1, null);
                        }
                        RecapTriggerService.access$setActivityTrackerJob$p(this.this$0, BuildersKt.launch$default((CoroutineScope)RecapTriggerService.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ RecapTriggerService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Ref.BooleanRef isFirstEvent = new Ref.BooleanRef();
                                        isFirstEvent.element = true;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)isFirstEvent);
                                        this.label = 1;
                                        Object object2 = IdleTracker.Companion.getInstance().getEvents().collect(new FlowCollector(isFirstEvent, this.this$0){
                                            final /* synthetic */ Ref.BooleanRef $isFirstEvent;
                                            final /* synthetic */ RecapTriggerService this$0;
                                            {
                                                this.$isFirstEvent = $isFirstEvent;
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                                if (this.$isFirstEvent.element) {
                                                    this.$isFirstEvent.element = false;
                                                    return Unit.INSTANCE;
                                                }
                                                if (!RecapTriggerService.access$getUserWasActiveDuringComputation$p(this.this$0)) {
                                                    boolean $i$f$fileLogger = false;
                                                    boolean $i$f$currentClassLogger = false;
                                                    Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                                                    Logger logger = Logger.getInstance(clazz$iv$iv);
                                                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                                    logger.debug("User activity detected during recap computation");
                                                    RecapTriggerService.access$setUserWasActiveDuringComputation$p(this.this$0, true);
                                                    RecapTriggerService.access$setUserActivityTimestamp$p(this.this$0, Boxing.boxLong((long)System.currentTimeMillis()));
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object2 != object) throw new KotlinNothingValueException();
                                        return object;
                                    }
                                    case 1: {
                                        Ref.BooleanRef isFirstEvent = (Ref.BooleanRef)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null));
                        this.label = 3;
                        v5 = RecapViewModel.Companion.getInstance(RecapTriggerService.access$getProject$p(this.this$0)).refreshTriggered((Continuation<? super Boolean>)((Continuation)this));
                        if (v5 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl53
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl53:
                        // 2 sources

                        RecapTriggerService.access$handleRecapCompletion(this.this$0, (chroniclesChanged = ((Boolean)v5).booleanValue()) != false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleRecapCompletion(boolean chroniclesChanged) {
        try {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Recap completion. Chronicles changed: " + chroniclesChanged + ", user was active: " + this.userWasActiveDuringComputation);
            if (chroniclesChanged) {
                return;
            }
            if (this.userWasActiveDuringComputation) {
                long completionTime = System.currentTimeMillis();
                Long activityTime = this.userActivityTimestamp;
                long notificationWindowTimeoutMs = (long)Registry.Companion.intValue("llm.riderNext.recap.timeout.notificationWindow") * 1000L;
                boolean shouldShowNotification = activityTime != null && completionTime - activityTime <= notificationWindowTimeoutMs;
                boolean $i$f$fileLogger2 = false;
                boolean $i$f$currentClassLogger2 = false;
                Class<?> clazz$iv$iv2 = MethodHandles.lookup().lookupClass();
                Logger logger2 = Logger.getInstance(clazz$iv$iv2);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.debug("User was active during computation. Should show notification: " + shouldShowNotification);
                if (shouldShowNotification) {
                    ShowRecapGotItKt.showRecapGotIt(this.project);
                }
            } else {
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger3 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.debug("No user activity detected. Deciding whether to show tool window or notification");
                ShowRecapGotItKt.showRecapGotIt(this.project);
            }
            RecapUselessUpdatesCounter.Companion.getInstance(this.project).onUpdate();
        }
        finally {
            Job job2 = this.activityTrackerJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            this.activityTrackerJob = null;
            this.userWasActiveDuringComputation = false;
            this.userActivityTimestamp = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object hasSignificantEventsSinceStartup(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof hasSignificantEventsSinceStartup.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RecapTriggerService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RecapTriggerService.access$hasSignificantEventsSinceStartup(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = ChroniclesViewService.Companion.getInstance(this.project).reload((Collection)ChronicleKind.getEntries(), (Continuation<? super Unit>)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                $this$flatMap$iv = ChroniclesViewService.Companion.getInstance(this.project).getContent();
                $i$f$flatMap = false;
                var5_10 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (ChroniclePresenterParent)element$iv$iv;
                    $i$a$-flatMap-RecapTriggerService$hasSignificantEventsSinceStartup$chronicles$1 = false;
                    list$iv$iv = it.getLeafs();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$indexOfFirst$iv = chronicles = (List)destination$iv$iv;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    it = (ChroniclePresenter)item$iv;
                    $i$a$-indexOfFirst-RecapTriggerService$hasSignificantEventsSinceStartup$lastStartupIndex$1 = false;
                    if (!(it.getKind() == ChronicleKind.Startup)) ** GOTO lbl41
                    v1 = index$iv;
                    ** GOTO lbl44
lbl41:
                    // 1 sources

                    ++index$iv;
                }
                v1 = lastStartupIndex = -1;
lbl44:
                // 2 sources

                if (lastStartupIndex == -1) {
                    $i$f$fileLogger = false;
                    $i$f$currentClassLogger = false;
                    clazz$iv$iv = MethodHandles.lookup().lookupClass();
                    v2 = Logger.getInstance(clazz$iv$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                    v2.debug("No Startup event found, allowing recap trigger");
                    return Boxing.boxBoolean((boolean)true);
                }
                eventsAfterStartup = chronicles.subList(0, lastStartupIndex);
                $this$any$iv = eventsAfterStartup;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl59
                v3 = false;
                ** GOTO lbl66
lbl59:
                // 2 sources

                for (E element$iv : $this$any$iv) {
                    it = (ChroniclePresenter)element$iv;
                    $i$a$-any-RecapTriggerService$hasSignificantEventsSinceStartup$hasSignificantEvents$1 = false;
                    if (!(it.getKind() != ChronicleKind.Scroll && it.getKind() != ChronicleKind.FileSwitch)) continue;
                    v3 = true;
                    ** GOTO lbl66
                }
                v3 = false;
lbl66:
                // 3 sources

                hasSignificantEvents = v3;
                $i$f$fileLogger = false;
                $i$f$currentClassLogger = false;
                clazz$iv$iv = MethodHandles.lookup().lookupClass();
                v4 = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                v4.debug("Events since startup: " + eventsAfterStartup.size() + ", significant: " + (hasSignificantEvents != false));
                return Boxing.boxBoolean((boolean)(hasSignificantEvents != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Project access$getProject$p(RecapTriggerService $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$hasSignificantEventsSinceStartup(RecapTriggerService $this, Continuation $completion) {
        return $this.hasSignificantEventsSinceStartup((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$setUserWasActiveDuringComputation$p(RecapTriggerService $this, boolean bl) {
        $this.userWasActiveDuringComputation = bl;
    }

    public static final /* synthetic */ void access$setUserActivityTimestamp$p(RecapTriggerService $this, Long l) {
        $this.userActivityTimestamp = l;
    }

    public static final /* synthetic */ Job access$getActivityTrackerJob$p(RecapTriggerService $this) {
        return $this.activityTrackerJob;
    }

    public static final /* synthetic */ void access$setActivityTrackerJob$p(RecapTriggerService $this, Job job2) {
        $this.activityTrackerJob = job2;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(RecapTriggerService $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getUserWasActiveDuringComputation$p(RecapTriggerService $this) {
        return $this.userWasActiveDuringComputation;
    }

    public static final /* synthetic */ void access$handleRecapCompletion(RecapTriggerService $this, boolean chroniclesChanged) {
        $this.handleRecapCompletion(chroniclesChanged);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.riderNext.latest"})
    @SourceDebugExtension(value={"SMAP\nRecapTriggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecapTriggerService.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,137:1\n30#2,2:138\n*S KotlinDebug\n*F\n+ 1 RecapTriggerService.kt\ncom/intellij/ml/llm/riderNext/latest/chronicles/view/RecapTriggerService$Companion\n*L\n19#1:138,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RecapTriggerService getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<RecapTriggerService> serviceClass$iv = RecapTriggerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RecapTriggerService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

