/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.insight.impl.widget;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.ActivityTracker;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemon;
import com.intellij.ml.llm.riderNext.latest.ui.editor.cards.AIDaemonId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0006H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\fJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006R>\u0010\u0004\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\r\u001a2\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/widget/AIInsightProgressTracker;", "", "<init>", "()V", "custom", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "pending", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemonId;", "updating", "isInProgress", "", "getTasks", "addPending", "", "insight", "Lcom/intellij/ml/llm/riderNext/latest/ui/editor/cards/AIDaemon;", "addUpdating", "clearPending", "clearUpdating", "remove", "id", "addCustom", "removeCustom", "Companion", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class AIInsightProgressTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> custom;
    @NotNull
    private final Set<AIDaemonId> pending;
    @NotNull
    private final Set<AIDaemonId> updating;
    public static final int $stable = 8;

    public AIInsightProgressTracker() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.custom = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.pending = set2;
        Set set3 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"createConcurrentSet(...)");
        this.updating = set3;
    }

    public final boolean isInProgress() {
        return !((Collection)this.pending).isEmpty() || !((Collection)this.updating).isEmpty() || !((Collection)this.custom).isEmpty();
    }

    @NlsSafe
    @NotNull
    public final String getTasks() {
        StringBuilder builder = new StringBuilder();
        if (!((Collection)this.pending).isEmpty()) {
            builder.append("Pending: ");
            builder.append(CollectionsKt.joinToString$default((Iterable)this.pending, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)this.updating).isEmpty()) {
            if (((CharSequence)builder).length() > 0) {
                builder.append(", ");
            }
            builder.append("Updating: ");
            builder.append(CollectionsKt.joinToString$default((Iterable)this.updating, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        if (!((Collection)this.custom).isEmpty()) {
            if (((CharSequence)builder).length() > 0) {
                builder.append(", ");
            }
            builder.append("Custom: ");
            builder.append(CollectionsKt.joinToString$default((Iterable)this.custom, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void addPending(@NotNull AIDaemon insight) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        this.pending.add(insight.getId());
        Disposer.tryRegister((Disposable)insight, () -> AIInsightProgressTracker.addPending$lambda$0(this, insight));
        ActivityTracker.getInstance().inc();
    }

    public final void addUpdating(@NotNull AIDaemon insight) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        this.updating.add(insight.getId());
        Disposer.tryRegister((Disposable)insight, () -> AIInsightProgressTracker.addUpdating$lambda$0(this, insight));
        ActivityTracker.getInstance().inc();
    }

    public final void clearPending() {
        this.pending.clear();
        ActivityTracker.getInstance().inc();
    }

    public final void clearUpdating() {
        this.updating.clear();
        ActivityTracker.getInstance().inc();
    }

    public final void remove(@NotNull AIDaemonId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.pending.remove(id);
        this.updating.remove(id);
        ActivityTracker.getInstance().inc();
    }

    public final void addCustom(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.custom.add(id);
    }

    public final void removeCustom(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.custom.remove(id);
    }

    private static final void addPending$lambda$0(AIInsightProgressTracker this$0, AIDaemon $insight) {
        this$0.pending.remove($insight.getId());
    }

    private static final void addUpdating$lambda$0(AIInsightProgressTracker this$0, AIDaemon $insight) {
        this$0.updating.remove($insight.getId());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/widget/AIInsightProgressTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/widget/AIInsightProgressTracker;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.riderNext.latest"})
    @SourceDebugExtension(value={"SMAP\nAIInsightProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIInsightProgressTracker.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/widget/AIInsightProgressTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,83:1\n30#2,2:84\n*S KotlinDebug\n*F\n+ 1 AIInsightProgressTracker.kt\ncom/intellij/ml/llm/riderNext/latest/frozen/insight/impl/widget/AIInsightProgressTracker$Companion\n*L\n16#1:84,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIInsightProgressTracker getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<AIInsightProgressTracker> serviceClass$iv = AIInsightProgressTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (AIInsightProgressTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

