/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.nextStep;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/ProcessingTiming;", "", "chroniclesAgentTime", "", "intentClassificationTime", "verificationTimes", "", "<init>", "(JJLjava/util/List;)V", "getChroniclesAgentTime", "()J", "getIntentClassificationTime", "getVerificationTimes", "()Ljava/util/List;", "totalTime", "getTotalTime", "formatTime", "", "timeMs", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class ProcessingTiming {
    private final long chroniclesAgentTime;
    private final long intentClassificationTime;
    @NotNull
    private final List<Long> verificationTimes;
    public static final int $stable = 8;

    public ProcessingTiming(long chroniclesAgentTime, long intentClassificationTime, @NotNull List<Long> verificationTimes) {
        Intrinsics.checkNotNullParameter(verificationTimes, (String)"verificationTimes");
        this.chroniclesAgentTime = chroniclesAgentTime;
        this.intentClassificationTime = intentClassificationTime;
        this.verificationTimes = verificationTimes;
    }

    public /* synthetic */ ProcessingTiming(long l, long l2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = 0L;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(l, l2, list);
    }

    public final long getChroniclesAgentTime() {
        return this.chroniclesAgentTime;
    }

    public final long getIntentClassificationTime() {
        return this.intentClassificationTime;
    }

    @NotNull
    public final List<Long> getVerificationTimes() {
        return this.verificationTimes;
    }

    public final long getTotalTime() {
        return this.chroniclesAgentTime + this.intentClassificationTime + CollectionsKt.sumOfLong((Iterable)this.verificationTimes);
    }

    @NotNull
    public final String formatTime(long timeMs) {
        Object object;
        if (timeMs < 1000L) {
            object = timeMs + "ms";
        } else if (timeMs < 60000L) {
            String string = "%.2fs";
            Object[] objectArray = new Object[]{(double)timeMs / 1000.0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            String string = "%dm %ds";
            Object[] objectArray = new Object[]{timeMs / (long)60000, timeMs % (long)60000 / (long)1000};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return object;
    }

    @NotNull
    public String toString() {
        return "Chronicles: " + this.formatTime(this.chroniclesAgentTime) + ", Intent: " + this.formatTime(this.intentClassificationTime) + ", Verification: " + this.formatTime(CollectionsKt.sumOfLong((Iterable)this.verificationTimes)) + ", Total: " + this.formatTime(this.getTotalTime());
    }

    public final long component1() {
        return this.chroniclesAgentTime;
    }

    public final long component2() {
        return this.intentClassificationTime;
    }

    @NotNull
    public final List<Long> component3() {
        return this.verificationTimes;
    }

    @NotNull
    public final ProcessingTiming copy(long chroniclesAgentTime, long intentClassificationTime, @NotNull List<Long> verificationTimes) {
        Intrinsics.checkNotNullParameter(verificationTimes, (String)"verificationTimes");
        return new ProcessingTiming(chroniclesAgentTime, intentClassificationTime, verificationTimes);
    }

    public static /* synthetic */ ProcessingTiming copy$default(ProcessingTiming processingTiming, long l, long l2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            l = processingTiming.chroniclesAgentTime;
        }
        if ((n & 2) != 0) {
            l2 = processingTiming.intentClassificationTime;
        }
        if ((n & 4) != 0) {
            list = processingTiming.verificationTimes;
        }
        return processingTiming.copy(l, l2, list);
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.chroniclesAgentTime);
        result2 = result2 * 31 + Long.hashCode(this.intentClassificationTime);
        result2 = result2 * 31 + ((Object)this.verificationTimes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProcessingTiming)) {
            return false;
        }
        ProcessingTiming processingTiming = (ProcessingTiming)other;
        if (this.chroniclesAgentTime != processingTiming.chroniclesAgentTime) {
            return false;
        }
        if (this.intentClassificationTime != processingTiming.intentClassificationTime) {
            return false;
        }
        return Intrinsics.areEqual(this.verificationTimes, processingTiming.verificationTimes);
    }

    public ProcessingTiming() {
        this(0L, 0L, null, 7, null);
    }
}

