/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.nextStep.features;

import ai.koog.agents.core.tools.SimpleTool;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.features.NextStepFeatureProvider;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u001a\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/features/BulkChangeFeatureProvider;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/features/NextStepFeatureProvider;", "<init>", "()V", "getFeatureId", "", "getFeatureName", "getFeatureDescription", "getFeatureExamples", "getVerificationTools", "", "Lai/koog/agents/core/tools/SimpleTool;", "project", "Lcom/intellij/openapi/project/Project;", "getVerificationToolsDescription", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=1)
public final class BulkChangeFeatureProvider
implements NextStepFeatureProvider {
    public static final int $stable;

    @Override
    @NotNull
    public String getFeatureId() {
        return "bulk_code_changes";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Bulk Code Changes";
    }

    @Override
    @NotNull
    public String getFeatureDescription() {
        return "Purpose\nPropagate an already-started, simple and repetitive change pattern within the current file or across a small set of files.\n\nSuggest When (ALL must hold)\n- The latest contiguous activity shows the SAME transformation applied repeatedly\n  (\u22652 similar hunks in one file OR the same pattern across \u22652 files).\n- The pattern can be expressed as a text/regex replace or a simple structural rule.\n- There is evidence of remaining work (old token(s) still present).\n\nPrefer When (ANY)\n- Old and new forms coexist in the edited file.\n- Multiple files were touched with the same rename/migration intent.\n\nDo NOT Suggest\n- Only a single isolated change with no repetition.\n- Formatting/comments only; pattern cannot be stated compactly.\n- No evidence of remaining occurrences.\n\nRequired Parameters (minified JSON keys)\n- Always include at least one of: \"pattern\", \"replace\".\n- And one of: \"paths\" (narrow) OR \"includeGlobs\" (narrow).\n- Optional: \"tokens\", \"scope\" (\"file\" for single-file batches).\n\nMicro-Verification (\u2264 2 tiny checks)\n- Single-file: confirm target file exists AND still contains multiple \"old\" occurrences OR both \"old\" and \"new\".\n- Cross-file: confirm at least one other file still contains the \"old\" token.";
    }

    @Override
    @NotNull
    public String getFeatureExamples() {
        return "Positive \u2014 single file\ntask: Continue renaming 'oldName' to 'newName' in UserService\ndetails: Complete the ongoing rename within UserService.kt\nparameters: {\"pattern\":\"oldName\",\"replace\":\"newName\",\"paths\":[\"**/UserService.*\"],\"tokens\":[\"oldName\",\"newName\"],\"scope\":\"file\"}\n\nPositive \u2014 cross-file\ntask: Migrate 'api.v1' \u2192 'api.v2' across payment module\ndetails: Finalize API migration consistently\nparameters: {\"pattern\":\"api\\\\.v1\\\\.\",\"replace\":\"api.v2.\",\"includeGlobs\":[\"**/payment/**\"]}\n\nAnti-example\nreason: Single isolated change; no remaining occurrences";
    }

    @Override
    @NotNull
    public List<SimpleTool<?>> getVerificationTools(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public String getVerificationToolsDescription() {
        return "";
    }
}

