/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.nextStep.features;

import ai.koog.agents.core.tools.SimpleTool;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.features.NextStepFeatureProvider;
import com.intellij.ml.llm.riderNext.latest.frozen.nextStep.features.tools.FindTestTool;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u001a\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/features/RunTestFeatureProvider;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/nextStep/features/NextStepFeatureProvider;", "<init>", "()V", "getFeatureId", "", "getFeatureName", "getFeatureDescription", "getFeatureExamples", "getVerificationTools", "", "Lai/koog/agents/core/tools/SimpleTool;", "project", "Lcom/intellij/openapi/project/Project;", "getVerificationToolsDescription", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=1)
public final class RunTestFeatureProvider
implements NextStepFeatureProvider {
    public static final int $stable;

    @Override
    @NotNull
    public String getFeatureId() {
        return "run_tests";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Run Tests";
    }

    @Override
    @NotNull
    public String getFeatureDescription() {
        return "Purpose\nRun the most relevant tests to validate the latest code or test changes.\n\nSuggest When (ALL must hold)\n- The latest cluster includes at least one concrete code edit/save in logic-bearing files under src/main or src/test.\n- No test run has occurred AFTER the most recent relevant edit (to the code under test or its tests).\n- The edited area is plausibly covered by tests.\n\nPrefer When (ANY)\n- Both a source file and its paired test were edited.\n- A refactor/migration may affect behavior.\n- A known failing test was recently addressed by a fix.\n\nDo NOT Suggest\n- Navigation/search only; no edits.\n- Purely non-functional edits (formatting/comments) with no behavioral impact.\n- A test run already happened AFTER the last relevant edit and no further edits followed.\n- Project is not runnable for tests (e.g., broken build) without fix attempts.\n\nRequired Parameters (minified JSON keys)\n- \"testSelectors\":[\"Class#method\" or \"Class\"]\n- \"paths\":[\"...\"] or \"includeGlobs\":[\"...\"] (narrow scope)\n- \"message\":\"willVerify=<WHAT>;whyNow=<WHY>\"  // both parts required\n\nMicro-Verification (\u2264 2 tiny checks)\n- Derive t_edit_max vs t_test_max from NDJSON; ensure t_edit_max > t_test_max.\n- Confirm at least one selector/path exists. If you cannot state both WHAT and WHY, reject.";
    }

    @Override
    @NotNull
    public String getFeatureExamples() {
        return "Re-run after test edit\ntask: Re-run OwnerValidatorTests\ndetails: Validate new/changed test methods\nparameters: {\"testSelectors\":[\"OwnerValidatorTests\"],\"paths\":[\"src/test/**/OwnerValidatorTests.*\"],\"message\":\"willVerify=changed test methods;whyNow=tests edited after last run\"}\n\nRun after logic change\ntask: Run UserServiceTest\ndetails: Validate logic change in UserService\nparameters: {\"testSelectors\":[\"UserServiceTest\"],\"paths\":[\"src/test/**/UserServiceTest.*\"],\"message\":\"willVerify=edited validation flow;whyNow=source edited; no run since edit\"}";
    }

    @Override
    @NotNull
    public List<SimpleTool<?>> getVerificationTools(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return CollectionsKt.listOf((Object)((Object)new FindTestTool(project2)));
    }

    @Override
    @NotNull
    public String getVerificationToolsDescription() {
        return "Tools provided for verification:\n- find_tests(file: string): Returns newline-separated project-relative paths of test files related to the given source file using IDE TestFinder.\n  Path format: project-relative only (e.g., src/main/kotlin/Foo.kt). On errors (file not found, directory given, PSI not available) or when no tests exist, the tool returns an explanatory message instead of an empty string.";
    }
}

