/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.frozen.recap.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.RecapModel;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.RecapServiceState;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.lvcs.RecapLVCSTimestamp;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.RecapPopupView;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapContainerKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapFooterKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapHeaderKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapRoundedPanelKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapSubheaderKt;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.RecapTextComponentsManager;
import com.intellij.ml.llm.riderNext.latest.frozen.recap.ui.components.recapTextViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.ListLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ShowingScopeKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000i\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0016\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0010H\u0002J\r\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ui/RecapPopupView;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "recapState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/RecapServiceState;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lkotlinx/coroutines/flow/StateFlow;)V", "graph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "container", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "content", "Ljavax/swing/JPanel;", "recapTextComponentsManager", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ui/components/RecapTextComponentsManager;", "currentLoadMorePanel", "createContentPanel", "createMouseAdapter", "com/intellij/ml/llm/riderNext/latest/frozen/recap/ui/RecapPopupView$createMouseAdapter$1", "()Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/ui/RecapPopupView$createMouseAdapter$1;", "createScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "handleError", "", "errorMessage", "", "handleInformativeContent", "recapContent", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/RecapModel$Informative;", "handleRecapContent", "Lcom/intellij/ml/llm/riderNext/latest/frozen/recap/RecapModel;", "create", "Ljavax/swing/JComponent;", "intellij.ml.llm.riderNext.latest"})
@StabilityInferred(parameters=0)
public final class RecapPopupView {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final StateFlow<RecapServiceState> recapState;
    @NotNull
    private final PropertyGraph graph;
    @NotNull
    private final BorderLayoutPanel container;
    @NotNull
    private final JPanel content;
    @NotNull
    private final RecapTextComponentsManager recapTextComponentsManager;
    @Nullable
    private JPanel currentLoadMorePanel;
    public static final int $stable = 8;

    public RecapPopupView(@NotNull Project project2, @NotNull Disposable disposable, @NotNull StateFlow<? extends RecapServiceState> recapState) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(recapState, (String)"recapState");
        this.project = project2;
        this.disposable = disposable;
        this.recapState = recapState;
        this.graph = new PropertyGraph(null, false, 3, null);
        this.container = RecapContainerKt.recapContainer(this.disposable);
        this.content = this.createContentPanel();
        this.recapTextComponentsManager = new RecapTextComponentsManager();
    }

    private final JPanel createContentPanel() {
        JPanel jPanel;
        JPanel $this$createContentPanel_u24lambda_u240 = jPanel = new JPanel((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)ListLayout.Companion, (int)0, null, (ListLayout.GrowPolicy)ListLayout.GrowPolicy.GROW, (int)3, null));
        boolean bl = false;
        $this$createContentPanel_u24lambda_u240.setOpaque(false);
        return jPanel;
    }

    private final createMouseAdapter.1 createMouseAdapter() {
        return new MouseAdapter(this){
            final /* synthetic */ RecapPopupView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JPanel jPanel = RecapPopupView.access$getCurrentLoadMorePanel$p(this.this$0);
                    if (jPanel == null) break block0;
                    jPanel.setVisible(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getComponent().getBounds().contains(e.getPoint())) break block1;
                    JPanel jPanel = RecapPopupView.access$getCurrentLoadMorePanel$p(this.this$0);
                    if (jPanel != null) {
                        jPanel.setVisible(false);
                    }
                }
            }

            public void mouseMoved(MouseEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    JPanel jPanel = RecapPopupView.access$getCurrentLoadMorePanel$p(this.this$0);
                    if (jPanel == null) break block0;
                    jPanel.setVisible(true);
                }
            }
        };
    }

    private final JBScrollPane createScrollPane() {
        JBScrollPane jBScrollPane;
        createMouseAdapter.1 mouseAdapter = this.createMouseAdapter();
        JBScrollPane $this$createScrollPane_u24lambda_u240 = jBScrollPane = new JBScrollPane((Component)this.content);
        boolean bl = false;
        $this$createScrollPane_u24lambda_u240.setOpaque(false);
        $this$createScrollPane_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$createScrollPane_u24lambda_u240.setHorizontalScrollBarPolicy(31);
        $this$createScrollPane_u24lambda_u240.addMouseListener((MouseListener)mouseAdapter);
        $this$createScrollPane_u24lambda_u240.addMouseMotionListener((MouseMotionListener)mouseAdapter);
        $this$createScrollPane_u24lambda_u240.getViewport().addMouseListener(mouseAdapter);
        $this$createScrollPane_u24lambda_u240.getViewport().addMouseMotionListener(mouseAdapter);
        return jBScrollPane;
    }

    private final void handleError(String errorMessage) {
        this.content.removeAll();
        this.recapTextComponentsManager.clear();
        recapTextViewComponent errorTextView = new recapTextViewComponent(errorMessage);
        this.recapTextComponentsManager.add(errorTextView);
        this.content.add((Component)((Object)errorTextView));
        this.recapTextComponentsManager.stopLoadingAll();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInformativeContent(RecapModel.Informative recapContent) {
        block3: {
            void $this$handleInformativeContent_u24lambda_u241_u240;
            Object object;
            boolean isLoadMoreSupported = Registry.Companion.get("llm.riderNext.recap.loadMore").asBoolean();
            RecapPopupView $this$handleInformativeContent_u24lambda_u240 = this;
            boolean bl = false;
            String string = recapContent.getLatestCommitMessage();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                object = it.length() > 100 ? StringsKt.take((String)it, (int)100) + "..." : it;
            } else {
                object = null;
            }
            Object message = object;
            RecapLVCSTimestamp recapLVCSTimestamp = recapContent.getTimestamp();
            Object summarySubtext = (recapLVCSTimestamp != null ? recapLVCSTimestamp.getTimestampString() : null) + " " + (String)message;
            $this$handleInformativeContent_u24lambda_u240.content.add(RecapSubheaderKt.recapSubheader$default("Summary", (String)summarySubtext, false, null, $this$handleInformativeContent_u24lambda_u240.recapTextComponentsManager, 12, null).getHeader());
            recapTextViewComponent summaryView = new recapTextViewComponent(recapContent.getSummary());
            this.recapTextComponentsManager.add(summaryView);
            this.content.add((Component)((Object)summaryView));
            List<RecapModel.WhatsNextItem> list = recapContent.getWhatsNext();
            if (list == null) break block3;
            List<RecapModel.WhatsNextItem> whatsNext = list;
            boolean bl3 = false;
            summarySubtext = message = RecapSubheaderKt.recapSubheader$default("What's next", null, false, null, this.recapTextComponentsManager, 12, null).getHeader();
            JPanel jPanel = this.content;
            boolean $i$a$-apply-RecapPopupView$handleInformativeContent$2$22 = false;
            $this$handleInformativeContent_u24lambda_u241_u240.setBorder(JBUI.Borders.compound((Border)$this$handleInformativeContent_u24lambda_u241_u240.getBorder(), (Border)((Border)JBUI.Borders.emptyTop((int)20))));
            jPanel.add((Component)message);
            Object object2 = ListLayout.Companion;
            ListLayout.GrowPolicy $i$a$-apply-RecapPopupView$handleInformativeContent$2$22 = ListLayout.GrowPolicy.GROW;
            Object $this$handleInformativeContent_u24lambda_u241_u241 = object2 = new JPanel((LayoutManager)ListLayout.Companion.vertical$default((ListLayout.Companion)object2, (int)10, null, (ListLayout.GrowPolicy)$i$a$-apply-RecapPopupView$handleInformativeContent$2$22, (int)2, null));
            boolean bl4 = false;
            ((JComponent)$this$handleInformativeContent_u24lambda_u241_u241).setOpaque(false);
            Object whatsNextContainer = object2;
            object2 = ((Iterable)whatsNext).iterator();
            int n = 0;
            while (object2.hasNext()) {
                int index = n++;
                RecapModel.WhatsNextItem item = (RecapModel.WhatsNextItem)object2.next();
                ((Container)whatsNextContainer).add(RecapRoundedPanelKt.recapRoundedPanel(this.project, index + 1, item, this.recapTextComponentsManager));
            }
            this.content.add((Component)whatsNextContainer);
        }
    }

    private final void handleRecapContent(RecapModel recapContent) {
        this.content.removeAll();
        this.recapTextComponentsManager.clear();
        RecapModel recapModel = recapContent;
        if (recapModel instanceof RecapModel.AssistantNotReady) {
            recapTextViewComponent newTextView = new recapTextViewComponent("AI Assistant is not ready yet");
            this.recapTextComponentsManager.add(newTextView);
            this.content.add((Component)((Object)newTextView));
        } else if (recapModel instanceof RecapModel.Error) {
            this.handleError("Error occurred while loading Recap");
        } else if (recapModel instanceof RecapModel.Informative) {
            this.handleInformativeContent((RecapModel.Informative)recapContent);
        } else if (recapModel instanceof RecapModel.NoInfo) {
            recapTextViewComponent newTextView = new recapTextViewComponent("No recent changes found");
            this.recapTextComponentsManager.add(newTextView);
            this.content.add((Component)((Object)newTextView));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.recapTextComponentsManager.stopLoadingAll();
    }

    @NotNull
    public final JComponent create() {
        this.container.addToTop((Component)RecapHeaderKt.recapHeader());
        this.container.addToBottom((Component)RecapFooterKt.recapFooter(this.project, this.graph, this.recapState));
        JBScrollPane scrollPane = this.createScrollPane();
        Wrapper contentWrapper = new Wrapper();
        contentWrapper.setContent((JComponent)scrollPane);
        ShowingScopeKt.showingScope((Component)((Component)this.container), (String)"recap popup container", (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RecapPopupView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RecapPopupView.access$getRecapState$p(this.this$0).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ RecapPopupView this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object emit(RecapServiceState state, Continuation<? super Unit> $completion) {
                                if (!($completion instanceof create.emit.1)) ** GOTO lbl-1000
                                var5_3 = $completion;
                                if ((var5_3.label & -2147483648) != 0) {
                                    var5_3.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(this, $completion){
                                        Object L$0;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ create.1<T> this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        public final Object invokeSuspend(Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return this.this$0.emit(null, (Continuation<Unit>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!(state instanceof RecapServiceState.Started)) ** GOTO lbl34
                                        RecapPopupView.access$getRecapTextComponentsManager$p(this.this$0).startLoadingAll();
                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)state);
                                        $continuation.label = 1;
                                        v0 = ((RecapServiceState.Started)state).getContent().await((Continuation)$continuation);
                                        ** if (v0 != var6_5) goto lbl21
lbl20:
                                        // 1 sources

                                        return var6_5;
lbl21:
                                        // 1 sources

                                        ** GOTO lbl28
                                    }
                                    case 1: {
                                        state = (RecapServiceState)$continuation.L$0;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl28:
                                            // 2 sources

                                            recapContent = (RecapModel)v0;
                                            RecapPopupView.access$handleRecapContent(this.this$0, recapContent);
                                        }
                                        catch (Exception e) {
                                            RecapPopupView.access$handleError(this.this$0, "Error occurred while loading Recap");
                                            return Unit.INSTANCE;
                                        }
lbl34:
                                        // 2 sources

                                        RecapPopupView.access$getContainer$p(this.this$0).revalidate();
                                        RecapPopupView.access$getContainer$p(this.this$0).repaint();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
        if (internalUICustomization != null && (internalUICustomization = internalUICustomization.getAiComponentMarker()) != null) {
            internalUICustomization.markAiContainerFor((JComponent)this.container);
        }
        this.container.addToCenter((Component)contentWrapper);
        return (JComponent)this.container;
    }

    public static final /* synthetic */ JPanel access$getCurrentLoadMorePanel$p(RecapPopupView $this) {
        return $this.currentLoadMorePanel;
    }

    public static final /* synthetic */ StateFlow access$getRecapState$p(RecapPopupView $this) {
        return $this.recapState;
    }

    public static final /* synthetic */ RecapTextComponentsManager access$getRecapTextComponentsManager$p(RecapPopupView $this) {
        return $this.recapTextComponentsManager;
    }

    public static final /* synthetic */ void access$handleRecapContent(RecapPopupView $this, RecapModel recapContent) {
        $this.handleRecapContent(recapContent);
    }

    public static final /* synthetic */ void access$handleError(RecapPopupView $this, String errorMessage) {
        $this.handleError(errorMessage);
    }

    public static final /* synthetic */ BorderLayoutPanel access$getContainer$p(RecapPopupView $this) {
        return $this.container;
    }
}

