/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ruby.context;

import com.intellij.ml.llm.context.FileContext;
import com.intellij.ml.llm.context.filebuilder.FileContextBuilder;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.utils.RubyVirtualFileScanner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/ruby/context/RubyFileContextBuilder;", "Lcom/intellij/ml/llm/context/filebuilder/FileContextBuilder;", "<init>", "()V", "getFileContext", "Lcom/intellij/ml/llm/context/FileContext;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findRequiredFiles", "", "Lcom/intellij/psi/PsiElement;", "rFile", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/RFile;", "intellij.ml.llm.ruby"})
public final class RubyFileContextBuilder
implements FileContextBuilder {
    @Nullable
    public FileContext getFileContext(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        VirtualFile vFile = ((RFile)psiFile).getVirtualFile();
        if (vFile == null) {
            return null;
        }
        PSString pSString = PSStringKt.toPSString((PSString)ExtensionsKtKt.getPrivacySafe((PsiNamedElement)psiFile).getName());
        PSString pSString2 = ExtensionsKtKt.getPrivacySafe(vFile).getPath();
        List<PsiElement> list = this.findRequiredFiles((RFile)psiFile);
        Class[] classArray = new Class[]{RClass.class, RModule.class};
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)psiFile), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
        List list2 = CollectionsKt.toList((Iterable)collection);
        classArray = new Class[]{RMethod.class};
        Collection collection2 = PsiTreeUtil.findChildrenOfAnyType((PsiElement)((PsiElement)psiFile), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"findChildrenOfAnyType(...)");
        return new FileContext(psiFile, pSString, pSString2, null, list, list2, CollectionsKt.toList((Iterable)collection2), 8, null);
    }

    private final List<PsiElement> findRequiredFiles(RFile rFile) {
        Project project2 = rFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        VirtualFile vFile = rFile.getVirtualFile();
        Object2IntMap object2IntMap = RFileUtil.createMapByLoadpath((Collection)LoadPathUtil.getLoadPath((RTopLevelContainer)((RTopLevelContainer)rFile)));
        Intrinsics.checkNotNullExpressionValue((Object)object2IntMap, (String)"createMapByLoadpath(...)");
        Object2IntMap loadPathMap = object2IntMap;
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        for (Object e : RFileUtil.computeRequires((RFile)rFile)) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            RequireInfo require = (RequireInfo)e;
            for (VirtualFile file2 : RFileUtil.findFilesForName((Project)project3, (String)require.getPath(), (Object2IntMap)loadPathMap, (VirtualFile)vFile.getParent(), (boolean)require.isRelative(), null)) {
                if (!RubyVirtualFileScanner.isRubyFile((VirtualFile)file2)) continue;
                result2.add(PsiUtilCore.getPsiFile((Project)project3, (VirtualFile)file2));
            }
        }
        return result2;
    }
}

