/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.fix;

import com.intellij.ml.llm.core.chat.parts.CodePart;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.rust.fix.AIOriginalUpdatedResponseApplier;
import com.intellij.ml.llm.rust.fix.AIOriginalUpdatedResponseApplierKt;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003()*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\u000e\u001a\u00020\fH\u0002J*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u001c\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0002J@\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0018\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\nH\u0002\u00a8\u0006+"}, d2={"Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier;", "", "<init>", "()V", "apply", "", "Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$LineReplacement;", "document", "Lcom/intellij/openapi/editor/Document;", "message", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "restoreIndent", "", "lines", "indent", "addOrRemoveBrace", "original", "updated", "calculateBraceBalance", "", "before", "findIndentInLine", "source", "content", "findMatchedRange", "Lkotlin/ranges/IntRange;", "originalLines", "searchedLines", "compareLines", "Lkotlin/Function2;", "", "createBeforeAfterDiff", "Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$BeforeAfterDiff;", "current", "Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$TitledSnippet;", "next", "parseCodeSnippets", "createTitledSnippet", "description", "snippet", "LineReplacement", "TitledSnippet", "BeforeAfterDiff", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nAIOriginalUpdatedResponseApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIOriginalUpdatedResponseApplier.kt\ncom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1617#2,9:151\n1869#2:160\n1870#2:162\n1626#2:163\n1563#2:164\n1634#2,3:165\n774#2:168\n865#2,2:169\n461#2,6:171\n461#2,6:177\n1617#2,9:183\n1869#2:192\n1870#2:194\n1626#2:195\n1#3:161\n1#3:193\n*S KotlinDebug\n*F\n+ 1 AIOriginalUpdatedResponseApplier.kt\ncom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier\n*L\n26#1:151,9\n26#1:160\n26#1:162\n26#1:163\n56#1:164\n56#1:165,3\n90#1:168\n90#1:169,2\n113#1:171,6\n114#1:177,6\n120#1:183,9\n120#1:192\n120#1:194\n120#1:195\n26#1:161\n120#1:193\n*E\n"})
public final class AIOriginalUpdatedResponseApplier {
    @NotNull
    public static final AIOriginalUpdatedResponseApplier INSTANCE = new AIOriginalUpdatedResponseApplier();

    private AIOriginalUpdatedResponseApplier() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<LineReplacement> apply(@NotNull Document document2, @NotNull List<? extends MessagePart> message) {
        List originalLines;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        CharSequence charSequence = document2.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
        CharSequence initialText = charSequence;
        List<TitledSnippet> snippets = this.parseCodeSnippets(message);
        Iterable iterable = CollectionsKt.zipWithNext((Iterable)snippets);
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BeforeAfterDiff it$iv$iv;
            TitledSnippet next;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            TitledSnippet current = (TitledSnippet)pair.component1();
            if (INSTANCE.createBeforeAfterDiff(current, next = (TitledSnippet)pair.component2()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List beforeAfterDiffs = (List)destination$iv$iv;
        List result2 = originalLines = StringsKt.lines((CharSequence)initialText);
        List replacements = new ArrayList();
        for (BeforeAfterDiff beforeAfterDiff : beforeAfterDiffs) {
            String before = beforeAfterDiff.component1();
            String after = beforeAfterDiff.component2();
            List linesBefore = AIOriginalUpdatedResponseApplierKt.access$trimLineNumberPrefix(StringsKt.lines((CharSequence)before));
            List<String> linesAfter = AIOriginalUpdatedResponseApplierKt.access$trimLineNumberPrefix(StringsKt.lines((CharSequence)after));
            IntRange lineRangeToReplace = this.findMatchedRange(result2, linesBefore);
            if (lineRangeToReplace == null) {
                return null;
            }
            List<String> replacement = linesAfter;
            String indent = this.findIndentInLine((String)result2.get(lineRangeToReplace.getFirst()), (String)CollectionsKt.first((List)linesBefore));
            replacement = this.restoreIndent(replacement, indent);
            replacement = this.addOrRemoveBrace(linesBefore, replacement);
            result2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.slice((List)result2, (IntRange)RangesKt.until((int)0, (int)lineRangeToReplace.getFirst())), (Iterable)replacement), (Iterable)CollectionsKt.slice((List)result2, (IntRange)RangesKt.until((int)(lineRangeToReplace.getLast() + 1), (int)result2.size())));
            ((Collection)replacements).add(new LineReplacement(lineRangeToReplace, CollectionsKt.joinToString$default((Iterable)replacement, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
        }
        return replacements;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> restoreIndent(List<String> lines2, String indent) {
        void $this$mapTo$iv$iv;
        String string = (String)CollectionsKt.singleOrNull(lines2);
        boolean bl = string != null ? StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = lines2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(!StringsKt.isBlank((CharSequence)((CharSequence)line)) ? indent + (String)line : "");
        }
        return (List)destination$iv$iv;
    }

    private final List<String> addOrRemoveBrace(List<String> original, List<String> updated) {
        int braceDiff = this.calculateBraceBalance(CollectionsKt.joinToString$default((Iterable)original, null, null, null, (int)0, null, null, (int)63, null)) - this.calculateBraceBalance(CollectionsKt.joinToString$default((Iterable)updated, null, null, null, (int)0, null, null, (int)63, null));
        if (braceDiff < 0) {
            return CollectionsKt.plus((Collection)updated, (Object)"}");
        }
        if (braceDiff > 0) {
            String string = (String)CollectionsKt.lastOrNull(updated);
            if (Intrinsics.areEqual((Object)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null), (Object)"}")) {
                return CollectionsKt.dropLast(updated, (int)1);
            }
        }
        return updated;
    }

    private final int calculateBraceBalance(String before) {
        return SequencesKt.sumOfInt((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.asSequence((CharSequence)before), AIOriginalUpdatedResponseApplier::calculateBraceBalance$lambda$0));
    }

    private final String findIndentInLine(String source, String content2) {
        if (source == null || content2 == null) {
            return "";
        }
        int indentIndex = StringsKt.indexOf$default((CharSequence)source, (String)((Object)StringsKt.trimEnd((CharSequence)content2)).toString(), (int)0, (boolean)false, (int)6, null);
        if (indentIndex < 0) {
            return "";
        }
        return StringsKt.slice((String)source, (IntRange)RangesKt.until((int)0, (int)indentIndex));
    }

    private final IntRange findMatchedRange(List<String> originalLines, List<String> searchedLines) {
        IntRange intRange = this.findMatchedRange(originalLines, searchedLines, (Function2<? super String, ? super String, Boolean>)((Function2)findMatchedRange.1.INSTANCE));
        if (intRange == null) {
            intRange = this.findMatchedRange(originalLines, searchedLines, (Function2<? super String, ? super String, Boolean>)((Function2)findMatchedRange.2.INSTANCE));
        }
        return intRange;
    }

    /*
     * WARNING - void declaration
     */
    private final IntRange findMatchedRange(List<String> originalLines, List<String> searchedLines, Function2<? super String, ? super String, Boolean> compareLines) {
        Iterable iterable;
        block3: {
            void $this$filterTo$iv$iv;
            String string = (String)CollectionsKt.firstOrNull(searchedLines);
            if (string == null) {
                return null;
            }
            String firstLine = string;
            Iterable $this$filter$iv = (Iterable)CollectionsKt.getIndices((Collection)originalLines);
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int line = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!((Boolean)compareLines.invoke((Object)originalLines.get(line), (Object)firstLine)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List candidateLines = (List)destination$iv$iv;
            Iterator iterator = ((Iterable)candidateLines).iterator();
            while (iterator.hasNext()) {
                int lineStart = ((Number)iterator.next()).intValue();
                boolean bl = false;
                Integer matchedLines = AIOriginalUpdatedResponseApplier.findMatchedRange$countMatchedLines(compareLines, (Sequence<String>)CollectionsKt.asSequence((Iterable)CollectionsKt.drop((Iterable)originalLines, (int)lineStart)), (Sequence<String>)CollectionsKt.asSequence((Iterable)searchedLines));
                iterable2 = matchedLines == null ? null : new IntRange(lineStart, lineStart + matchedLines);
                if (iterable2 == null) continue;
                iterable = iterable2;
                break block3;
            }
            iterable = null;
        }
        return iterable;
    }

    private final BeforeAfterDiff createBeforeAfterDiff(TitledSnippet current, TitledSnippet next) {
        Object element$iv;
        block6: {
            String line;
            ListIterator iterator$iv;
            boolean $i$f$last;
            List $this$last$iv;
            block5: {
                $this$last$iv = StringsKt.lines((CharSequence)current.getDescription());
                $i$f$last = false;
                iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    line = (String)element$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)line);
                    if (!bl2) continue;
                    break block5;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            if (!StringsKt.contains((CharSequence)((CharSequence)element$iv), (CharSequence)"original", (boolean)true)) {
                return null;
            }
            $this$last$iv = StringsKt.lines((CharSequence)next.getDescription());
            $i$f$last = false;
            iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                line = (String)element$iv;
                boolean bl = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)line);
                if (!bl3) continue;
                break block6;
            }
            throw new NoSuchElementException("List contains no element matching the predicate.");
        }
        if (!StringsKt.contains((CharSequence)((CharSequence)element$iv), (CharSequence)"update", (boolean)true)) {
            return null;
        }
        if (StringsKt.isBlank((CharSequence)current.getContent())) {
            return null;
        }
        return new BeforeAfterDiff(current.getContent(), next.getContent());
    }

    /*
     * WARNING - void declaration
     */
    private final List<TitledSnippet> parseCodeSnippets(List<? extends MessagePart> message) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)1, (int)message.size());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TitledSnippet it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int i = element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.createTitledSnippet(message.get(i - 1), message.get(i)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TitledSnippet createTitledSnippet(MessagePart description, MessagePart snippet) {
        if (description instanceof CodePart || !(snippet instanceof CodePart)) {
            return null;
        }
        return new TitledSnippet(description.getTextContent(), ((CodePart)snippet).getCode().getText());
    }

    private static final Integer calculateBraceBalance$lambda$0(char c) {
        return switch (c) {
            case '{' -> 1;
            case '}' -> -1;
            default -> null;
        };
    }

    private static final boolean findMatchedRange$matchExact(String line1, String line2) {
        return Intrinsics.areEqual((Object)((Object)StringsKt.trimEnd((CharSequence)line1)).toString(), (Object)((Object)StringsKt.trimEnd((CharSequence)line2)).toString());
    }

    private static final boolean findMatchedRange$matchIgnoreIndents(String line1, String line2) {
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)line1)).toString(), (Object)((Object)StringsKt.trim((CharSequence)line2)).toString());
    }

    private static final Integer findMatchedRange$countMatchedLines(Function2<? super String, ? super String, Boolean> $compareLines, Sequence<String> candidate, Sequence<String> searchedLines) {
        Sequence candidate2 = SequencesKt.filter((Sequence)SequencesKt.withIndex(candidate), AIOriginalUpdatedResponseApplier::findMatchedRange$countMatchedLines$lambda$1);
        Sequence searchedLines2 = SequencesKt.filter(searchedLines, AIOriginalUpdatedResponseApplier::findMatchedRange$countMatchedLines$lambda$2);
        int lastMatchedLine = 0;
        for (Pair pair : SequencesKt.zip((Sequence)candidate2, (Sequence)searchedLines2)) {
            IndexedValue indexedLine = (IndexedValue)pair.component1();
            String searchedLine = (String)pair.component2();
            int index = indexedLine.component1();
            String line = (String)indexedLine.component2();
            if (!((Boolean)$compareLines.invoke((Object)line, (Object)searchedLine)).booleanValue()) {
                return null;
            }
            lastMatchedLine = index;
        }
        return lastMatchedLine;
    }

    private static final boolean findMatchedRange$countMatchedLines$lambda$1(IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        String line = (String)indexedValue.component2();
        return !StringsKt.isBlank((CharSequence)line);
    }

    private static final boolean findMatchedRange$countMatchedLines$lambda$2(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !StringsKt.isBlank((CharSequence)line);
    }

    public static final /* synthetic */ boolean access$findMatchedRange$matchExact(String line1, String line2) {
        return AIOriginalUpdatedResponseApplier.findMatchedRange$matchExact(line1, line2);
    }

    public static final /* synthetic */ boolean access$findMatchedRange$matchIgnoreIndents(String line1, String line2) {
        return AIOriginalUpdatedResponseApplier.findMatchedRange$matchIgnoreIndents(line1, line2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$BeforeAfterDiff;", "", "before", "", "after", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getBefore", "()Ljava/lang/String;", "getAfter", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.rust"})
    private static final class BeforeAfterDiff {
        @NotNull
        private final String before;
        @NotNull
        private final String after;

        public BeforeAfterDiff(@NotNull String before, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            this.before = before;
            this.after = after;
        }

        @NotNull
        public final String getBefore() {
            return this.before;
        }

        @NotNull
        public final String getAfter() {
            return this.after;
        }

        @NotNull
        public final String component1() {
            return this.before;
        }

        @NotNull
        public final String component2() {
            return this.after;
        }

        @NotNull
        public final BeforeAfterDiff copy(@NotNull String before, @NotNull String after) {
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            return new BeforeAfterDiff(before, after);
        }

        public static /* synthetic */ BeforeAfterDiff copy$default(BeforeAfterDiff beforeAfterDiff, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = beforeAfterDiff.before;
            }
            if ((n & 2) != 0) {
                string2 = beforeAfterDiff.after;
            }
            return beforeAfterDiff.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "BeforeAfterDiff(before=" + this.before + ", after=" + this.after + ")";
        }

        public int hashCode() {
            int result2 = this.before.hashCode();
            result2 = result2 * 31 + this.after.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BeforeAfterDiff)) {
                return false;
            }
            BeforeAfterDiff beforeAfterDiff = (BeforeAfterDiff)other;
            if (!Intrinsics.areEqual((Object)this.before, (Object)beforeAfterDiff.before)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.after, (Object)beforeAfterDiff.after);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$LineReplacement;", "", "lineRange", "Lkotlin/ranges/IntRange;", "replacement", "", "<init>", "(Lkotlin/ranges/IntRange;Ljava/lang/String;)V", "getLineRange", "()Lkotlin/ranges/IntRange;", "getReplacement", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.rust"})
    public static final class LineReplacement {
        @NotNull
        private final IntRange lineRange;
        @NotNull
        private final String replacement;

        public LineReplacement(@NotNull IntRange lineRange, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.lineRange = lineRange;
            this.replacement = replacement;
        }

        @NotNull
        public final IntRange getLineRange() {
            return this.lineRange;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        @NotNull
        public final IntRange component1() {
            return this.lineRange;
        }

        @NotNull
        public final String component2() {
            return this.replacement;
        }

        @NotNull
        public final LineReplacement copy(@NotNull IntRange lineRange, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)lineRange, (String)"lineRange");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            return new LineReplacement(lineRange, replacement);
        }

        public static /* synthetic */ LineReplacement copy$default(LineReplacement lineReplacement, IntRange intRange, String string, int n, Object object) {
            if ((n & 1) != 0) {
                intRange = lineReplacement.lineRange;
            }
            if ((n & 2) != 0) {
                string = lineReplacement.replacement;
            }
            return lineReplacement.copy(intRange, string);
        }

        @NotNull
        public String toString() {
            return "LineReplacement(lineRange=" + this.lineRange + ", replacement=" + this.replacement + ")";
        }

        public int hashCode() {
            int result2 = this.lineRange.hashCode();
            result2 = result2 * 31 + this.replacement.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineReplacement)) {
                return false;
            }
            LineReplacement lineReplacement = (LineReplacement)other;
            if (!Intrinsics.areEqual((Object)this.lineRange, (Object)lineReplacement.lineRange)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replacement, (Object)lineReplacement.replacement);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/rust/fix/AIOriginalUpdatedResponseApplier$TitledSnippet;", "", "description", "", "content", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getContent", "intellij.ml.llm.rust"})
    private static final class TitledSnippet {
        @NotNull
        private final String description;
        @NotNull
        private final String content;

        public TitledSnippet(@NotNull String description, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.description = description;
            this.content = content2;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }
    }
}

