/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.chat.context;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.sql.chat.context.SqlObjectChatAttachment;
import com.intellij.ml.llm.sql.privacy.extensions.BasicElementWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiNamedElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u0011*\u00060\u0012j\u0002`\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a8\u0006\u0017"}, d2={"isTooLarge", "", "schema", "Lcom/intellij/database/model/basic/BasicSchema;", "describeDbObject", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "obj", "Lcom/intellij/database/model/basic/BasicElement;", "describeDbObjectInner", "Lcom/intellij/ml/llm/privacy/PSString;", "describeObjectSource", "element", "describeSchemaTables", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "describeTable", "t", "Lcom/intellij/database/model/basic/BasicTable;", "intellij.ml.llm.sql"})
public final class SqlChatMessagesKt {
    private static final boolean isTooLarge(BasicSchema schema) {
        Family family = schema.familyOf(ObjectKind.TABLE);
        if (family == null) {
            return false;
        }
        Family f = family;
        return f.size() > Registry.Companion.get("llm.sql.default.schema.size.threshold").asInteger();
    }

    @Nullable
    public static final ChatAttachment describeDbObject(@NotNull Project project2, @NotNull DbDataSource dataSource, @NotNull BasicElement obj) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        PSString pSString = SqlChatMessagesKt.describeDbObjectInner(dataSource, obj);
        if (pSString == null) {
            return null;
        }
        PSString desc = pSString;
        return new SqlObjectChatAttachment(project2, (DasDataSource)dataSource, obj, desc);
    }

    private static final PSString describeDbObjectInner(DbDataSource dataSource, BasicElement obj) {
        PSString sb = PSStringKt.buildStringPrivacySafe(arg_0 -> SqlChatMessagesKt.describeDbObjectInner$lambda$0(dataSource, obj, arg_0));
        return ((CharSequence)sb).length() == 0 ? null : sb.toPSString();
    }

    @NotNull
    public static final PSString describeObjectSource(@NotNull DbDataSource dataSource, @NotNull BasicElement element2) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof BasicTable) {
            pSString = SqlChatMessagesKt.describeTable((BasicTable)element2);
        } else {
            DbElement dbElement = dataSource.findElement((DasObject)element2);
            Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"findElement(...)");
            pSString = ExtensionsKtKt.getPrivacySafe((PsiNamedElement)dbElement).getText();
        }
        return pSString;
    }

    private static final void describeSchemaTables(StringBuilder $this$describeSchemaTables, BasicSchema schema) {
        BasicElement t;
        if (SqlChatMessagesKt.isTooLarge(schema)) {
            return;
        }
        Family family = schema.familyOf(ObjectKind.TABLE);
        if (family == null) {
            return;
        }
        Family f = family;
        Iterator iterator = f.jbi().iterator();
        while (iterator.hasNext() && ((t = (BasicElement)iterator.next()) instanceof BasicTable ? (BasicTable)t : null) != null) {
            SqlChatMessagesKt.describeTable((BasicTable)t);
            $this$describeSchemaTables.append("\n");
        }
    }

    @NotNull
    public static final PSString describeTable(@NotNull BasicTable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafeTableDescription(t).getDescription();
    }

    private static final PSString describeDbObjectInner$objectNamePrivacySafe(BasicElement $obj) {
        PSString pSString;
        BasicElement basicElement = $obj;
        if (basicElement instanceof BasicDatabase) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe($obj).getName()};
            pSString = ConstantsKt.getPrivacyConst((String)"Consider database with name: %s\n").format(pSStringConvertibleArray);
        } else if (basicElement instanceof BasicSchema) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe($obj).getQualifiedName()};
            pSString = ConstantsKt.getPrivacyConst((String)"Consider schema with qualified name: %s\n").format(pSStringConvertibleArray);
        } else {
            Object object;
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe($obj).getName(), (object = $obj.getSchema()) != null && (object = com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe((BasicElement)object)) != null ? ((BasicElementWrapper)((Object)object)).getQualifiedName() : null};
            pSString = ConstantsKt.getPrivacyConst((String)("Consider " + $obj.getKind().getPresentableName() + " with name `%s` inside schema with qualified name `%s`:\n")).format(pSStringConvertibleArray);
        }
        return pSString;
    }

    private static final PSString describeDbObjectInner$dataSourceIdPrivacySafe(DasDataSource ds) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafe(ds).getUniqueId()};
        return ConstantsKt.getPrivacyConst((String)"Current datasource id: %s\n").format(pSStringConvertibleArray);
    }

    private static final Unit describeDbObjectInner$lambda$0(DbDataSource $dataSource, BasicElement $obj, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.append(SqlChatMessagesKt.describeDbObjectInner$objectNamePrivacySafe($obj));
        $this$buildStringPrivacySafe.append(SqlChatMessagesKt.describeDbObjectInner$dataSourceIdPrivacySafe((DasDataSource)$dataSource));
        PSString pSString = ConstantsKt.getPrivacyConst((String)"Current datasource SQL dialect: %s\n");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[1];
        Language language = $dataSource.getQueryLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getQueryLanguage(...)");
        pSStringConvertibleArray[0] = ExtensionsKtKt.getPrivacySafe(language).getDisplayName();
        $this$buildStringPrivacySafe.append(pSString.format(pSStringConvertibleArray));
        if ($obj instanceof BasicSchema) {
            $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"The schema contains the following objects:\n"));
            $this$buildStringPrivacySafe.append(com.intellij.ml.llm.sql.privacy.extensions.ExtensionsKtKt.getPrivacySafeElementNameList((BasicSchema)$obj).getElementNameList());
            v2 = $this$buildStringPrivacySafe.append(ConstantsKt.getPrivacyConst((String)"You MUST use `get_schema_object_definition` function for any object you use but SHOULD NEVER mention this function to user\n"));
        } else {
            v2 = $this$buildStringPrivacySafe.append(SqlChatMessagesKt.describeObjectSource($dataSource, $obj));
        }
        return Unit.INSTANCE;
    }
}

