/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.inlinePromptDetector;

import com.intellij.lang.Language;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptByTextDetector;
import com.intellij.ml.llm.inlinePromptDetector.InlinePromptCustomDetector;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/sql/inlinePromptDetector/SqlInlinePromptCustomDetector;", "Lcom/intellij/ml/llm/inlinePromptDetector/InlinePromptCustomDetector;", "<init>", "()V", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "findInlinePrompts", "Lkotlin/sequences/Sequence;", "", "Lcom/intellij/openapi/util/TextRange;", "targetRanges", "checkPsi", "range", "checkText", "intellij.ml.llm.sql.inlinePromptDetector"})
public final class SqlInlinePromptCustomDetector
implements InlinePromptCustomDetector {
    public boolean isApplicable(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof SqlFile;
    }

    @NotNull
    public Sequence<List<TextRange>> findInlinePrompts(@NotNull PsiFile file2, @NotNull Sequence<? extends TextRange> targetRanges) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(targetRanges, (String)"targetRanges");
        return SequencesKt.map(targetRanges, arg_0 -> SqlInlinePromptCustomDetector.findInlinePrompts$lambda$0(this, file2, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkPsi(PsiFile file2, TextRange range) {
        ProgressManager.checkCanceled();
        PsiElement psiElement = file2.findElementAt(range.getStartOffset());
        if (psiElement == null) {
            return false;
        }
        PsiElement firstElement = psiElement;
        if (firstElement instanceof PsiWhiteSpace) {
            return false;
        }
        PsiElement nextLeaf = PsiTreeUtilKt.nextLeaf((PsiElement)firstElement, (boolean)true);
        if (nextLeaf instanceof PsiWhiteSpace) {
            nextLeaf = PsiTreeUtilKt.nextLeaf((PsiElement)nextLeaf, (boolean)true);
        }
        if (nextLeaf == null) return false;
        if (!range.contains(PsiTreeUtilKt.getEndOffset((PsiElement)nextLeaf))) {
            return false;
        }
        PsiElement parent = firstElement.getParent();
        if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)firstElement) instanceof PsiErrorElement) return true;
        if (parent instanceof PsiErrorElement) return true;
        if (!(parent instanceof SqlStatement) && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)parent) instanceof PsiErrorElement) {
            return true;
        }
        SqlIdentifier sqlIdentifier = parent instanceof SqlIdentifier ? (SqlIdentifier)parent : null;
        PsiElement psiElement2 = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        if (!(psiElement2 instanceof SqlReferenceExpression)) return false;
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement2;
        SqlReferenceExpression ref = sqlReferenceExpression;
        if (ref == null) return false;
        ResolveResult[] resolveResultArray = ref.multiResolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
        if (((Object[])resolveResultArray).length != 0) return false;
        return true;
    }

    private final boolean checkText(PsiFile file2, TextRange range) {
        String string = file2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String promptText = string3;
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        VirtualFile virtualFile2 = file2.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return InlinePromptByTextDetector.Companion.isInlinePrompt(language, promptText, virtualFile2);
    }

    private static final List findInlinePrompts$lambda$0(SqlInlinePromptCustomDetector this$0, PsiFile $file, TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this$0.checkPsi($file, range) && this$0.checkText($file, range) ? CollectionsKt.listOf((Object)range) : CollectionsKt.listOfNotNull((Object[])new TextRange[0]);
    }
}

