/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.inspections;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRenderer;
import com.intellij.ml.llm.codeGeneration.diff.ineditor.AIInEditorDiffRendererKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/sql/inspections/SqlAIInEditorDiffRenderer;", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "initialDocument", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/openapi/editor/Document;)V", "render", "", "withGutter", "", "doRender", "Companion", "intellij.ml.llm.sql"})
public final class SqlAIInEditorDiffRenderer
extends AIInEditorDiffRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SqlAIInEditorDiffRenderer(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @NotNull Document initialDocument) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)initialDocument, (String)"initialDocument");
        super(editor2, project2, fileType2, initialDocument);
    }

    @Override
    public void render(boolean withGutter) {
        this.clear();
        this.doRender(withGutter);
    }

    private final void doRender(boolean withGutter) {
        String string = this.getInitialDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.setRenderedChanges(AIInEditorDiffRendererKt.calculateChanges(string, string2));
        for (LineFragment change : this.getRenderedChanges()) {
            boolean insertedRangeIsEmpty;
            boolean deletedRangeIsEmpty = change.getEndLine1() - change.getStartLine1() == 0;
            boolean bl = insertedRangeIsEmpty = change.getEndLine2() - change.getStartLine2() == 0;
            if (!insertedRangeIsEmpty && !deletedRangeIsEmpty) {
                this.renderSimpleModifiedCodeRange(change, withGutter);
                continue;
            }
            if (!insertedRangeIsEmpty) {
                this.renderInsertedCodeRange(change, withGutter, false);
                continue;
            }
            if (!deletedRangeIsEmpty) {
                this.renderDeletedCodeInlay(change, withGutter);
                continue;
            }
            throw new IllegalStateException("Unexpected change, both deleted and inserted ranges are empty");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/sql/inspections/SqlAIInEditorDiffRenderer$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ml/llm/codeGeneration/diff/ineditor/AIInEditorDiffRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "originalDocument", "Lcom/intellij/openapi/editor/Document;", "codeRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.ml.llm.sql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AIInEditorDiffRenderer create(@NotNull Editor editor2, @NotNull Project project2, @Nullable FileType fileType2, @NotNull Document originalDocument, @NotNull TextRange codeRange) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)originalDocument, (String)"originalDocument");
            Intrinsics.checkNotNullParameter((Object)codeRange, (String)"codeRange");
            String string = originalDocument.getText(codeRange);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String originalText = string;
            VirtualFile virtualFile2 = editor2.getVirtualFile();
            Intrinsics.checkNotNull((Object)virtualFile2);
            Document initialDocument = VirtualFileUtil.findDocument((VirtualFile)((VirtualFile)new LightVirtualFile("initial-" + virtualFile2.getName(), fileType2, (CharSequence)originalText)));
            if (initialDocument == null) {
                throw new IllegalStateException("Cannot create in memory document for comparison");
            }
            initialDocument.setReadOnly(true);
            return new SqlAIInEditorDiffRenderer(editor2, project2, fileType2, initialDocument);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

