/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.inspections;

import ai.grazie.model.task.id.TaskName;
import com.intellij.lang.Language;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.chat.context.ChatContextItem;
import com.intellij.ml.llm.core.chat.session.ChatCreationContext;
import com.intellij.ml.llm.core.chat.session.ChatOrigin;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.core.chat.ui.AIAssistantUIUtil;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.ChatIntentionTaskParameters;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.SqlExplainProblemTaskCallBuilder;
import com.intellij.ml.llm.grazie.tasks.intentions.sql.SqlExplainProblemTask;
import com.intellij.ml.llm.intentions.chat.AbstractChatIntention;
import com.intellij.ml.llm.intentions.chat.ChatIntentionTarget;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.inspections.UtilsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\r\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J0\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0094@\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010#\u001a\u00020$H\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/sql/inspections/SqlExplainProblemIntention;", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "inspectionMessage", "Lcom/intellij/ml/llm/privacy/PSString;", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPrompt", "Lcom/intellij/ml/llm/intentions/chat/AbstractChatIntention$Prompt;", "intentionTarget", "Lcom/intellij/ml/llm/intentions/chat/ChatIntentionTarget;", "getChatCreationContext", "Lcom/intellij/ml/llm/core/chat/session/ChatCreationContext;", "extraItems", "", "Lcom/intellij/ml/llm/core/chat/context/ChatContextItem;", "sourceFile", "selectionRange", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/RangeMarker;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTask", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskCall;", "parameters", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/ChatIntentionTaskParameters;", "getTaskName", "Lai/grazie/model/task/id/TaskName;", "intellij.ml.llm.sql"})
public final class SqlExplainProblemIntention
extends AbstractChatIntention {
    @Nullable
    private PSString inspectionMessage;

    public SqlExplainProblemIntention() {
        super(null, 1, null);
    }

    @NotNull
    public String getFamilyName() {
        return SqlLLMBundle.message("explain.problem.action.family.text", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (!(super.isAvailable(project2, editor2, psiFile) && psiFile instanceof SqlFile && AIAssistantUIUtil.INSTANCE.hasAvailableLlmProfileId(LLMPromptsKt.getINTENTION_EXPLAIN_CODE_PROMPT_ID()))) {
            return false;
        }
        this.inspectionMessage = UtilsKt.extractInspectionMessageAtCaret(project2, editor2);
        return this.inspectionMessage != null;
    }

    @Deprecated(message="Use Task API instead", replaceWith=@ReplaceWith(expression="createTask(builder, intentionTarget)", imports={}))
    @Nullable
    public AbstractChatIntention.Prompt getPrompt(@NotNull Project project2, @Nullable Editor editor2, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        PSString pSString = this.inspectionMessage;
        if (pSString == null) {
            return null;
        }
        PSString message = pSString;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((List)intentionTarget.getSelectedElements());
        if (psiElement == null) {
            psiElement = (PsiElement)intentionTarget.getFile();
        }
        PsiElement element2 = psiElement;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        PSString lang = ExtensionsKtKt.getPrivacySafe((Language)sqlLanguageDialectEx).getDisplayName();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{message, lang};
        return new AbstractChatIntention.Prompt(ConstantsKt.getPrivacyConst((String)"Explain the \"%s\" problem(s) in the following %s code:\n$SELECTION").format(pSStringConvertibleArray), null, 2, null);
    }

    @Nullable
    protected Object getChatCreationContext(@NotNull List<ChatContextItem> extraItems, @Nullable PsiFile sourceFile, @Nullable RangeMarker selectionRange, @NotNull Continuation<? super ChatCreationContext> $completion) {
        return new ChatCreationContext((ChatOrigin)ChatOrigin.CustomIntention.INSTANCE, ChatSourceAction.EXPLAIN_CODE_INTENTION, sourceFile, extraItems, null, 16, null);
    }

    @Nullable
    protected PrivacySafeTaskCall createTask(@NotNull ChatIntentionTaskParameters parameters, @NotNull ChatIntentionTarget intentionTarget) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)intentionTarget, (String)"intentionTarget");
        PSString pSString = this.inspectionMessage;
        if (pSString == null) {
            return null;
        }
        PSString message = pSString;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((List)intentionTarget.getSelectedElements());
        if (psiElement == null) {
            psiElement = (PsiElement)intentionTarget.getFile();
        }
        PsiElement element2 = psiElement;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        PSString lang = ExtensionsKtKt.getPrivacySafe((Language)sqlLanguageDialectEx).getDisplayName();
        return new SqlExplainProblemTaskCallBuilder(parameters, lang, message).build();
    }

    @NotNull
    protected TaskName getTaskName() {
        return SqlExplainProblemTask.INSTANCE.getName();
    }
}

